/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.misc;

import com.foxxite.timeinabottle.misc.Common;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Language {
    private final Plugin plugin;
    private Boolean hasPlaceholderAPI = false;
    private File langConfigFile;
    private FileConfiguration langConfig;

    public Language(Plugin plugin) {
        this.plugin = plugin;
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            System.out.println("[TIAB] Hooked into PAPI");
            this.hasPlaceholderAPI = true;
        }
        try {
            this.createLangConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean reloadConfig() {
        try {
            this.createLangConfig();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private FileConfiguration getLangConfig() {
        return this.langConfig;
    }

    public String getMessage(String key) {
        String output = this.getLangConfig().getString(key);
        if (output == null) {
            HashMap<String, String> placeholder = new HashMap<String, String>();
            placeholder.put("{key}", key);
            return Common.colorize(this.getMessage("key-missing", placeholder));
        }
        output = this.addInternalPlaceholders(output);
        return Common.colorize(output);
    }

    public String getMessage(String key, Player player) {
        return this.addPAPIPlaceholders(this.getMessage(key), player);
    }

    public String getMessage(String key, HashMap<String, String> customPlaceholders) {
        String output = this.getMessage(key);
        output = this.addCustomPlaceholders(output, customPlaceholders);
        return Common.colorize(output);
    }

    public String getMessage(String key, Player player, HashMap<String, String> customPlaceholders) {
        String output = this.getMessage(key, customPlaceholders);
        output = this.addPAPIPlaceholders(output, player);
        output = this.addCustomPlaceholders(output, customPlaceholders);
        return Common.colorize(output);
    }

    public ArrayList<String> getListMessage(String key) {
        ArrayList<String> outputList = new ArrayList<String>();
        List rawList = this.getLangConfig().getStringList(key);
        for (String line : rawList) {
            outputList.add(Common.colorize(this.addInternalPlaceholders(line)));
        }
        return outputList;
    }

    public ArrayList<String> getListMessage(String key, Player player) {
        ArrayList<String> outputList = new ArrayList<String>();
        List rawList = this.getLangConfig().getStringList(key);
        for (String line : rawList) {
            outputList.add(Common.colorize(this.addPAPIPlaceholders(this.addInternalPlaceholders(line), player)));
        }
        return outputList;
    }

    public ArrayList<String> getListMessage(String key, HashMap<String, String> customPlaceholders) {
        ArrayList<String> outputList = new ArrayList<String>();
        List rawList = this.getLangConfig().getStringList(key);
        for (String line : rawList) {
            outputList.add(Common.colorize(this.addCustomPlaceholders(this.addInternalPlaceholders(line), customPlaceholders)));
        }
        return outputList;
    }

    public ArrayList<String> getListMessage(String key, Player player, HashMap<String, String> customPlaceholders) {
        ArrayList<String> outputList = new ArrayList<String>();
        List rawList = this.getLangConfig().getStringList(key);
        for (String line : rawList) {
            outputList.add(Common.colorize(this.addCustomPlaceholders(this.addPAPIPlaceholders(this.addInternalPlaceholders(line), player), customPlaceholders)));
        }
        return outputList;
    }

    private String addInternalPlaceholders(String string) {
        String output = string;
        output = output.replace("{prefix}", this.getLangConfig().getString("prefix"));
        output = output.replace("{version}", this.plugin.getDescription().getVersion());
        output = output.replace("{author}", (CharSequence)this.plugin.getDescription().getAuthors().get(0));
        return output;
    }

    private String addPAPIPlaceholders(String string, Player player) {
        if (this.hasPlaceholderAPI.booleanValue()) {
            string = PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        return string;
    }

    private String addCustomPlaceholders(String string, HashMap<String, String> customPlaceholders) {
        for (Map.Entry<String, String> customPlaceholderEntry : customPlaceholders.entrySet()) {
            string = string.replace(customPlaceholderEntry.getKey(), customPlaceholderEntry.getValue());
        }
        return string;
    }

    public String constructTimeFormat(int hours, int minutes, int seconds) {
        String timeFormat = this.getLangConfig().getString("time-format");
        timeFormat = timeFormat.replace("{hours}", Integer.toString(hours));
        timeFormat = timeFormat.replace("{minutes}", Integer.toString(minutes));
        timeFormat = timeFormat.replace("{seconds}", Integer.toString(seconds));
        return timeFormat;
    }

    public String constructTimeFormat(String hours, String minutes, String seconds) {
        String timeFormat = this.getLangConfig().getString("time-format");
        timeFormat = timeFormat.replace("{hours}", hours);
        timeFormat = timeFormat.replace("{minutes}", minutes);
        timeFormat = timeFormat.replace("{seconds}", seconds);
        return timeFormat;
    }

    private void createLangConfig() throws IOException {
        this.langConfigFile = new File(this.plugin.getDataFolder(), "lang.yml");
        if (!this.langConfigFile.exists()) {
            this.langConfigFile.getParentFile().mkdirs();
            this.plugin.saveResource("lang.yml", false);
        } else {
            try {
                YamlConfiguration tempLang = YamlConfiguration.loadConfiguration((File)this.langConfigFile);
                InputStream internalLangFile = this.plugin.getResource("lang.yml");
                InputStreamReader internalLangFileReader = new InputStreamReader(internalLangFile);
                YamlConfiguration internalLang = YamlConfiguration.loadConfiguration((Reader)internalLangFileReader);
                if (tempLang.getInt("file-version") != internalLang.getInt("file-version")) {
                    File oldLangFile = new File(this.plugin.getDataFolder(), "lang_old.yml");
                    this.langConfigFile.getParentFile().mkdirs();
                    tempLang.save(oldLangFile);
                    this.langConfigFile.getParentFile().mkdirs();
                    this.plugin.saveResource("lang.yml", true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.langConfig = new YamlConfiguration();
        try {
            this.langConfig.load(this.langConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

