/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.tasks;

import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.TimedBlock;
import com.foxxite.timeinabottle.misc.Common;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class DrawParticle
extends TimerTask {
    private final Plugin plugin;

    public DrawParticle(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        try {
            if (TimeInABottle.timedBlocks.size() > 0) {
                for (Map.Entry<Block, TimedBlock> timedBlockEntry : TimeInABottle.timedBlocks.entrySet()) {
                    Bukkit.getScheduler().runTask(this.plugin, () -> {
                        Location blockLocation;
                        TimedBlock timedBlock = (TimedBlock)timedBlockEntry.getValue();
                        long currentTime = System.currentTimeMillis() / 1000L;
                        Location particleLocation = blockLocation = timedBlock.block.getLocation();
                        particleLocation.setX(particleLocation.getX() + 0.5);
                        particleLocation.setY(particleLocation.getY() + 1.0);
                        particleLocation.setZ(particleLocation.getZ() + 0.5);
                        if (currentTime > timedBlock.startTime + 30L || timedBlock.blockMaterial != timedBlock.block.getType() || !TimeInABottle.pluginConfig.getConfig().getStringList("enabled-blocks").contains(timedBlock.blockMaterial.toString()) && !TimeInABottle.pluginConfig.getConfig().getBoolean("bottle.unknown-blocks")) {
                            particleLocation.getWorld().spawnParticle(Particle.SMOKE_LARGE, particleLocation, 0, 0.0, 0.0, 0.0, 1.0);
                            particleLocation.getWorld().playSound(particleLocation, Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            timedBlock.ResetBlock();
                            TimeInABottle.timedBlocks.remove(timedBlock.block);
                        } else {
                            double blue;
                            double green;
                            double red;
                            long timeLeft = currentTime - timedBlock.startTime;
                            switch (timedBlock.state) {
                                case 0: {
                                    red = 0.6078431372549019;
                                    green = 0.19607843137254902;
                                    blue = 1.0;
                                    break;
                                }
                                case 1: {
                                    red = 0.0;
                                    green = 0.39215686274509803;
                                    blue = 1.0;
                                    break;
                                }
                                case 2: {
                                    red = 1.0;
                                    green = 1.0;
                                    blue = 0.0;
                                    break;
                                }
                                case 3: {
                                    red = 1.0;
                                    green = 0.5686274509803921;
                                    blue = 0.19607843137254902;
                                    break;
                                }
                                case 4: {
                                    red = 1.0;
                                    green = 1.0;
                                    blue = 1.0;
                                    break;
                                }
                                default: {
                                    red = 1.0;
                                    green = 0.0196078431372549;
                                    blue = 0.19607843137254902;
                                }
                            }
                            for (int i = 0; i < 6; ++i) {
                                particleLocation.getWorld().spawnParticle(Particle.SPELL_MOB, particleLocation, 0, red, green, blue, 1.0);
                            }
                        }
                    });
                }
            }
        }
        catch (ConcurrentModificationException ex) {
            System.out.println(Common.colorize("&cAn error occurred (" + ex.getMessage() + "), skipping particle draw in: " + this.getClass().getName()));
        }
    }
}

