/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.tasks;

import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.TimeInABottleItem;
import com.foxxite.timeinabottle.misc.Common;
import com.foxxite.timeinabottle.misc.Config;
import com.foxxite.timeinabottle.misc.Language;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class UpdatePlayTime
extends TimerTask {
    private final Plugin plugin;
    private final TimeInABottleItem timeInABottleItem;
    private final Language language;
    private final Config config;

    public UpdatePlayTime(TimeInABottle plugin) {
        this.plugin = plugin;
        this.language = plugin.getLanguage();
        this.config = plugin.getPluginConfig();
        this.timeInABottleItem = new TimeInABottleItem((Plugin)plugin, this.language);
    }

    @Override
    public void run() {
        try {
            if (Bukkit.getServer().getOnlinePlayers().size() > 0) {
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    Bukkit.getScheduler().runTask(this.plugin, () -> {
                        PlayerInventory playerInventory = player.getInventory();
                        ArrayList<Integer> slots = this.searchInventory(player);
                        if (slots.size() > 0) {
                            for (int slot : slots) {
                                int storedSeconds;
                                ItemStack bottleItem = playerInventory.getContents()[slot];
                                ItemMeta bottleMeta = bottleItem.getItemMeta();
                                ArrayList<String> newLore = bottleMeta.getLore();
                                String stringSeconds = ChatColor.stripColor((String)((String)newLore.get(2)));
                                if (stringSeconds.isEmpty()) {
                                    stringSeconds = "0";
                                }
                                storedSeconds = (storedSeconds = Integer.parseInt(stringSeconds)) < this.config.getConfig().getInt("bottle.max-time") && storedSeconds <= Integer.MAX_VALUE ? ++storedSeconds : this.config.getConfig().getInt("bottle.max-time");
                                int hours = storedSeconds / 3600;
                                int minutes = storedSeconds % 3600 / 60;
                                int seconds = storedSeconds % 60;
                                String timeFormat = this.language.constructTimeFormat(hours, minutes, seconds);
                                HashMap<String, String> customPlaceholder = new HashMap<String, String>();
                                customPlaceholder.put("{hours}", "0");
                                customPlaceholder.put("{minutes}", "0");
                                customPlaceholder.put("{seconds}", "0");
                                customPlaceholder.put("{timeFormat}", timeFormat);
                                newLore = this.language.getListMessage("bottle-lore", customPlaceholder);
                                newLore.set(2, Common.colorize("&0" + storedSeconds));
                                bottleMeta.setLore(newLore);
                                bottleItem.setItemMeta(bottleMeta);
                            }
                        }
                    });
                }
            }
        }
        catch (ConcurrentModificationException ex) {
            System.out.println(Common.colorize("&cAn error occurred (" + ex.getMessage() + "), skipping playtime update in: " + this.getClass().getName()));
        }
    }

    ArrayList<Integer> searchInventory(Player player) {
        int slot = 0;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        PlayerInventory playerInventory = player.getInventory();
        for (ItemStack checkItem : playerInventory.getContents()) {
            if (checkItem != null && checkItem.getType() == Material.EXPERIENCE_BOTTLE && checkItem.getItemMeta().getDisplayName().equals(this.timeInABottleItem.bottleName)) {
                slots.add(slot);
            }
            ++slot;
        }
        return slots;
    }
}

