﻿/* Simple AJAX Code-Kit (SACK) v1.6.1 */
/* ??005 Gregory Wild-Smith */
/* www.twilightuniverse.com */
/* Software licenced under a modified X11 licence,
 see documentation or authors website for more details */
function OHSAjax(file)
{
    this.xmlhttp = null;
    this.response;
	this.async;
    this.method;
	
	//this.xmlhttp.getAllResponseHeaders()
	//function declare
	//this.stateChangeHandler=function () {};
	// setRequestHeader("Referer","http://www.dc9.cn/xx.html");
	//setRequestHeader("Host","reg.163.com");
	this.setRequestHeader=function (key,val) 
	{
	    if (this.xmlhttp) 
	    {//all HTTP request header settings must be made before the .send() method call, 
	    //but must be made after that .open() method call.
	        this.xmlhttp.setRequestHeader(key,val); 
	    } 
	};//
	
	this.setRequestHeader=null;
	
    this.resetData = function()
    {
        this.method = "POST";
        this.queryStringSeparator = "?";
        this.argumentSeparator = "&";
        this.URLString = "";
        this.response= "";
        this.encodeURIString = true;
        this.execute = false;
        this.element = null;
        this.elementObj = null;
        this.requestFile = file;
        this.vars = new Object();
        this.responseStatus = new Array(2);
    };//
    
    this.resetFunctions = function()
    {
        this.onLoading = function()
        {
        };
        this.onLoaded = function()
        {
        };
        this.onInteractive = function()
        {
        };
        this.onCompletion = function()
        {
			//alert('');
        };
        this.onError = function()
        {
        };
        this.onFail = function()
        {
        };
    };//this.resetFunctions = function()
    
    this.reset = function()
    {
        this.resetFunctions();
        this.resetData();
    };//
	
	//mztreeview jsframework.js
    this._parseResponseText = function(s)
	{
	    if (null == s || "\uFFFD" == s.charAt(0)) 
	    {
	        //System._alert(System.MISCODING);
	        return "";
	    }
	    if ("\xef" == s.charAt(0)) 
	        s = s.substr(3); //for firefox
	    return s.replace(/(^|\n)\s*\/\/+\s*((Using|Import|Include)\((\"|\'))/g, "$1$2");
	};//
	//stateChangeHandler will fire when the state has changed, i.e. data is received back 
	// This is non-blocking (asynchronous) 
	this.stateChangeHandler=function () 
	{ 
		//readyState of 4 or 'complete' represents that data has been returned 
		if (this.xmlhttp &&(this.xmlhttp.readyState == 4 || this.xmlhttp.readyState == 'complete'))
		{ 
                switch (this.xmlhttp.readyState)
                {
                    case 1:
                        this.onLoading();
                        break;
                        
                    case 2:
                        this.onLoaded();
                        break;
                        
                    case 3:
                        this.onInteractive();
                        break;
                        
                    default:
                        if (this.xmlhttp.readyState == 4 || this.xmlhttp.readyState.toLowerCase() == 'complete')
                        {
						
					        //alert(this.xmlhttp.responseText);
                            this.response = this._parseResponseText(this.xmlhttp.responseText);
							
                            this.responseXML = this.xmlhttp.responseXML;
                            this.responseStatus[0] = this.xmlhttp.status;
                            this.responseStatus[1] = this.xmlhttp.statusText;
                             
                            if (this.execute) 
                            {
                                this.runResponse();
                            }
                            
                            if (this.elementObj) 
                            {
                                elemNodeName = this.elementObj.nodeName;
                                elemNodeName.toLowerCase();
                                if (elemNodeName == "input" ||
                                elemNodeName == "select" ||
                                elemNodeName == "option" ||
                                elemNodeName == "textarea") 
                                {
                                    this.elementObj.value = this.response;
                                }
                                else 
                                {
                                    this.elementObj.innerHTML = this.response;
                                }
                            }
							
							
						    //alert(self.xmlhttp.status);//输出状态看看是200
                            if (this.responseStatus[0] == "200") 
                            {
                                this.onCompletion();
                                //解决ff下，ajax返回两次的问题
								this.xmlhttp.abort();
                            }
                            else 
                            {
                                this.onError();
                            }
                            
                            this.URLString = "";                            
                        }// if (self.xmlhttp.readyState == 4 || self.xmlhttp.readyState == 'complete')
                        else
                        {
                                this.vars = null;
                                this.responseStatus = null;
                                this.xmlhttp =null;
                        }

                        break;
                }//switch
		}//if (this.xmlhttp.readyState == 4 || this.xmlhttp.readyState == 'complete') 
	};//this.stateChangeHandler=function ()  
		
		
    this.createAJAX = function()
    {  
        if (Comm.ie) 
        {
            //IE"Msxml2.XMLHTTP.7.0",
            //"MSXML.XMLHTTP", 
            //"Microsoft.XMLHTTP",             
            var MSXML = [
			"Msxml2.XMLHTTP.6.0",
			"Msxml2.XMLHTTP.5.0",
			"Msxml2.XMLHTTP.4.0", 
            "Msxml2.XMLHTTP.3.0",
			"Msxml2.XMLHTTP.2.6",
			"Msxml2.XMLHTTP", 
            "Microsoft.XMLHTTP.1.0",
			"Microsoft.XMLHTTP.1",
			"Microsoft.XMLHTTP" ];
			
            for(var i = 0; i < MSXML.length; i++)
            {
                try
                {
                    this.xmlhttp = new ActiveXObject(MSXML[i]);
                    break;
                }
                catch(e)
                {
					this.xmlhttp = null;  
					//continue;                  
                }
            }//for        
        }else if (Comm.isOpera)
        { 
			//Opera has some issues with xmlHttp object functionality 
			//alert('Opera detected. The page may not behave as expected.'); 
			return; 
		} 
		else
		{ 
			// Mozilla | Netscape | Safari 
            //mozilla 
            this.xmlhttp=new XMLHttpRequest();
            //有些版本的Mozilla浏览器处理服务器返回的未包含XML mime-type头部信息的内容时会出错。因此，要确保返回的内容包含text/xml信息
            if (this.xmlhttp.overrideMimeType)
            {
                this.xmlhttp.overrideMimeType="text/xml";//
            }
            //come from "Implementing AJAX Using ASP.NET 1.1" example
            this.xmlhttp.onload  = this.stateChangeHandler.bind(this);//bind come from prototype.js 
			this.xmlhttp.onerror = this.stateChangeHandler.bind(this);		
		}
		
		
		if (!this.xmlhttp && typeof XMLHttpRequest == "undefined") 
        {
              //alert('this.xmlhttp==0');
              this.failed = true; 
        }
        
        this.xmlhttp.onreadystatechange = this.stateChangeHandler.bind(this);
    };//this.createAJAX = function()
    
    this.setVar = function(name, value)
    {
        this.vars[name] = Array(value, false);
    };
    
    this.encVar = function(name, value, returnvars)
    {
        if (true == returnvars) 
        {
            return Array(encodeURIComponent(name), encodeURIComponent(value));
        }
        else 
        {
            this.vars[encodeURIComponent(name)] = Array(encodeURIComponent(value), true);
        }
    };//this.encVar = function(name, value, returnvars)
    
    this.processURLString = function(string, encode)
    {
        encoded = encodeURIComponent(this.argumentSeparator);
        regexp = new RegExp(this.argumentSeparator + "|" + encoded);
        varArray = string.split(regexp);
        for (i = 0; i < varArray.length; i++) 
        {
            urlVars = varArray[i].split("=");
            if (true == encode) 
            {
                this.encVar(urlVars[0], urlVars[1]);
            }
            else 
            {
                this.setVar(urlVars[0], urlVars[1]);
            }
        }
		delete regexp;regexp=null;
    };// this.processURLString = function(string, encode)
    
    this.createURLString = function(urlstring)
    {
        if (this.encodeURIString && this.URLString.length) 
        {
            this.processURLString(this.URLString, true);
        }
        
        if (urlstring) 
        {
            if (this.URLString.length) 
            {
                this.URLString += this.argumentSeparator + urlstring;
            }
            else 
            {
                this.URLString = urlstring;
            }
        }
        
        // prevents caching of URLString
		var s = (Math.random()*1000000).toFixed(0);
        this.setVar("rndval", s);//new Date().getTime());
        
        urlstringtemp = new Array();
        for (key in this.vars) 
        {
            if (false == this.vars[key][1] && true == this.encodeURIString) 
            {
                encoded = this.encVar(key, this.vars[key][0], true);
                delete this.vars[key];
                this.vars[encoded[0]] = Array(encoded[1], true);
                key = encoded[0];
            }
            
            urlstringtemp[urlstringtemp.length] = key + "=" + this.vars[key][0];
        }
        if (urlstring) 
        {
            this.URLString += this.argumentSeparator + urlstringtemp.join(this.argumentSeparator);
        }
        else 
        {
            this.URLString += urlstringtemp.join(this.argumentSeparator);
        }
		delete urlstringtemp;
		urlstringtemp=0;
    };//this.createURLString = function(urlstring)
    
    this.runResponse = function()
    {
        eval(this.response);
    };
    
    this.release=function () 
    {
        this.vars = null;
        this.responseStatus = null;
        this.xmlhttp =null;
        
    };
		
    this.runAJAX = function(urlstring)
    {
        if (this.failed) 
        {
			
            this.onFail();
        }
        else 
        {
            this.createURLString(urlstring);
            if (this.element) 
            {
                this.elementObj = document.getElementById(this.element);
            }
            if (this.xmlhttp) 
            { 
                var self = this;
				//<option   value="image/bmp">BMP</option>  
				//<option   value="image/gif">GIF</option>  
				//<option   value="image/jpeg">JPEG</option>  
				//<option   value="image/tiff">TIFF</option>  
				//<option   value="image/x-dcx">DCX</option>  
				//<option   value="image/x-pcx">PCX</option>  
				//<option   value="text/html">HTML</option>  
				//<option   value="text/plain">TXT</option>  
				//<option   value="text/xml">XML</option>  
				//<option   value="application/afp">AFP</option>  
				//<option   value="application/pdf">PDF</option>  
				//<option   value="application/rtf">RTF</option>  
				//<option   value="application/msword">MSWORD</option>  
				//<option   value="application/vnd.ms-excel">MSEXCEL</option>  
				//<option   value="application/vnd.ms-powerpoint">MSPOWERPOINT</option>  
				//<option   value="application/wordperfect5.1">WORDPERFECT</option>  
				//<option   value="application/vnd.lotus-wordpro">WORDPRO</option>  
				//<option   value="application/vnd.visio">VISIO</option>  
				//<option   value="application/vnd.framemaker">FRAMEMAKER</option>  
				//<option   value="application/vnd.lotus-1-2-3">LOTUS123</option>
				//response.setContentType("text/html;charset=utf-8");
				this.method = this.method.toUpperCase();

                if (this.method == "GET") 
                {
                    totalurlstring = this.requestFile + this.queryStringSeparator + this.URLString;

					if(typeof this.async == "undefined" || this.async == null )
					{
						this.xmlhttp.open(this.method, totalurlstring, false);
					}else
					{
						 
						this.xmlhttp.open(this.method, totalurlstring, this.async);
					}
 
                }
                else 
                {
					if(typeof this.async == "undefined" || this.async == null )
					{
						this.xmlhttp.open(this.method, this.requestFile, false);
					}else
					{
						this.xmlhttp.open(this.method, this.requestFile, this.async);
					}
                    
                    try 
                    {
                        this.xmlhttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded")
                    } 
                    catch (e) 
                    {
                    }
                }
                
                if (this.setRequestHeader) 
                {
                   eval(this.setRequestHeader);
                   //alert(this.setRequestHeader);
 
                }
				// Build the URL to connect to
				//var url = "/scripts/getZipCode.php?city=" + escape(city) + "&state=" + escape(state);
				// Open a connection to the server
				//xmlHttp.open("GET", url, true);
				// Setup a function for the server to run when it's done
				//xmlHttp.onreadystatechange = updatePage;
				// Send the request
				//xmlHttp.send(null);


				//xmlHttp.open("POST",url,true);
				//xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
				//xmlHttp.send("keyword="+keyword);
                //this.xmlhttp.onreadystatechange = this.stateChangeHandler;
                
				if (this.method == "GET") 
				{
					this.xmlhttp.send(null);
				}else
				{
					this.xmlhttp.send(this.URLString);
				}
                
            }
        }
    };//this.runAJAX = function(urlstring)
    
    this.reset();
    this.createAJAX();
};
