/*
 * Decompiled with CFR 0.152.
 */
package me.leon.toolsfx.plugin;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J&\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004J\u0010\u0010\"\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020\u0004J\u0016\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004J\u0016\u0010)\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004J\u0016\u0010*\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010+\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lme/leon/toolsfx/plugin/CoordinatorTransform;", "", "()V", "AXIS", "", "OFFSET", "PATTERN_DEGREE_LOCATION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "PI", "X_PI", "bd092GCJ", "", "glat", "glng", "bd092WGS", "bd092WGSExactly", "delta", "wgLat", "wglng", "distance", "latA", "logA", "latB", "logB", "gcj2BD09", "gcj2WGS", "gcj2WGSExactly", "gcjLat", "gcjlng", "outOfChina", "", "lat", "lng", "toDecimal", "location", "", "toDegree", "transformLat", "x", "y", "transformlng", "wgs2BD09", "wgs2GCJ", "plugin-location"})
public final class CoordinatorTransform {
    @NotNull
    public static final CoordinatorTransform INSTANCE = new CoordinatorTransform();
    private static final double PI = Math.PI;
    private static final double AXIS = 6378245.0;
    private static final double OFFSET = 0.006693421622965943;
    private static final double X_PI = 52.35987755982988;
    private static final Pattern PATTERN_DEGREE_LOCATION = Pattern.compile("(\\d{1,3})\u00b0 *(\\d{1,2})\u2032 *(\\d{1,2}\\.\\d+)\u2033");

    private CoordinatorTransform() {
    }

    @NotNull
    public final double[] gcj2BD09(double glat, double glng) {
        double[] latlng = new double[2];
        double z = Math.sqrt(glng * glng + glat * glat) + 2.0E-5 * Math.sin(glat * 52.35987755982988);
        double theta = Math.atan2(glat, glng) + 3.0E-6 * Math.cos(glng * 52.35987755982988);
        latlng[0] = z * Math.sin(theta) + 0.006;
        latlng[1] = z * Math.cos(theta) + 0.0065;
        return latlng;
    }

    @NotNull
    public final double[] bd092GCJ(double glat, double glng) {
        double x = glng - 0.0065;
        double y = glat - 0.006;
        double[] latlng = new double[2];
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        latlng[0] = z * Math.sin(theta);
        latlng[1] = z * Math.cos(theta);
        return latlng;
    }

    @NotNull
    public final double[] bd092WGS(double glat, double glng) {
        double[] latlng = this.bd092GCJ(glat, glng);
        return this.gcj2WGS(latlng[0], latlng[1]);
    }

    @NotNull
    public final double[] bd092WGSExactly(double glat, double glng) {
        double[] latlng = this.bd092GCJ(glat, glng);
        return this.gcj2WGSExactly(latlng[0], latlng[1]);
    }

    @NotNull
    public final double[] wgs2BD09(double wgLat, double wglng) {
        double[] latlng = this.wgs2GCJ(wgLat, wglng);
        return this.gcj2BD09(latlng[0], latlng[1]);
    }

    @NotNull
    public final double[] wgs2GCJ(double wgLat, double wglng) {
        double[] latlng = new double[2];
        if (this.outOfChina(wgLat, wglng)) {
            latlng[0] = wgLat;
            latlng[1] = wglng;
            return latlng;
        }
        double[] deltaD = this.delta(wgLat, wglng);
        latlng[0] = wgLat + deltaD[0];
        latlng[1] = wglng + deltaD[1];
        return latlng;
    }

    @NotNull
    public final double[] gcj2WGS(double glat, double glng) {
        double[] latlng = new double[2];
        if (this.outOfChina(glat, glng)) {
            latlng[0] = glat;
            latlng[1] = glng;
            return latlng;
        }
        double[] deltaD = this.delta(glat, glng);
        latlng[0] = glat - deltaD[0];
        latlng[1] = glng - deltaD[1];
        return latlng;
    }

    @NotNull
    public final double[] gcj2WGSExactly(double gcjLat, double gcjlng) {
        double initDelta = 0.01;
        double threshold = 1.0E-9;
        double dLat = initDelta;
        double dlng = initDelta;
        double mLat = gcjLat - dLat;
        double mlng = gcjlng - dlng;
        double pLat = gcjLat + dLat;
        double plng = gcjlng + dlng;
        double wgsLat = 0.0;
        double wgslng = 0.0;
        double i = 0.0;
        do {
            wgsLat = (mLat + pLat) / (double)2;
            wgslng = (mlng + plng) / (double)2;
            double[] tmp = this.wgs2GCJ(wgsLat, wgslng);
            dLat = tmp[0] - gcjLat;
            dlng = tmp[1] - gcjlng;
            if (Math.abs(dLat) < threshold && Math.abs(dlng) < threshold) break;
            if (dLat > 0.0) {
                pLat = wgsLat;
            } else {
                mLat = wgsLat;
            }
            if (dlng > 0.0) {
                plng = wgslng;
                continue;
            }
            mlng = wgslng;
        } while (!((i += 1.0) > 10000.0));
        double[] latlng = new double[]{wgsLat, wgslng};
        return latlng;
    }

    public final double distance(double latA, double logA, double latB, double logB) {
        double y;
        int earthR = 6371000;
        double x = Math.cos(Math.toRadians(latA)) * Math.cos(Math.toRadians(latB)) * Math.cos(Math.toRadians(logA - logB));
        double s = x + (y = Math.sin(Math.toRadians(latA)) * Math.sin(Math.toRadians(latB)));
        if (s > 1.0) {
            s = 1.0;
        }
        if (s < -1.0) {
            s = -1.0;
        }
        double alpha = Math.acos(s);
        return alpha * (double)earthR;
    }

    @NotNull
    public final double[] delta(double wgLat, double wglng) {
        double[] latlng = new double[2];
        double dLat = this.transformLat(wglng - 105.0, wgLat - 35.0);
        double dlng = this.transformlng(wglng - 105.0, wgLat - 35.0);
        double radLat = Math.toRadians(wgLat);
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        latlng[0] = dLat;
        latlng[1] = dlng;
        return latlng;
    }

    public final boolean outOfChina(double lat, double lng) {
        if (lng < 72.004 || lng > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    public final double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + (double)320 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    public final double transformlng(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    @NotNull
    public final String toDegree(double location) {
        int degree = (int)location;
        double decimal = location - (double)degree;
        int min = (int)(decimal * (double)60);
        double sec = (decimal * (double)60 - (double)min) * (double)60;
        String string = "%s\u00b0%d\u2032%.2f\u2033";
        Object[] objectArray = new Object[]{degree, min, sec};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    public final double toDecimal(@Nullable String location) {
        Matcher matcher = PATTERN_DEGREE_LOCATION.matcher(location);
        double degree = 0.0;
        if (matcher.matches()) {
            int n = matcher.groupCount();
            for (int i = 0; i < n; ++i) {
                String string = matcher.group(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(i + 1)");
                degree += Double.parseDouble(string) * Math.pow(60.0, -((double)i));
            }
        }
        return degree;
    }
}

