/*
 * Decompiled with CFR 0.152.
 */
package me.leon;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.FactorDbResponse;
import me.leon.Kgcd;
import me.leon.ext.GsonUtilKt;
import me.leon.ext.NetKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\t\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0004\u001a\u0010\u0010\u0010\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0010\u0010\u0017\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u0018\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u001f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u0002*\u00020\u0004\u001a\n\u0010\u001c\u001a\u00020\u0002*\u00020\u001d\u001a\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u001f"}, d2={"getPrimeFromFactorDb", "", "Ljava/math/BigInteger;", "digit", "", "decrypt", "d", "n", "eulerPhi", "", "factorDb", "gcdExt", "", "other", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)[Ljava/math/BigInteger;", "invert", "phi", "isMutualPrime", "", "lcm", "mutualPrime", "n2s", "q", "product", "propN", "root", "(Ljava/math/BigInteger;I)[Ljava/math/BigInteger;", "s2n", "toBigInteger", "", "wiener", "app"})
public final class BigIntegerKt {
    @NotNull
    public static final BigInteger phi(@NotNull BigInteger $this$phi, @NotNull BigInteger q) {
        Intrinsics.checkNotNullParameter((Object)$this$phi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        BigInteger bigInteger = $this$phi;
        BigInteger bigInteger2 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.subtract(other)");
        bigInteger = bigInteger3;
        BigInteger bigInteger4 = q;
        BigInteger bigInteger5 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ONE");
        BigInteger bigInteger6 = bigInteger4.subtract(bigInteger5);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.subtract(other)");
        bigInteger4 = bigInteger6;
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger4);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.multiply(other)");
        return bigInteger7;
    }

    @NotNull
    public static final BigInteger phi(@NotNull BigInteger $this$phi, @NotNull String q) {
        Intrinsics.checkNotNullParameter((Object)$this$phi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return BigIntegerKt.phi($this$phi, new BigInteger(q));
    }

    @NotNull
    public static final BigInteger lcm(@NotNull BigInteger $this$lcm, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$lcm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger bigInteger = $this$lcm.multiply(other);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = $this$lcm.gcd(other);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.gcd(other)");
        BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.divide(other)");
        return bigInteger4;
    }

    public static final boolean mutualPrime(@NotNull BigInteger $this$mutualPrime, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$mutualPrime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$mutualPrime.gcd(other), (Object)BigInteger.ZERO);
    }

    @NotNull
    public static final BigInteger invert(@NotNull BigInteger $this$invert, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$invert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger bigInteger = $this$invert.modInverse(new BigInteger(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modInverse(other.toBigInteger())");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger invert(@NotNull BigInteger $this$invert, @NotNull BigInteger phi) {
        Intrinsics.checkNotNullParameter((Object)$this$invert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)phi, (String)"phi");
        BigInteger bigInteger = $this$invert.modInverse(phi);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modInverse(phi)");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger[] gcdExt(@NotNull BigInteger $this$gcdExt, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$gcdExt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Kgcd.INSTANCE.gcdext($this$gcdExt, other);
    }

    @NotNull
    public static final String decrypt(@NotNull BigInteger $this$decrypt, @NotNull BigInteger d, @NotNull BigInteger n) {
        Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        BigInteger bigInteger = $this$decrypt.modPow(d, n);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modPow(d, n)");
        return BigIntegerKt.n2s(bigInteger);
    }

    @NotNull
    public static final String n2s(@NotNull BigInteger $this$n2s) {
        Intrinsics.checkNotNullParameter((Object)$this$n2s, (String)"<this>");
        byte[] byArray = $this$n2s.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray()");
        return StringsKt.decodeToString((byte[])byArray);
    }

    @NotNull
    public static final BigInteger s2n(@NotNull String $this$s2n) {
        Intrinsics.checkNotNullParameter((Object)$this$s2n, (String)"<this>");
        String string = $this$s2n;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new BigInteger(byArray);
    }

    @NotNull
    public static final BigInteger toBigInteger(@NotNull byte[] $this$toBigInteger) {
        Intrinsics.checkNotNullParameter((Object)$this$toBigInteger, (String)"<this>");
        return new BigInteger($this$toBigInteger);
    }

    @NotNull
    public static final String decrypt(@NotNull BigInteger $this$decrypt, @NotNull String d, @NotNull String n) {
        Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return BigIntegerKt.decrypt($this$decrypt, new BigInteger(d), new BigInteger(n));
    }

    @NotNull
    public static final List<BigInteger> factorDb(@NotNull BigInteger $this$factorDb) {
        Intrinsics.checkNotNullParameter((Object)$this$factorDb, (String)"<this>");
        return BigIntegerKt.getPrimeFromFactorDb($this$factorDb);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger phi(@NotNull List<? extends BigInteger> $this$phi) {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$phi, (String)"<this>");
        Iterable $this$filter$iv = $this$phi;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BigInteger it = (BigInteger)element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo(BigInteger.ZERO) > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        BigInteger initial$iv = BigInteger.ONE;
        boolean $i$f$fold = false;
        BigInteger accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void intVal;
            Object element$iv$iv;
            element$iv$iv = (BigInteger)element$iv;
            BigInteger acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc, (String)"acc");
            BigInteger bigInteger = acc;
            BigInteger bigInteger2 = intVal;
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.subtract(other)");
            bigInteger2 = bigInteger4;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger.multiply(bigInteger2), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"filter { it > BigInteger\u2026t - BigInteger.ONE)\n    }");
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger product(@NotNull List<? extends BigInteger> $this$product) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$product, (String)"<this>");
        Iterable iterable = $this$product;
        BigInteger initial$iv = BigInteger.ONE;
        boolean $i$f$fold = false;
        BigInteger accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void intVal;
            BigInteger bigInteger = (BigInteger)element$iv;
            BigInteger acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc, (String)"acc");
            Intrinsics.checkNotNullExpressionValue((Object)acc.multiply((BigInteger)intVal), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"fold(BigInteger.ONE) { acc, int -> acc * int }");
        return bigInteger;
    }

    public static final boolean isMutualPrime(@NotNull BigInteger $this$isMutualPrime, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$isMutualPrime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$isMutualPrime.gcd(other), (Object)BigInteger.ONE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger propN(@NotNull List<? extends BigInteger> $this$propN, @NotNull BigInteger n) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$propN, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Iterable $this$filter$iv = $this$propN;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BigInteger it = (BigInteger)element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo(BigInteger.ZERO) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$fold$iv = (List)destination$iv$iv;
        boolean $i$f$fold = false;
        BigInteger accumulator$iv = n;
        for (Object element$iv : $this$fold$iv) {
            void bigInteger;
            BigInteger bigInteger2 = (BigInteger)element$iv;
            BigInteger acc = accumulator$iv;
            boolean bl = false;
            BigInteger bigInteger3 = acc;
            BigInteger bigInteger4 = bigInteger.abs();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"bigInteger.abs()");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3.divide(bigInteger4), (String)"this.divide(other)");
        }
        return accumulator$iv;
    }

    @NotNull
    public static final BigInteger eulerPhi(@NotNull BigInteger $this$eulerPhi, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$eulerPhi, (String)"<this>");
        BigInteger bigInteger = $this$eulerPhi;
        BigInteger bigInteger2 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.subtract(other)");
        bigInteger = bigInteger3;
        BigInteger bigInteger4 = $this$eulerPhi.pow(n - 1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"pow(n - 1)");
        BigInteger bigInteger5 = bigInteger.multiply(bigInteger4);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.multiply(other)");
        return bigInteger5;
    }

    @NotNull
    public static final List<BigInteger> getPrimeFromFactorDb(@NotNull BigInteger digit) {
        Intrinsics.checkNotNullParameter((Object)digit, (String)"digit");
        String string = digit.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"digit.toString()");
        return BigIntegerKt.getPrimeFromFactorDb(string);
    }

    @NotNull
    public static final List<BigInteger> getPrimeFromFactorDb(@NotNull String digit) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)digit, (String)"digit");
        try {
            boolean bl = false;
            object2 = Result.constructor-impl(GsonUtilKt.fromJson(NetKt.readFromNet$default("http://factordb.com/api?query=" + digit, null, 3000, 1, null), FactorDbResponse.class).getFactorList());
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            Object[] objectArray = new BigInteger[]{new BigInteger(digit).negate()};
            object = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        return (List)object;
    }

    @NotNull
    public static final BigInteger[] root(@NotNull BigInteger $this$root, int n) {
        BigInteger it;
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$root, (String)"<this>");
        if ($this$root.signum() < 0 && n % 2 == 0) {
            throw new IllegalStateException("n must be even".toString());
        }
        int sig = $this$root.signum();
        BigInteger v = $this$root.abs();
        BigInteger high = BigInteger.ONE;
        while (high.pow(n).compareTo(v) <= 0) {
            high = high.shiftLeft(1);
        }
        BigInteger low = high.shiftRight(1);
        BigInteger mid = BigInteger.ONE;
        int midCount = 0;
        while (low.compareTo(high) < 0) {
            Intrinsics.checkNotNullExpressionValue((Object)low, (String)"low");
            BigInteger bigInteger2 = high;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"high");
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.add(other)");
            mid = bigInteger3.shiftRight(1);
            if (low.compareTo(mid) < 0 && mid.pow(n).compareTo(v) <= 0) {
                low = mid;
            } else if (high.compareTo(mid) > 0 && mid.pow(n).compareTo(v) >= 0) {
                high = mid;
            } else {
                it = bigInteger = mid;
                boolean bl = false;
                ++midCount;
            }
            if (midCount <= true) continue;
        }
        BigInteger bigInteger4 = mid;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"mid");
        bigInteger = bigInteger4;
        BigInteger bigInteger5 = BigInteger.valueOf(sig);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(this.toLong())");
        it = bigInteger5;
        BigInteger bigInteger6 = bigInteger.multiply(it);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.multiply(other)");
        BigInteger $this$root_u24lambda_u2d8 = bigInteger6;
        boolean bl = false;
        BigInteger[] bigIntegerArray = new BigInteger[2];
        bigIntegerArray[0] = $this$root_u24lambda_u2d8;
        BigInteger bigInteger7 = $this$root;
        BigInteger bigInteger8 = $this$root_u24lambda_u2d8.pow(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"this.pow(n)");
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7.subtract(bigInteger8), (String)"this.subtract(other)");
        return bigIntegerArray;
    }

    public static /* synthetic */ BigInteger[] root$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return BigIntegerKt.root(bigInteger, n);
    }

    @NotNull
    public static final BigInteger[] wiener(@NotNull BigInteger $this$wiener, @NotNull BigInteger n) {
        block4: {
            BigInteger pPlusQDiv2;
            BigInteger bigInteger;
            Object[] root2;
            BigInteger q0;
            Intrinsics.checkNotNullParameter((Object)$this$wiener, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            if ($this$wiener.compareTo(n.pow(2).multiply((BigInteger)ArraysKt.first((Object[])BigIntegerKt.root$default(n, 0, 1, null)))) > 0) {
                System.out.println((Object)"e > n^(1.5) -> this is not guaranteed to work");
            }
            BigInteger x = $this$wiener;
            BigInteger y = n;
            BigInteger guessK = null;
            BigInteger guessDg = null;
            BigInteger guessD = null;
            BigInteger pMinusQDiv2 = null;
            BigInteger bigInteger2 = x.divide(y);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.divide(other)");
            BigInteger n0 = q0 = bigInteger2;
            BigInteger d0 = BigInteger.ONE;
            BigInteger temp = x;
            x = y;
            BigInteger bigInteger3 = temp.add(y.multiply(q0).negate());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"temp.add(y.multiply(q0).negate())");
            y = bigInteger3;
            BigInteger bigInteger4 = x.divide(y);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.divide(other)");
            BigInteger qI = bigInteger4;
            BigInteger bigInteger5 = q0.multiply(qI);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.multiply(other)");
            BigInteger bigInteger6 = bigInteger5;
            BigInteger bigInteger7 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"ONE");
            BigInteger bigInteger8 = bigInteger6.add(bigInteger7);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"this.add(other)");
            BigInteger n1 = bigInteger8;
            BigInteger d1 = qI;
            BigInteger dI2 = d0;
            BigInteger dI1 = d1;
            BigInteger dI = null;
            BigInteger nI2 = n0;
            BigInteger nI1 = n1;
            BigInteger nI = null;
            int i = 1;
            do {
                BigInteger phiN;
                BigInteger bigInteger9;
                BigInteger bigInteger10 = y.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.negate()");
                BigInteger bigInteger11 = bigInteger10.multiply(qI);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"this.multiply(other)");
                if (x.add(bigInteger11).signum() == 0) break block4;
                ++i;
                temp = x;
                x = y;
                BigInteger bigInteger12 = y.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"this.negate()");
                BigInteger bigInteger13 = bigInteger12.multiply(qI);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger13, (String)"this.multiply(other)");
                Intrinsics.checkNotNullExpressionValue((Object)temp.add(bigInteger13), (String)"temp.add(-y * qI)");
                Intrinsics.checkNotNullExpressionValue((Object)x.divide(y), (String)"this.divide(other)");
                Intrinsics.checkNotNullExpressionValue((Object)qI.multiply(dI1), (String)"this.multiply(other)");
                BigInteger bigInteger14 = dI2;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger14, (String)"dI2");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger9.add(bigInteger14), (String)"this.add(other)");
                BigInteger bigInteger15 = qI.multiply(nI1);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger15, (String)"this.multiply(other)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger15.add(nI2), (String)"this.add(other)");
                dI2 = dI1;
                dI1 = dI;
                nI2 = nI1;
                nI1 = nI;
                if (i % 2 == 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)nI1.add(nI2), (String)"this.add(other)");
                    bigInteger9 = dI1;
                    BigInteger bigInteger16 = dI2;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger16, (String)"dI2");
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger9.add(bigInteger16), (String)"this.add(other)");
                } else {
                    guessK = nI1;
                    guessDg = dI1;
                }
                BigInteger bigInteger17 = $this$wiener.multiply(guessDg);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger17, (String)"this.multiply(other)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger17.divide(guessK), (String)"this.divide(other)");
                BigInteger bigInteger18 = n.subtract(phiN);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger18, (String)"this.subtract(other)");
                BigInteger bigInteger19 = bigInteger18;
                BigInteger bigInteger20 = BigInteger.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger20, (String)"ONE");
                BigInteger bigInteger21 = bigInteger19.add(bigInteger20);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger21, (String)"this.add(other)");
                bigInteger19 = bigInteger21;
                BigInteger bigInteger22 = BigInteger.TWO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger22, (String)"TWO");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger19.divide(bigInteger22), (String)"this.divide(other)");
                bigInteger = pPlusQDiv2.pow(2).subtract(n);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pPlusQDiv2.pow(2).subtract(n)");
            } while (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])(root2 = BigIntegerKt.root$default(bigInteger, 0, 1, null))), (Object)BigInteger.ZERO));
            pMinusQDiv2 = (BigInteger)ArraysKt.first((Object[])root2);
            BigInteger bigInteger23 = $this$wiener.multiply(guessDg);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger23, (String)"this.multiply(other)");
            BigInteger bigInteger24 = bigInteger23.remainder(guessK);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger24, (String)"this.remainder(other)");
            BigInteger bigInteger25 = guessDg.divide(bigInteger24);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger25, (String)"this.divide(other)");
            guessD = bigInteger25;
            BigInteger bigInteger26 = pPlusQDiv2.add(pMinusQDiv2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger26, (String)"this.add(other)");
            BigInteger guessP = bigInteger26;
            BigInteger bigInteger27 = pPlusQDiv2.subtract(pMinusQDiv2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger27, (String)"this.subtract(other)");
            BigInteger guessQ = bigInteger27;
            System.out.println((Object)"Success");
            BigInteger[] bigIntegerArray = new BigInteger[]{guessD, guessP, guessQ};
            return bigIntegerArray;
        }
        return new BigInteger[0];
    }
}

