/*
 * Decompiled with CFR 0.152.
 */
package me.leon.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.leon.ConfigKt;
import me.leon.DigestsKt;
import me.leon.controller.DigestController;
import me.leon.ext.ByteArrayKt;
import me.leon.ext.ConcurrencyKt;
import me.leon.ext.ExceptionKt;
import me.leon.ext.FileKt;
import me.leon.ext.StringKt;
import me.leon.ext.crypto.CrcKt;
import me.leon.ext.crypto.PasswordHashingType;
import me.leon.ext.crypto.TypesKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.Controller;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J \u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J*\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lme/leon/controller/DigestController;", "Ltornadofx/Controller;", "()V", "dicts", "", "", "getDicts", "()Ljava/util/List;", "crack", "kotlin.jvm.PlatformType", "method", "data", "digest", "inputEncode", "isSingleLine", "", "digestFile", "path", "passwordHashingCrack", "hashed", "app"})
public final class DigestController
extends Controller {
    /*
     * WARNING - void declaration
     */
    private final List<String> getDicts() {
        Object object;
        block4: {
            block3: {
                void $this$flatMapTo$iv$iv;
                object = FileKt.toFile(ConfigKt.getDICT_DIR()).listFiles();
                if (object == null) break block3;
                File[] $this$flatMap$iv = object;
                boolean $i$f$flatMap = false;
                File[] fileArray = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                int n = ((void)$this$flatMapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Iterable list$iv$iv = FilesKt.readLines$default((File)it, null, (int)1, null);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                if (object != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final String digest(@NotNull String method, @NotNull String data, @NotNull String inputEncode, boolean isSingleLine) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)inputEncode, (String)"inputEncode");
        return (String)ExceptionKt.catch(digest.1.INSTANCE, (Function0)new Function0<String>(isSingleLine, data, this, method, inputEncode){
            final /* synthetic */ boolean $isSingleLine;
            final /* synthetic */ String $data;
            final /* synthetic */ DigestController this$0;
            final /* synthetic */ String $method;
            final /* synthetic */ String $inputEncode;
            {
                this.$isSingleLine = $isSingleLine;
                this.$data = $data;
                this.this$0 = $receiver;
                this.$method = $method;
                this.$inputEncode = $inputEncode;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$isSingleLine ? StringKt.lineAction2String(this.$data, (Function1<? super String, String>)((Function1)new Function1<String, String>(this.this$0, this.$method, this.$inputEncode){
                    final /* synthetic */ DigestController this$0;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $inputEncode;
                    {
                        this.this$0 = $receiver;
                        this.$method = $method;
                        this.$inputEncode = $inputEncode;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return DigestController.access$digest(this.this$0, this.$method, it, this.$inputEncode);
                    }
                })) : DigestController.access$digest(this.this$0, this.$method, this.$data, this.$inputEncode);
            }
        });
    }

    public static /* synthetic */ String digest$default(DigestController digestController, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "raw";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return digestController.digest(string, string2, string3, bl);
    }

    private final String digest(String method, String data, String inputEncode) {
        String string;
        if (StringsKt.startsWith$default((String)method, (String)"CRC", (boolean)false, (int)2, null)) {
            string = StringsKt.contains$default((CharSequence)method, (CharSequence)"32", (boolean)false, (int)2, null) ? CrcKt.crc32(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null)) : CrcKt.crc64(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (Intrinsics.areEqual((Object)method, (Object)"Adler32")) {
            string = CrcKt.adler32(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (TypesKt.passwordHashingType(method) != null) {
            PasswordHashingType passwordHashingType = TypesKt.passwordHashingType(method);
            Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
            string = passwordHashingType.hash(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else {
            string = DigestsKt.hash2String(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), method);
        }
        return string;
    }

    @NotNull
    public final String passwordHashingCrack(@NotNull String method, @NotNull String hashed) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
        return (String)ExceptionKt.catch(passwordHashingCrack.1.INSTANCE, (Function0)new Function0<String>(this, method, hashed){
            final /* synthetic */ DigestController this$0;
            final /* synthetic */ String $method;
            final /* synthetic */ String $hashed;
            {
                this.this$0 = $receiver;
                this.$method = $method;
                this.$hashed = $hashed;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                Object v1;
                block2: {
                    Iterable iterable = DigestController.access$getDicts(this.this$0);
                    String string2 = this.$method;
                    String string3 = this.$hashed;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        String pw = (String)t;
                        boolean bl = false;
                        PasswordHashingType passwordHashingType = TypesKt.passwordHashingType(string2);
                        Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
                        if (!passwordHashingType.check(pw, string3)) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                if ((string = (String)v1) == null) {
                    string = "";
                }
                return string;
            }
        });
    }

    @NotNull
    public final String digestFile(@NotNull String method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (String)ExceptionKt.catch(digestFile.1.INSTANCE, (Function0)new Function0<String>(path, method){
            final /* synthetic */ String $path;
            final /* synthetic */ String $method;
            {
                this.$path = $path;
                this.$method = $method;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                if (((CharSequence)this.$path).length() == 0) {
                    string = "";
                } else if (StringsKt.startsWith$default((String)this.$method, (String)"CRC", (boolean)false, (int)2, null)) {
                    string = StringsKt.contains$default((CharSequence)this.$method, (CharSequence)"32", (boolean)false, (int)2, null) ? CrcKt.crc32File(this.$path) : CrcKt.crc64File(this.$path);
                } else if (Intrinsics.areEqual((Object)this.$method, (Object)"Adler32")) {
                    string = CrcKt.adler32File(this.$path);
                } else {
                    if (TypesKt.passwordHashingType(this.$method) != null) {
                        throw new IllegalStateException("not support".toString());
                    }
                    string = DigestsKt.fileHash(this.$path, this.$method);
                }
                return string;
            }
        });
    }

    public final String crack(@NotNull String method, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (String)ExceptionKt.catch(crack.1.INSTANCE, (Function0)new Function0<String>(this, method, data){
            final /* synthetic */ DigestController this$0;
            final /* synthetic */ String $method;
            final /* synthetic */ String $data;
            {
                this.this$0 = $receiver;
                this.$method = $method;
                this.$data = $data;
                super(0);
            }

            public final String invoke() {
                if (DigestController.access$digest(this.this$0, this.$method, this.$data, "raw").length() != this.$data.length()) {
                    throw new IllegalStateException("Wrong Method!!!".toString());
                }
                return ConcurrencyKt.findParallel(DigestController.access$getDicts(this.this$0), "", (Function1)new Function1<String, Boolean>(this.this$0, this.$method, this.$data){
                    final /* synthetic */ DigestController this$0;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $data;
                    {
                        this.this$0 = $receiver;
                        this.$method = $method;
                        this.$data = $data;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)DigestController.access$digest(this.this$0, this.$method, it, "raw"), (Object)this.$data);
                    }
                });
            }
        });
    }

    public static final /* synthetic */ String access$digest(DigestController $this, String method, String data, String inputEncode) {
        return $this.digest(method, data, inputEncode);
    }

    public static final /* synthetic */ List access$getDicts(DigestController $this) {
        return $this.getDicts();
    }
}

