/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u0012\u0010\t\u001a\u00020\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/leon/ctf/BrainfuckEngine;", "", "cells", "", "out", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "(ILjava/io/OutputStream;Ljava/io/InputStream;)V", "charPointer", "columnCount", "consoleReader", "Ljava/io/InputStreamReader;", "data", "", "dataPointer", "lineCount", "outWriter", "initiate", "", "interpret", "c", "", "chars", "", "", "str", "Token", "app"})
public class BrainfuckEngine {
    @JvmField
    @Nullable
    protected byte[] data;
    @JvmField
    protected int dataPointer;
    @JvmField
    protected int charPointer;
    @JvmField
    @NotNull
    protected InputStreamReader consoleReader;
    @JvmField
    @NotNull
    protected OutputStream outWriter;
    private int lineCount;
    private int columnCount;

    @JvmOverloads
    public BrainfuckEngine(int cells, @NotNull OutputStream out, @Nullable InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.initiate(cells);
        this.outWriter = out;
        this.consoleReader = new InputStreamReader(inputStream);
    }

    public /* synthetic */ BrainfuckEngine(int n, OutputStream outputStream, InputStream inputStream, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            outputStream = new ByteArrayOutputStream();
        }
        if ((n2 & 4) != 0) {
            inputStream = System.in;
        }
        this(n, outputStream, inputStream);
    }

    protected final void initiate(int cells) {
        this.data = new byte[cells];
        this.dataPointer = 0;
        this.charPointer = 0;
    }

    @NotNull
    public String interpret(@NotNull String str) throws Exception {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        OutputStream outputStream = this.outWriter;
        Intrinsics.checkNotNull((Object)outputStream, (String)"null cannot be cast to non-null type java.io.ByteArrayOutputStream");
        ((ByteArrayOutputStream)outputStream).reset();
        while (this.charPointer < str.length()) {
            char c = str.charAt(this.charPointer);
            char[] cArray = str.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            this.interpret(c, cArray);
            int n = this.charPointer;
            this.charPointer = n + 1;
        }
        Intrinsics.checkNotNull((Object)this.data);
        this.initiate(this.data.length);
        return this.outWriter.toString();
    }

    protected final void interpret(char c, @NotNull char[] chars) throws IndexOutOfBoundsException {
        block22: {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            if (this.data == null) break block22;
            byte[] it = this.data;
            boolean bl = false;
            int n = c;
            if (n == 62) {
                if (this.dataPointer + 1 > it.length) {
                    throw new IndexOutOfBoundsException("Error on line " + this.lineCount + ", column " + this.columnCount + ":data pointer (" + this.dataPointer + " ) on position " + this.charPointer + "  out of range.");
                }
                int n2 = this.dataPointer;
                this.dataPointer = n2 + 1;
            } else if (n == 60) {
                if (this.dataPointer - 1 < 0) {
                    throw new IndexOutOfBoundsException("Error on line " + this.lineCount + ", column " + this.columnCount + " :data pointer (" + this.dataPointer + " ) on position " + this.charPointer + "   negative.");
                }
                int n3 = this.dataPointer;
                this.dataPointer = n3 + -1;
            } else if (n == 43) {
                int n4 = this.dataPointer;
                byte by = it[n4];
                it[n4] = (byte)(by + 1);
            } else if (n == 45) {
                int n5 = this.dataPointer;
                byte by = it[n5];
                it[n5] = (byte)(by + -1);
            } else if (n == 46) {
                this.outWriter.write(it[this.dataPointer]);
            } else if (n == 44) {
                it[this.dataPointer] = (byte)this.consoleReader.read();
            } else if (n == 91) {
                if (it[this.dataPointer] == 0) {
                    int i = 1;
                    while (i > 0) {
                        ++this.charPointer;
                        char c2 = chars[this.charPointer];
                        if (c2 == '[') {
                            ++i;
                            continue;
                        }
                        if (c2 != ']') continue;
                        --i;
                    }
                }
            } else if (n == 93) {
                int i = 1;
                while (i > 0) {
                    this.charPointer += -1;
                    char c2 = chars[this.charPointer];
                    if (c2 == '[') {
                        --i;
                        continue;
                    }
                    if (c2 != ']') continue;
                    ++i;
                }
                int n6 = this.charPointer;
                this.charPointer = n6 + -1;
            }
            n = this.columnCount;
            this.columnCount = n + 1;
        }
    }

    @JvmOverloads
    public BrainfuckEngine(int cells, @NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(cells, out, null, 4, null);
    }

    @JvmOverloads
    public BrainfuckEngine(int cells) {
        this(cells, null, null, 6, null);
    }

    @JvmOverloads
    public BrainfuckEngine() {
        this(0, null, null, 7, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/leon/ctf/BrainfuckEngine$Token;", "", "()V", "BRACKET_LEFT", "", "BRACKET_RIGHT", "INPUT", "MINUS", "NEXT", "OUTPUT", "PLUS", "PREVIOUS", "app"})
    protected static final class Token {
        @NotNull
        public static final Token INSTANCE = new Token();
        public static final char NEXT = '>';
        public static final char PREVIOUS = '<';
        public static final char PLUS = '+';
        public static final char MINUS = '-';
        public static final char OUTPUT = '.';
        public static final char INPUT = ',';
        public static final char BRACKET_LEFT = '[';
        public static final char BRACKET_RIGHT = ']';

        private Token() {
        }
    }
}

