/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.leon.ctf.BrainfuckEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B)\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lme/leon/ctf/TrollScriptEngine;", "Lme/leon/ctf/BrainfuckEngine;", "cells", "", "out", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "(ILjava/io/OutputStream;Ljava/io/InputStream;)V", "defaultTokenLength", "getDefaultTokenLength", "()I", "setDefaultTokenLength", "(I)V", "interpret", "", "str", "isValidToken", "", "token", "parseTokens", "", "tokens", "", "Token", "app"})
public class TrollScriptEngine
extends BrainfuckEngine {
    private int defaultTokenLength;

    @JvmOverloads
    public TrollScriptEngine(int cells, @Nullable OutputStream out, @Nullable InputStream inputStream) {
        OutputStream outputStream = out;
        Intrinsics.checkNotNull((Object)outputStream);
        super(cells, outputStream, inputStream);
        this.defaultTokenLength = 3;
    }

    public /* synthetic */ TrollScriptEngine(int n, OutputStream outputStream, InputStream inputStream, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            outputStream = new ByteArrayOutputStream();
        }
        if ((n2 & 4) != 0) {
            inputStream = System.in;
        }
        this(n, outputStream, inputStream);
    }

    public int getDefaultTokenLength() {
        return this.defaultTokenLength;
    }

    public void setDefaultTokenLength(int n) {
        this.defaultTokenLength = n;
    }

    @Override
    @NotNull
    public String interpret(@NotNull String str) throws Exception {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        OutputStream outputStream = this.outWriter;
        Intrinsics.checkNotNull((Object)outputStream, (String)"null cannot be cast to non-null type java.io.ByteArrayOutputStream");
        ((ByteArrayOutputStream)outputStream).reset();
        boolean started = false;
        List tokens = new ArrayList();
        while (this.charPointer < str.length()) {
            String string;
            if (this.charPointer + this.getDefaultTokenLength() <= str.length()) {
                String string2 = str.substring(this.charPointer, this.charPointer + this.getDefaultTokenLength());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                String string3 = str.substring(this.charPointer, this.charPointer + (str.length() - this.charPointer));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String token = string;
            if (this.isValidToken(token)) {
                if (StringsKt.equals((String)token, (String)"tro", (boolean)true)) {
                    started = true;
                } else {
                    if (StringsKt.equals((String)token, (String)"ll.", (boolean)true)) break;
                    if (started) {
                        tokens.add(token);
                    }
                }
                this.charPointer += this.getDefaultTokenLength();
                continue;
            }
            if (this.charPointer + this.getDefaultTokenLength() > str.length()) {
                this.charPointer += str.length() - this.charPointer;
                continue;
            }
            int n = this.charPointer;
            this.charPointer = n + 1;
        }
        this.parseTokens(tokens);
        Intrinsics.checkNotNull((Object)this.data);
        this.initiate(this.data.length);
        return this.outWriter.toString();
    }

    private final void parseTokens(List<String> tokens) {
        block20: for (int tokenPointer = 0; tokenPointer < tokens.size(); ++tokenPointer) {
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)tokens.get(tokenPointer).toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            int n = -1;
            switch (string.hashCode()) {
                case 110130: {
                    if (string.equals("olo")) {
                        n = 1;
                    }
                    break;
                }
                case 107337: {
                    if (string.equals("lol")) {
                        n = 2;
                    }
                    break;
                }
                case 110220: {
                    if (string.equals("ool")) {
                        n = 3;
                    }
                    break;
                }
                case 107340: {
                    if (string.equals("loo")) {
                        n = 4;
                    }
                    break;
                }
                case 107244: {
                    if (string.equals("lll")) {
                        n = 5;
                    }
                    break;
                }
                case 110223: {
                    if (string.equals("ooo")) {
                        n = 6;
                    }
                    break;
                }
                case 110127: {
                    if (string.equals("oll")) {
                        n = 7;
                    }
                    break;
                }
                case 107247: {
                    if (string.equals("llo")) {
                        n = 8;
                    }
                    break;
                }
            }
            switch (n) {
                case 6: {
                    Intrinsics.checkNotNull((Object)this.data);
                    this.dataPointer = this.dataPointer == this.data.length - 1 ? 0 : this.dataPointer + 1;
                    continue block20;
                }
                case 3: {
                    int n2;
                    if (this.dataPointer == 0) {
                        Intrinsics.checkNotNull((Object)this.data);
                        n2 = this.data.length - 1;
                    } else {
                        n2 = this.dataPointer - 1;
                    }
                    this.dataPointer = n2;
                    continue block20;
                }
                case 1: {
                    Intrinsics.checkNotNull((Object)this.data);
                    byte[] byArray = this.data;
                    int n3 = this.dataPointer;
                    byte by = byArray[n3];
                    byArray[n3] = (byte)(by + 1);
                    continue block20;
                }
                case 7: {
                    Intrinsics.checkNotNull((Object)this.data);
                    byte[] byArray = this.data;
                    int n3 = this.dataPointer;
                    byte by = byArray[n3];
                    byArray[n3] = (byte)(by + -1);
                    continue block20;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)this.data);
                    this.outWriter.write(this.data[this.dataPointer]);
                    continue block20;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)this.data);
                    this.data[this.dataPointer] = (byte)this.consoleReader.read();
                    continue block20;
                }
                case 8: {
                    Intrinsics.checkNotNull((Object)this.data);
                    if (this.data[this.dataPointer] != 0) continue block20;
                    int level = 1;
                    while (level > 0) {
                        if (StringsKt.equals((String)tokens.get(++tokenPointer), (String)"llo", (boolean)true)) {
                            ++level;
                            continue;
                        }
                        if (!StringsKt.equals((String)tokens.get(tokenPointer), (String)"lll", (boolean)true)) continue;
                        --level;
                    }
                    continue block20;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)this.data);
                    if (this.data[this.dataPointer] == 0) continue block20;
                    int level = 1;
                    while (level > 0) {
                        if (StringsKt.equals((String)tokens.get(--tokenPointer), (String)"llo", (boolean)true)) {
                            --level;
                            continue;
                        }
                        if (!StringsKt.equals((String)tokens.get(tokenPointer), (String)"lll", (boolean)true)) continue;
                        ++level;
                    }
                    continue block20;
                }
            }
        }
    }

    private final boolean isValidToken(String token) {
        return StringsKt.equals((String)token, (String)"tro", (boolean)true) || StringsKt.equals((String)token, (String)"ooo", (boolean)true) || StringsKt.equals((String)token, (String)"ool", (boolean)true) || StringsKt.equals((String)token, (String)"olo", (boolean)true) || StringsKt.equals((String)token, (String)"oll", (boolean)true) || StringsKt.equals((String)token, (String)"loo", (boolean)true) || StringsKt.equals((String)token, (String)"lol", (boolean)true) || StringsKt.equals((String)token, (String)"llo", (boolean)true) || StringsKt.equals((String)token, (String)"lll", (boolean)true) || StringsKt.equals((String)token, (String)"ll.", (boolean)true);
    }

    @JvmOverloads
    public TrollScriptEngine(int cells, @Nullable OutputStream out) {
        this(cells, out, null, 4, null);
    }

    @JvmOverloads
    public TrollScriptEngine(int cells) {
        this(cells, null, null, 6, null);
    }

    @JvmOverloads
    public TrollScriptEngine() {
        this(0, null, null, 7, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/leon/ctf/TrollScriptEngine$Token;", "", "()V", "BRACKET_LEFT", "", "BRACKET_RIGHT", "END", "INPUT", "MINUS", "NEXT", "OUTPUT", "PLUS", "PREVIOUS", "START", "app"})
    protected static final class Token {
        @NotNull
        public static final Token INSTANCE = new Token();
        @NotNull
        public static final String START = "tro";
        @NotNull
        public static final String NEXT = "ooo";
        @NotNull
        public static final String PREVIOUS = "ool";
        @NotNull
        public static final String PLUS = "olo";
        @NotNull
        public static final String MINUS = "oll";
        @NotNull
        public static final String OUTPUT = "loo";
        @NotNull
        public static final String INPUT = "lol";
        @NotNull
        public static final String BRACKET_LEFT = "llo";
        @NotNull
        public static final String BRACKET_RIGHT = "lll";
        @NotNull
        public static final String END = "ll.";

        private Token() {
        }
    }
}

