/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf.rsa;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.leon.ctf.rsa.FactorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u0001\u001aE\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u000121\u0010\u000b\u001a-\u0012)\u0012'\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\rj\u0002`\u00110\fH\u0002\u001a\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0005\u001a\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u001a\u001e\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0005\u001a$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0001\u001a\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00012\b\b\u0002\u0010\u001b\u001a\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0003*L\u0010\u001c\"#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\r2#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\r\u00a8\u0006\u001d"}, d2={"MAX_DIVIDER", "Ljava/math/BigInteger;", "getMAX_DIVIDER", "()Ljava/math/BigInteger;", "MAX_FERMAT_ITERATION", "", "MAX_POLLARD_ITERATION", "THREE", "getTHREE", "factor", "", "funList", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "integer", "Lme/leon/ctf/rsa/FactorFun;", "fermat", "iteration", "pMinus1", "maxIteration", "pollardsPM1Factors", "pollardsRho", "funBias", "pollardsRhoFactors", "trialDivide", "maxDivider", "FactorFun", "app"})
public final class FactorsKt {
    @NotNull
    private static final BigInteger THREE;
    @NotNull
    private static final BigInteger MAX_DIVIDER;
    public static final int MAX_FERMAT_ITERATION = 1000000;
    public static final int MAX_POLLARD_ITERATION = 1000;

    @NotNull
    public static final BigInteger getTHREE() {
        return THREE;
    }

    @NotNull
    public static final BigInteger getMAX_DIVIDER() {
        return MAX_DIVIDER;
    }

    @NotNull
    public static final List<BigInteger> trialDivide(@NotNull BigInteger $this$trialDivide, @NotNull BigInteger maxDivider) {
        Intrinsics.checkNotNullParameter((Object)$this$trialDivide, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)maxDivider, (String)"maxDivider");
        List factors = new ArrayList();
        if ($this$trialDivide.isProbablePrime(100)) {
            List list;
            List $this$trialDivide_u24lambda_u2d0 = list = factors;
            boolean bl = false;
            $this$trialDivide_u24lambda_u2d0.add($this$trialDivide);
            return list;
        }
        System.out.println((Object)"div: start divide");
        if ($this$trialDivide.bitLength() > 100) {
            List list;
            List $this$trialDivide_u24lambda_u2d1 = list = factors;
            boolean bl = false;
            BigInteger bigInteger = $this$trialDivide.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this@trialDivide.negate()");
            $this$trialDivide_u24lambda_u2d1.add(bigInteger);
            return list;
        }
        BigInteger n = $this$trialDivide;
        while (true) {
            BigInteger $this$trialDivide_u24lambda_u2d1 = n;
            BigInteger bigInteger = BigInteger.TWO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"TWO");
            BigInteger bigInteger2 = $this$trialDivide_u24lambda_u2d1.remainder(bigInteger);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.remainder(other)");
            if (!Intrinsics.areEqual((Object)bigInteger2, (Object)BigInteger.ZERO)) break;
            BigInteger bigInteger3 = BigInteger.TWO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"TWO");
            factors.add(bigInteger3);
            $this$trialDivide_u24lambda_u2d1 = n;
            BigInteger bigInteger4 = BigInteger.TWO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"TWO");
            Intrinsics.checkNotNullExpressionValue((Object)$this$trialDivide_u24lambda_u2d1.divide(bigInteger4), (String)"this.divide(other)");
        }
        BigInteger f2 = THREE;
        while (f2.pow(2).compareTo(n) <= 0 && !n.isProbablePrime(100)) {
            BigInteger bigInteger = n.remainder(f2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.remainder(other)");
            if (Intrinsics.areEqual((Object)bigInteger, (Object)BigInteger.ZERO)) {
                factors.add(f2);
                Intrinsics.checkNotNullExpressionValue((Object)n.divide(f2), (String)"this.divide(other)");
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)f2.nextProbablePrime(), (String)"f.nextProbablePrime()");
            }
            if (f2.compareTo(maxDivider) <= 0) continue;
        }
        if (!Intrinsics.areEqual((Object)n, (Object)BigInteger.ONE)) {
            BigInteger bigInteger = n.isProbablePrime(100) ? n : n.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"if (n.isProbablePrime(100)) n else n.negate()");
            factors.add(bigInteger);
        }
        System.out.println((Object)("div: end divide. found " + factors.size() + " factors"));
        return factors;
    }

    public static /* synthetic */ List trialDivide$default(BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger2 = MAX_DIVIDER;
        }
        return FactorsKt.trialDivide(bigInteger, bigInteger2);
    }

    @NotNull
    public static final List<BigInteger> fermat(@NotNull BigInteger $this$fermat, int iteration) {
        Intrinsics.checkNotNullParameter((Object)$this$fermat, (String)"<this>");
        Object[] $this$fermat_u24lambda_u2d2 = $this$fermat.sqrtAndRemainder();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$fermat_u24lambda_u2d2, (String)"this");
        if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])$this$fermat_u24lambda_u2d2), (Object)BigInteger.ZERO)) {
            Object object = ArraysKt.first((Object[])$this$fermat_u24lambda_u2d2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first()");
            BigInteger bigInteger = (BigInteger)object;
            BigInteger bigInteger2 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.add(other)");
            BigInteger a = bigInteger3;
            BigInteger b = null;
            for (int count = 0; count < iteration; ++count) {
                BigInteger b1;
                BigInteger bigInteger4 = a.pow(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"a.pow(2)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4.subtract($this$fermat), (String)"this.subtract(other)");
                Intrinsics.checkNotNullExpressionValue((Object)b1.sqrt(), (String)"b1.sqrt()");
                BigInteger bigInteger5 = b.multiply(b);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.multiply(other)");
                if (Intrinsics.areEqual((Object)bigInteger5, (Object)b1)) {
                    StringBuilder stringBuilder = new StringBuilder().append("solved iteration ").append(count).append(" \n\tp = ");
                    BigInteger bigInteger6 = a.add(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.add(other)");
                    StringBuilder stringBuilder2 = stringBuilder.append(bigInteger6).append(" \n\tq= ");
                    BigInteger bigInteger7 = a.subtract(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.subtract(other)");
                    System.out.println((Object)stringBuilder2.append(bigInteger7).append('\n').toString());
                    Object[] objectArray = new BigInteger[2];
                    Intrinsics.checkNotNullExpressionValue((Object)a.add(b), (String)"this.add(other)");
                    Intrinsics.checkNotNullExpressionValue((Object)a.subtract(b), (String)"this.subtract(other)");
                    return CollectionsKt.mutableListOf((Object[])objectArray);
                }
                Intrinsics.checkNotNullExpressionValue((Object)a.add(BigInteger.ONE), (String)"this.add(BigInteger.ONE)");
            }
        }
        System.out.println((Object)"no fermat solution");
        Object[] objectArray = new BigInteger[1];
        Intrinsics.checkNotNullExpressionValue((Object)$this$fermat.negate(), (String)"this.negate()");
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public static /* synthetic */ List fermat$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10000;
        }
        return FactorsKt.fermat(bigInteger, n);
    }

    @NotNull
    public static final List<BigInteger> pollardsRhoFactors(@NotNull BigInteger $this$pollardsRhoFactors, int iteration, @NotNull BigInteger funBias) {
        Intrinsics.checkNotNullParameter((Object)$this$pollardsRhoFactors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)funBias, (String)"funBias");
        List factors = new ArrayList();
        if ($this$pollardsRhoFactors.isProbablePrime(100)) {
            List list;
            List $this$pollardsRhoFactors_u24lambda_u2d3 = list = factors;
            boolean bl = false;
            $this$pollardsRhoFactors_u24lambda_u2d3.add($this$pollardsRhoFactors);
            return list;
        }
        BigInteger n = $this$pollardsRhoFactors;
        BigInteger rho = null;
        while (true) {
            Object object = FactorsKt.pollardsRho(n, funBias, iteration);
            BigInteger it = object;
            boolean bl = false;
            rho = it;
            if (Intrinsics.areEqual((Object)object, (Object)n)) break;
            System.out.println((Object)("rho " + rho));
            if (rho.compareTo(BigInteger.ZERO) < 0) {
                Object $this$pollardsRhoFactors_u24lambda_u2d5 = object = factors;
                boolean bl2 = false;
                $this$pollardsRhoFactors_u24lambda_u2d5.add(rho);
                return object;
            }
            factors.add(rho);
            Intrinsics.checkNotNullExpressionValue((Object)n.divide(rho), (String)"this.divide(other)");
        }
        if (!Intrinsics.areEqual((Object)n, (Object)BigInteger.ONE)) {
            factors.add(n);
        }
        return factors;
    }

    public static /* synthetic */ List pollardsRhoFactors$default(BigInteger bigInteger, int n, BigInteger bigInteger2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        if ((n2 & 2) != 0) {
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            bigInteger2 = bigInteger3;
        }
        return FactorsKt.pollardsRhoFactors(bigInteger, n, bigInteger2);
    }

    @NotNull
    public static final BigInteger pollardsRho(@NotNull BigInteger $this$pollardsRho, @NotNull BigInteger funBias, int maxIteration) {
        Intrinsics.checkNotNullParameter((Object)$this$pollardsRho, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)funBias, (String)"funBias");
        if ($this$pollardsRho.isProbablePrime(100)) {
            return $this$pollardsRho;
        }
        System.out.println((Object)("rho: start factor " + $this$pollardsRho));
        long iteration = 0L;
        BigInteger x = BigInteger.TWO;
        BigInteger y = BigInteger.TWO;
        BigInteger d = BigInteger.ONE;
        Function1 f2 = (Function1)new Function1<BigInteger, BigInteger>($this$pollardsRho, funBias){
            final /* synthetic */ BigInteger $this_pollardsRho;
            final /* synthetic */ BigInteger $funBias;
            {
                this.$this_pollardsRho = $receiver;
                this.$funBias = $funBias;
                super(1);
            }

            @NotNull
            public final BigInteger invoke(@NotNull BigInteger a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                BigInteger bigInteger = this.$this_pollardsRho;
                BigInteger bigInteger2 = BigInteger.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
                BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.subtract(other)");
                BigInteger bigInteger4 = a.modPow(bigInteger3, this.$this_pollardsRho);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"a.modPow(this - ONE, this)");
                BigInteger bigInteger5 = bigInteger4;
                BigInteger bigInteger6 = bigInteger5.add(this.$funBias);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.add(other)");
                bigInteger5 = bigInteger6;
                BigInteger bigInteger7 = bigInteger5.remainder(this.$this_pollardsRho);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.remainder(other)");
                return bigInteger7;
            }
        };
        while (Intrinsics.areEqual((Object)d, (Object)BigInteger.ONE)) {
            BigInteger bigInteger;
            long l = iteration;
            iteration = l + 1L;
            BigInteger bigInteger2 = x;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"x");
            x = (BigInteger)f2.invoke((Object)bigInteger2);
            BigInteger bigInteger3 = y;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"y");
            y = (BigInteger)f2.invoke(f2.invoke((Object)bigInteger3));
            Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
            BigInteger bigInteger4 = y;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"y");
            BigInteger bigInteger5 = bigInteger.subtract(bigInteger4);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.subtract(other)");
            d = $this$pollardsRho.gcd(bigInteger5.abs());
            if (iteration < (long)maxIteration) continue;
            BigInteger bigInteger6 = $this$pollardsRho.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.negate()");
            return bigInteger6;
        }
        System.out.println((Object)("rho: iteration " + iteration + " found " + d + ' '));
        BigInteger bigInteger = d;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"d");
        return bigInteger;
    }

    public static /* synthetic */ BigInteger pollardsRho$default(BigInteger bigInteger, BigInteger bigInteger2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            bigInteger2 = bigInteger3;
        }
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return FactorsKt.pollardsRho(bigInteger, bigInteger2, n);
    }

    @NotNull
    public static final List<BigInteger> pollardsPM1Factors(@NotNull BigInteger $this$pollardsPM1Factors, int iteration) {
        Intrinsics.checkNotNullParameter((Object)$this$pollardsPM1Factors, (String)"<this>");
        List factors = new ArrayList();
        if ($this$pollardsPM1Factors.isProbablePrime(100)) {
            List list;
            List $this$pollardsPM1Factors_u24lambda_u2d6 = list = factors;
            boolean bl = false;
            $this$pollardsPM1Factors_u24lambda_u2d6.add($this$pollardsPM1Factors);
            return list;
        }
        BigInteger n = $this$pollardsPM1Factors;
        BigInteger rho = null;
        while (true) {
            BigInteger bigInteger;
            BigInteger it = bigInteger = FactorsKt.pMinus1(n, iteration);
            boolean bl = false;
            rho = it;
            if (Intrinsics.areEqual((Object)bigInteger, (Object)n)) break;
            System.out.println((Object)("rho " + rho));
            factors.add(rho);
            if (rho.compareTo(BigInteger.ZERO) < 0) {
                return factors;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n.divide(rho), (String)"this.divide(other)");
        }
        if (!Intrinsics.areEqual((Object)n, (Object)BigInteger.ONE)) {
            factors.add(n);
        }
        return factors;
    }

    public static /* synthetic */ List pollardsPM1Factors$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        return FactorsKt.pollardsPM1Factors(bigInteger, n);
    }

    @NotNull
    public static final BigInteger pMinus1(@NotNull BigInteger $this$pMinus1, int maxIteration) {
        Intrinsics.checkNotNullParameter((Object)$this$pMinus1, (String)"<this>");
        if ($this$pMinus1.isProbablePrime(100)) {
            return $this$pMinus1;
        }
        System.out.println((Object)("pm1: start factor " + $this$pMinus1));
        BigInteger m = BigInteger.TWO;
        BigInteger i = BigInteger.ONE;
        long iteration = 0L;
        while (i.compareTo($this$pMinus1) < 0) {
            long l = iteration;
            iteration = l + 1L;
            BigInteger bigInteger = m.pow(i.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"m.pow(i.toInt())");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger.remainder($this$pMinus1), (String)"this.remainder(other)");
            BigInteger bigInteger2 = m;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"m");
            BigInteger bigInteger3 = bigInteger2;
            BigInteger bigInteger4 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"ONE");
            BigInteger bigInteger5 = bigInteger3.subtract(bigInteger4);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.subtract(other)");
            BigInteger gcd = $this$pMinus1.gcd(bigInteger5);
            if (!Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
                System.out.println((Object)("pm1: found " + gcd + " iteration: " + iteration));
                Intrinsics.checkNotNullExpressionValue((Object)gcd, (String)"gcd");
                return gcd;
            }
            if (iteration >= (long)maxIteration) {
                BigInteger bigInteger6 = $this$pMinus1.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.negate()");
                return bigInteger6;
            }
            BigInteger bigInteger7 = i;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"i");
            bigInteger3 = bigInteger7;
            BigInteger bigInteger8 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"ONE");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3.add(bigInteger8), (String)"this.add(other)");
        }
        System.out.println((Object)"pm1: not found");
        BigInteger bigInteger = $this$pMinus1.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
        return bigInteger;
    }

    public static /* synthetic */ BigInteger pMinus1$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        return FactorsKt.pMinus1(bigInteger, n);
    }

    @NotNull
    public static final List<BigInteger> factor(@NotNull BigInteger $this$factor) {
        Intrinsics.checkNotNullParameter((Object)$this$factor, (String)"<this>");
        Object[] objectArray = new Function1[]{factor.1.INSTANCE, factor.2.INSTANCE, factor.3.INSTANCE, factor.4.INSTANCE, factor.5.INSTANCE, factor.6.INSTANCE, factor.7.INSTANCE};
        return FactorsKt.factor($this$factor, CollectionsKt.listOf((Object[])objectArray));
    }

    private static final List<BigInteger> factor(BigInteger $this$factor, List<? extends Function1<? super BigInteger, ? extends List<? extends BigInteger>>> funList) {
        if ($this$factor.compareTo(THREE) <= 0) {
            Object[] objectArray = new BigInteger[]{$this$factor};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        BigInteger last = $this$factor;
        List factors = new ArrayList();
        for (Function1<? super BigInteger, ? extends List<? extends BigInteger>> function1 : funList) {
            BigInteger bigInteger = last.abs();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"last.abs()");
            factors.addAll((Collection)function1.invoke((Object)bigInteger));
            last = (BigInteger)CollectionsKt.last((List)factors);
            if (last.compareTo(BigInteger.ZERO) >= 0) break;
            factors.remove(last);
        }
        if (last.compareTo(BigInteger.ZERO) < 0) {
            factors.add(last);
        }
        return factors;
    }

    static {
        BigInteger bigInteger = BigInteger.valueOf(3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this.toLong())");
        THREE = bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(10000);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(this.toLong())");
        MAX_DIVIDER = bigInteger2;
    }
}

