/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf.rsa;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.BigIntegerKt;
import me.leon.ConstantsKt;
import me.leon.DivideResult;
import me.leon.KgcdKt;
import me.leon.ctf.rsa.FactorsKt;
import me.leon.ctf.rsa.RsaSolverKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u001a\u0010\u001d\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010\u001e\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u0010\u001f\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001a\u0010 \u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010!\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u0010\"\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u0010#\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J \u0010$\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u001c\u0010$\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J(\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u001a\u0010%\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010(\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lme/leon/ctf/rsa/RsaSolver;", "", "()V", "modeBroadcastN3C3", "", "", "modeDp", "modeDpDq", "modeEC", "modeN2E2C2", "modeN2EC", "modeN2EC2", "modeNCD", "modeNE2C2", "modeNEC", "modeNECP", "modeNECPhi", "modePQEC", "modePQEC2", "modePQREC", "modePQRnEC", "dpLeak", "params", "", "Ljava/math/BigInteger;", "smallE", "n", "c", "e", "solve", "solveBroadCast", "solveDpDq", "solveN2E2C2", "solveN2EC2", "solveNCD", "solveNE2C2", "solveNEC", "solvePQEC", "p", "q", "solvePQREC", "app"})
public final class RsaSolver {
    @NotNull
    public static final RsaSolver INSTANCE = new RsaSolver();
    @NotNull
    private static final List<String> modeNECP;
    @NotNull
    private static final List<String> modeNEC;
    @NotNull
    private static final List<String> modeN2EC;
    @NotNull
    private static final List<String> modeNCD;
    @NotNull
    private static final List<String> modePQREC;
    @NotNull
    private static final List<String> modePQRnEC;
    @NotNull
    private static final List<String> modeN2E2C2;
    @NotNull
    private static final List<String> modeN2EC2;
    @NotNull
    private static final List<String> modeNE2C2;
    @NotNull
    private static final List<String> modeEC;
    @NotNull
    private static final List<String> modeNECPhi;
    @NotNull
    private static final List<String> modePQEC;
    @NotNull
    private static final List<String> modePQEC2;
    @NotNull
    private static final List<String> modeDpDq;
    @NotNull
    private static final List<String> modeDp;
    @NotNull
    private static final List<String> modeBroadcastN3C3;

    private RsaSolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String solve(@NotNull Map<String, BigInteger> params) {
        String string;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        if (RsaSolverKt.containKeys(params, modeNECPhi)) {
            String string2;
            BigInteger bigInteger = params.get("c");
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger2 = params.get("e");
            Intrinsics.checkNotNull((Object)bigInteger2);
            BigInteger bigInteger3 = params.get("phi");
            Intrinsics.checkNotNull((Object)bigInteger3);
            BigInteger bigInteger4 = BigIntegerKt.invert(bigInteger2, bigInteger3);
            BigInteger bigInteger5 = params.get("n");
            Intrinsics.checkNotNull((Object)bigInteger5);
            String it = string2 = BigIntegerKt.decrypt(bigInteger, bigInteger4, bigInteger5);
            boolean bl = false;
            System.out.println((Object)"solve N E C Phi ");
            string = string2;
        } else if (RsaSolverKt.containKeys(params, modeBroadcastN3C3)) {
            string = this.solveBroadCast(params);
        } else if (RsaSolverKt.containKeys(params, modeDp) && params.get("dq") == null) {
            string = this.dpLeak(params);
        } else if (RsaSolverKt.containKeys(params, modeN2EC)) {
            void $this$solve_u24lambda_u2d1;
            Map<String, BigInteger> map;
            Map<String, BigInteger> it = map = params;
            RsaSolver rsaSolver = this;
            boolean bl = false;
            Object v = $this$solve_u24lambda_u2d1.get("c");
            Intrinsics.checkNotNull(v);
            $this$solve_u24lambda_u2d1.put("c1", v);
            Object v2 = $this$solve_u24lambda_u2d1.get("c");
            Intrinsics.checkNotNull(v2);
            $this$solve_u24lambda_u2d1.put("c2", v2);
            string = rsaSolver.solveN2EC2(map);
        } else if (RsaSolverKt.containKeys(params, modeDpDq)) {
            string = this.solveDpDq(params);
        } else if (RsaSolverKt.containKeys(params, modePQREC) || RsaSolverKt.containKeys(params, modePQRnEC)) {
            string = this.solvePQREC(params);
        } else if (RsaSolverKt.containKeys(params, modeNCD)) {
            string = this.solveNCD(params);
        } else if (RsaSolverKt.containKeys(params, modeN2E2C2)) {
            string = this.solveN2E2C2(params);
        } else if (RsaSolverKt.containKeys(params, modePQEC2)) {
            void $this$solve_u24lambda_u2d2;
            Map<String, BigInteger> map;
            Map<String, BigInteger> $this$solve_u24lambda_u2d1 = map = params;
            RsaSolver rsaSolver = this;
            boolean bl = false;
            BigInteger bigInteger = params.get("p1");
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger6 = params.get("q1");
            Intrinsics.checkNotNull((Object)bigInteger6);
            BigInteger bigInteger7 = bigInteger.multiply(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.multiply(other)");
            $this$solve_u24lambda_u2d2.put("n1", bigInteger7);
            BigInteger bigInteger8 = params.get("p2");
            Intrinsics.checkNotNull((Object)bigInteger8);
            BigInteger bigInteger9 = params.get("q2");
            Intrinsics.checkNotNull((Object)bigInteger9);
            BigInteger bigInteger10 = bigInteger8.multiply(bigInteger9);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.multiply(other)");
            $this$solve_u24lambda_u2d2.put("n2", bigInteger10);
            string = rsaSolver.solveN2E2C2(map);
        } else if (RsaSolverKt.containKeys(params, modeNE2C2)) {
            string = this.solveNE2C2(params);
        } else if (RsaSolverKt.containKeys(params, modeN2EC2)) {
            string = this.solveN2EC2(params);
        } else if (RsaSolverKt.containKeys(params, modePQEC)) {
            string = this.solvePQEC(params);
        } else if (RsaSolverKt.containKeys(params, modeNECP)) {
            string = this.solvePQEC(params);
        } else if (RsaSolverKt.containKeys(params, modeNEC)) {
            string = this.solveNEC(params);
        } else if (RsaSolverKt.containKeys(params, modeEC) && Intrinsics.areEqual((Object)params.get("e"), (Object)BigInteger.ONE)) {
            BigInteger bigInteger = params.get("c");
            Intrinsics.checkNotNull((Object)bigInteger);
            string = BigIntegerKt.n2s(bigInteger);
        } else {
            throw new IllegalStateException("wrong parameters!!!".toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String solvePQREC(Map<String, BigInteger> params) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        System.out.println((Object)"solve P Q R E C");
        BigInteger bigInteger = params.get("e");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger;
        BigInteger bigInteger2 = params.get("c");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger2;
        Iterable $this$filter$iv = params.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)it, (String)"r", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)it, (Object)"p") || Intrinsics.areEqual((Object)it, (Object)"q"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BigInteger bigInteger3 = params.get(it);
            Intrinsics.checkNotNull((Object)bigInteger3);
            collection.add(bigInteger3);
        }
        List factors = (List)destination$iv$iv;
        BigInteger bigInteger4 = params.get("n");
        if (bigInteger4 == null) {
            bigInteger4 = BigIntegerKt.product(factors);
        }
        BigInteger n = bigInteger4;
        BigInteger phi = BigIntegerKt.phi(factors);
        return BigIntegerKt.decrypt(c, BigIntegerKt.invert(e, phi), n);
    }

    private final String solveNCD(Map<String, BigInteger> params) {
        System.out.println((Object)"solve N C D ");
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n = bigInteger;
        BigInteger bigInteger2 = params.get("d");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger d = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        return BigIntegerKt.decrypt(c, d, n);
    }

    /*
     * WARNING - void declaration
     */
    private final String solveBroadCast(Map<String, BigInteger> params) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        int n;
        void $this$fold$iv;
        void $this$filterTo$iv$iv2;
        System.out.println((Object)"solve broadcast");
        Iterable $this$filter$iv = params.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it2 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it2, (String)"n", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        BigInteger initial$iv = BigInteger.ONE;
        boolean $i$f$fold = false;
        BigInteger accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            Object element$iv$iv;
            element$iv$iv = (String)element$iv;
            BigInteger acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc, (String)"acc");
            BigInteger bigInteger = params.get(s);
            Intrinsics.checkNotNull((Object)bigInteger);
            Intrinsics.checkNotNullExpressionValue((Object)acc.multiply(bigInteger), (String)"this.multiply(other)");
        }
        BigInteger modular = accumulator$iv;
        Iterable $this$count$iv = params.keySet();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it3 = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it3, (String)"n", (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int e = n;
        Iterable $this$filter$iv2 = params.keySet();
        boolean $i$f$filter2 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"n", (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append('c');
            String string = it.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            BigInteger bigInteger = params.get(stringBuilder.append(string).toString());
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger2 = params.get(it);
            Intrinsics.checkNotNull((Object)bigInteger2);
            collection.add(new DivideResult(bigInteger, bigInteger2));
        }
        List divides = (List)destination$iv$iv2;
        BigInteger me = KgcdKt.crt(divides);
        Intrinsics.checkNotNullExpressionValue((Object)modular, (String)"modular");
        BigInteger bigInteger = me.remainder(modular);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.remainder(other)");
        BigInteger cx = bigInteger;
        for (int i = e - 1; i < 101; ++i) {
            Object[] result = BigIntegerKt.root(cx, i);
            if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])result), (Object)BigInteger.ZERO)) continue;
            System.out.println((Object)(i + " got result " + ArraysKt.first((Object[])result)));
            return BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])result));
        }
        return "no solution!!!";
    }

    private final String solveN2EC2(Map<String, BigInteger> params) {
        Object object;
        block9: {
            String decrypt2;
            block8: {
                System.out.println((Object)"solve N2 E C2");
                BigInteger bigInteger = params.get("e");
                if (bigInteger == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                BigInteger e = bigInteger;
                BigInteger bigInteger2 = params.get("n1");
                if (bigInteger2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                BigInteger n1 = bigInteger2;
                BigInteger bigInteger3 = params.get("c1");
                if (bigInteger3 == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                BigInteger c1 = bigInteger3;
                BigInteger bigInteger4 = params.get("c2");
                if (bigInteger4 == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                BigInteger c2 = bigInteger4;
                BigInteger bigInteger5 = params.get("n2");
                if (bigInteger5 == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                BigInteger n2 = bigInteger5;
                BigInteger p = n1.gcd(n2);
                Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                BigInteger bigInteger6 = n1.divide(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.divide(other)");
                BigInteger q1 = bigInteger6;
                BigInteger bigInteger7 = n2.divide(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.divide(other)");
                BigInteger q2 = bigInteger7;
                System.out.println((Object)("gcd: " + e.gcd(BigIntegerKt.phi(p, q1))));
                BigInteger d2 = BigIntegerKt.invert(e, BigIntegerKt.phi(p, q2));
                BigInteger c = c2.modPow(d2, n2);
                BigInteger d1 = BigIntegerKt.invert(e, BigIntegerKt.phi(p, q1));
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"c");
                decrypt2 = BigIntegerKt.decrypt(c, d1, n1);
                object = Regex.find$default((Regex)ConstantsKt.getREG_NON_PRINTABLE(), (CharSequence)decrypt2, (int)0, (int)2, null);
                if (object == null) break block8;
                MatchResult $this$solveN2EC2_u24lambda_u2d10 = object;
                boolean bl = false;
                String string = BigIntegerKt.decrypt(c1, d1, n1);
                object = string;
                if (string != null) break block9;
            }
            RsaSolver $this$solveN2EC2_u24lambda_u2d11 = this;
            boolean bl = false;
            object = decrypt2;
        }
        return object;
    }

    private final String solveNE2C2(Map<String, BigInteger> params) {
        Map<String, BigInteger> map = params;
        String string = "n1";
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        BigInteger bigInteger2 = bigInteger;
        map.put(string, bigInteger2);
        map = params;
        string = "n2";
        BigInteger bigInteger3 = params.get("n");
        if (bigInteger3 == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        bigInteger2 = bigInteger3;
        map.put(string, bigInteger2);
        return this.solveN2E2C2(params);
    }

    @NotNull
    public final String solveN2E2C2(@NotNull Map<String, BigInteger> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        System.out.println((Object)"solve N2 E2 C2");
        BigInteger bigInteger = params.get("n1");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n1 = bigInteger;
        BigInteger bigInteger2 = params.get("n2");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n2 = bigInteger2;
        BigInteger bigInteger3 = params.get("e1");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e1 = bigInteger3;
        BigInteger bigInteger4 = params.get("e2");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e2 = bigInteger4;
        BigInteger bigInteger5 = params.get("c1");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c1 = bigInteger5;
        BigInteger bigInteger6 = params.get("c2");
        if (bigInteger6 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c2 = bigInteger6;
        BigInteger[] bigIntegerArray = BigIntegerKt.gcdExt(e1, e2);
        BigInteger s1 = bigIntegerArray[1];
        BigInteger s2 = bigIntegerArray[2];
        BigInteger bigInteger7 = c1.modPow(s1, n1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"c1.modPow(s1, n1)");
        BigInteger bigInteger8 = bigInteger7;
        BigInteger bigInteger9 = c2.modPow(s2, n2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"c2.modPow(s2, n2)");
        BigInteger bigInteger10 = bigInteger8.multiply(bigInteger9);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.multiply(other)");
        BigInteger bigInteger11 = bigInteger10.remainder(n1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"this.remainder(other)");
        return BigIntegerKt.n2s(bigInteger11);
    }

    private final String solveNEC(Map<String, BigInteger> params) {
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n = bigInteger;
        BigInteger bigInteger2 = params.get("e");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        return this.solveNEC(n, e, c);
    }

    private final String solveNEC(BigInteger n, BigInteger e, BigInteger c) {
        Object object;
        System.out.println((Object)"solve N E C");
        if (Intrinsics.areEqual((Object)e, (Object)BigInteger.ONE)) {
            String string;
            String it = string = BigIntegerKt.n2s(c);
            boolean bl = false;
            System.out.println((Object)"e = 1");
            object = string;
        } else if (n.isProbablePrime(100)) {
            System.out.println((Object)"nec n is prime");
            BigInteger it = n;
            BigInteger bigInteger = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE");
            BigInteger bigInteger2 = it.subtract(bigInteger);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.subtract(other)");
            BigInteger phi = bigInteger2;
            BigInteger bigInteger3 = c.modPow(BigIntegerKt.invert(e, phi), n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"c.modPow(e.invert(phi), n)");
            object = BigIntegerKt.n2s(bigInteger3);
        } else {
            BigInteger bigInteger = BigInteger.valueOf(6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this.toLong())");
            if (e.compareTo(bigInteger) < 0) {
                object = this.smallE(n, c, e);
            } else if (e.bitLength() > 100) {
                Object[] $this$solveNEC_u24lambda_u2d13 = BigIntegerKt.wiener(e, n);
                boolean bl = false;
                System.out.println((Object)"wiener attack");
                object = $this$solveNEC_u24lambda_u2d13.length == 0 ? "wiener failed" : BigIntegerKt.decrypt(c, (BigInteger)ArraysKt.first((Object[])$this$solveNEC_u24lambda_u2d13), n);
            } else if (!Intrinsics.areEqual((Object)n.gcd(c), (Object)BigInteger.ONE)) {
                System.out.println((Object)"n c are not coprime");
                BigInteger p = n.gcd(c);
                Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                BigInteger bigInteger4 = n.divide(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.divide(other)");
                BigInteger q = bigInteger4;
                BigInteger phi = BigIntegerKt.phi(p, q);
                BigInteger bigInteger5 = c.modPow(BigIntegerKt.invert(e, phi), n);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"c.modPow(e.invert(phi), n)");
                BigInteger bigInteger6 = bigInteger5;
                BigInteger bigInteger7 = bigInteger6.divide(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.divide(other)");
                object = BigIntegerKt.n2s(bigInteger7);
            } else {
                Object it;
                BigInteger phi;
                BigInteger $this$groupByTo$iv$iv;
                List<BigInteger> factors;
                System.out.println((Object)"factor: start");
                List<BigInteger> it2 = factors = FactorsKt.factor(n);
                boolean bl = false;
                Iterable $this$groupBy$iv = it2;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator iterator = $this$groupByTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    Object element$iv$iv = iterator.next();
                    BigInteger it3 = (BigInteger)element$iv$iv;
                    boolean bl2 = false;
                    BigInteger key$iv$iv = it3;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                if (destination$iv$iv.size() == 1) {
                    System.out.println((Object)("euler solve " + CollectionsKt.first(it2) + " ^ " + it2.size()));
                    phi = BigIntegerKt.eulerPhi((BigInteger)CollectionsKt.first(it2), it2.size());
                    $this$groupByTo$iv$iv = BigIntegerKt.invert(e, phi);
                    it = $this$groupByTo$iv$iv;
                    boolean bl4 = false;
                    System.out.println(it);
                    BigInteger d = $this$groupByTo$iv$iv;
                    BigInteger propN = BigIntegerKt.propN(it2, n);
                    Object it4 = it = BigIntegerKt.decrypt(c, d, propN);
                    boolean bl5 = false;
                    System.out.println(it4);
                    object = it;
                } else if (it2.size() >= 2) {
                    BigInteger propN;
                    BigInteger d;
                    System.out.println(it2);
                    phi = BigIntegerKt.phi(it2);
                    BigInteger gcd = e.gcd(phi);
                    if (Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
                        System.out.println((Object)("e phi are coprime " + phi));
                        Object it5 = it = BigIntegerKt.invert(e, phi);
                        boolean bl6 = false;
                        System.out.println(it5);
                        d = it;
                        propN = BigIntegerKt.propN(it2, n);
                        Object it6 = it5 = BigIntegerKt.decrypt(c, d, propN);
                        boolean bl7 = false;
                        System.out.println(it6);
                        object = it5;
                    } else {
                        System.out.println((Object)("e phi are not are coprime  " + gcd));
                        Intrinsics.checkNotNullExpressionValue((Object)gcd, (String)"gcd");
                        BigInteger bigInteger8 = e.divide(gcd);
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"this.divide(other)");
                        BigInteger it7 = propN = BigIntegerKt.invert(bigInteger8, phi);
                        boolean bl8 = false;
                        System.out.println(it7);
                        d = propN;
                        BigInteger m = c.modPow(d, n);
                        String result = "";
                        for (int i = 1; i < 1000001; ++i) {
                            Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
                            BigInteger bigInteger9 = BigInteger.valueOf(i);
                            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"valueOf(this.toLong())");
                            BigInteger bigInteger10 = n.multiply(bigInteger9);
                            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.multiply(other)");
                            BigInteger bigInteger11 = m.add(bigInteger10);
                            Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"this.add(other)");
                            Object[] root2 = BigIntegerKt.root(bigInteger11, gcd.intValue());
                            if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])root2), (Object)BigInteger.ZERO)) continue;
                            System.out.println(i);
                            result = BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])root2));
                            System.out.println((Object)("times " + i + ' ' + ArraysKt.first((Object[])root2) + ' ' + result));
                            break;
                        }
                        object = result;
                    }
                } else {
                    object = "no solution";
                }
            }
        }
        return object;
    }

    private final String smallE(BigInteger n, BigInteger c, BigInteger e) {
        int exp = e.intValue();
        System.out.println((Object)("small e= " + exp));
        for (int k = 0; k < 10001; ++k) {
            BigInteger bigInteger = BigInteger.valueOf(k);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this.toLong())");
            BigInteger bigInteger2 = bigInteger.multiply(n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
            BigInteger bigInteger3 = bigInteger2.add(c);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.add(other)");
            Object[] m = BigIntegerKt.root(bigInteger3, exp);
            if (!Intrinsics.areEqual((Object)m[1], (Object)BigInteger.ZERO)) continue;
            return BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])m));
        }
        return "no solution";
    }

    private final String dpLeak(Map<String, BigInteger> params) {
        System.out.println((Object)"dp leak");
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n = bigInteger;
        BigInteger bigInteger2 = params.get("e");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        BigInteger bigInteger4 = params.get("dp");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger dp = bigInteger4;
        BigInteger p = BigInteger.ONE;
        BigInteger q = BigInteger.ONE;
        for (int k = 1; k < 65538; ++k) {
            BigInteger bigInteger5;
            BigInteger bigInteger6 = e.multiply(dp);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.multiply(other)");
            BigInteger bigInteger7 = bigInteger6;
            BigInteger bigInteger8 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"ONE");
            BigInteger bigInteger9 = bigInteger7.subtract(bigInteger8);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"this.subtract(other)");
            bigInteger7 = bigInteger9;
            Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(k), (String)"valueOf(this.toLong())");
            BigInteger bigInteger10 = bigInteger7.divide(bigInteger5);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.divide(other)");
            bigInteger7 = bigInteger10;
            BigInteger bigInteger11 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"ONE");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7.add(bigInteger11), (String)"this.add(other)");
            if (Intrinsics.areEqual((Object)n.gcd(p), (Object)BigInteger.ONE)) continue;
            bigInteger7 = n;
            BigInteger bigInteger12 = p;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"p");
            BigInteger bigInteger13 = bigInteger7.divide(bigInteger12);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger13, (String)"this.divide(other)");
            q = bigInteger13;
            break;
        }
        BigInteger bigInteger14 = p;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger14, (String)"p");
        BigInteger bigInteger15 = q;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger15, (String)"q");
        return BigIntegerKt.decrypt(c, BigIntegerKt.invert(e, BigIntegerKt.phi(bigInteger14, bigInteger15)), n);
    }

    private final String solveDpDq(Map<String, BigInteger> params) {
        System.out.println((Object)"solveDpDq");
        BigInteger bigInteger = params.get("p");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger p = bigInteger;
        BigInteger bigInteger2 = params.get("q");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger q = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        BigInteger bigInteger4 = params.get("dp");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger dp = bigInteger4;
        BigInteger bigInteger5 = params.get("dq");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger dq = bigInteger5;
        BigInteger invQ = BigIntegerKt.invert(q, p);
        BigInteger mp = c.modPow(dp, p);
        BigInteger mq = c.modPow(dq, q);
        Intrinsics.checkNotNullExpressionValue((Object)mp, (String)"mp");
        Intrinsics.checkNotNullExpressionValue((Object)mq, (String)"mq");
        BigInteger bigInteger6 = mp.subtract(mq);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.subtract(other)");
        BigInteger bigInteger7 = bigInteger6.multiply(invQ);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"this.multiply(other)");
        BigInteger bigInteger8 = bigInteger7.remainder(p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"this.remainder(other)");
        BigInteger bigInteger9 = bigInteger8.multiply(q);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"this.multiply(other)");
        BigInteger bigInteger10 = bigInteger9.add(mq);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.add(other)");
        BigInteger m = bigInteger10;
        return BigIntegerKt.n2s(m);
    }

    @NotNull
    public final String solvePQEC(@NotNull Map<String, BigInteger> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        BigInteger bigInteger = params.get("p");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger p = bigInteger;
        BigInteger bigInteger2 = params.get("q");
        if (bigInteger2 == null) {
            BigInteger bigInteger3 = params.get("n");
            Intrinsics.checkNotNull((Object)bigInteger3);
            BigInteger bigInteger4 = bigInteger3.divide(p);
            bigInteger2 = bigInteger4;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.divide(other)");
        }
        BigInteger q = bigInteger2;
        BigInteger bigInteger5 = params.get("e");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger5;
        BigInteger bigInteger6 = params.get("c");
        if (bigInteger6 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger6;
        return this.solvePQEC(p, q, e, c);
    }

    private final String solvePQEC(BigInteger p, BigInteger q, BigInteger e, BigInteger c) {
        String string;
        System.out.println((Object)"solve P Q E C");
        BigInteger bigInteger = p.multiply(q);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
        BigInteger n = bigInteger;
        BigInteger phi = BigIntegerKt.phi(p, q);
        if (Intrinsics.areEqual((Object)e.gcd(phi), (Object)BigInteger.ONE)) {
            System.out.println((Object)"solve P Q E C e phi are coprime");
            BigInteger d = BigIntegerKt.invert(e, BigIntegerKt.phi(p, q));
            BigInteger bigInteger2 = p.multiply(q);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
            string = BigIntegerKt.decrypt(c, d, bigInteger2);
        } else {
            BigInteger t = e.gcd(phi);
            System.out.println((Object)("solve P Q E C e phi not are coprime!! " + t));
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            BigInteger bigInteger3 = e.divide(t);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.divide(other)");
            BigInteger t1 = bigInteger3;
            BigInteger dt1 = BigIntegerKt.invert(t1, phi);
            BigInteger bigInteger4 = c.modPow(dt1, n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"c.modPow(dt1, n)");
            string = BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])BigIntegerKt.root(bigInteger4, t.intValue())));
        }
        return string;
    }

    static {
        Object[] objectArray = new String[]{"n", "e", "c", "p"};
        modeNECP = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "e", "c"};
        modeNEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "n2", "e", "c"};
        modeN2EC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "c", "d"};
        modeNCD = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p", "q", "r", "e", "c"};
        modePQREC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p", "q", "r1", "r2", "e", "c"};
        modePQRnEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "e1", "c1", "n2", "e2", "c2"};
        modeN2E2C2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "c1", "n2", "e", "c2"};
        modeN2EC2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "c1", "e2", "e1", "c2"};
        modeNE2C2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"e", "c"};
        modeEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "e", "c", "phi"};
        modeNECPhi = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p", "q", "e", "c"};
        modePQEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p1", "q1", "e1", "c1", "p2", "q2", "e2", "c2"};
        modePQEC2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"dp", "dq", "p", "q", "c"};
        modeDpDq = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"dp", "e", "c", "n"};
        modeDp = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "c1", "n2", "c2", "n3", "c3"};
        modeBroadcastN3C3 = CollectionsKt.listOf((Object[])objectArray);
    }
}

