/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext;

import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.leon.encode.OctalKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a\u001e\u0010\t\u001a\u00020\u0006*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u001a\u001c\u0010\f\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u001a\u001a\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"ENCODERS", "", "", "getENCODERS", "()Ljava/util/List;", "charsetChange", "", "from", "to", "decodeToByteArray", "encoder", "charset", "encodeTo", "padStart", "length", "", "byte", "", "app"})
public final class ByteArrayKt {
    @NotNull
    private static final List<String> ENCODERS;

    @NotNull
    public static final List<String> getENCODERS() {
        return ENCODERS;
    }

    @NotNull
    public static final byte[] charsetChange(@NotNull byte[] $this$charsetChange, @NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)$this$charsetChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Object object = $this$charsetChange;
        Charset charset = Charset.forName(from);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(from)");
        Charset charset2 = charset;
        object = new String((byte[])object, charset2);
        Charset charset3 = Charset.forName(to);
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(to)");
        byte[] byArray = ((String)object).getBytes(charset3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public static final byte[] padStart(@NotNull byte[] $this$padStart, int length, byte by) {
        Intrinsics.checkNotNullParameter((Object)$this$padStart, (String)"<this>");
        if ($this$padStart.length % length == 0) {
            return $this$padStart;
        }
        int padCount = length - $this$padStart.length % length;
        byte[] bytes = new byte[$this$padStart.length + padCount];
        int n = 0;
        while (n < padCount) {
            int it = n++;
            boolean bl = false;
            bytes[it] = by;
        }
        ArraysKt.copyInto$default((byte[])$this$padStart, (byte[])bytes, (int)padCount, (int)0, (int)0, (int)12, null);
        return bytes;
    }

    @NotNull
    public static final byte[] decodeToByteArray(@NotNull String $this$decodeToByteArray, @NotNull String encoder, @NotNull String charset) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$decodeToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        switch (encoder) {
            case "raw": {
                String string = $this$decodeToByteArray;
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
                byte[] byArray2 = string.getBytes(charset2);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                break;
            }
            case "oct": {
                byArray = OctalKt.octalDecode($this$decodeToByteArray);
                break;
            }
            case "binary": {
                byArray = ConverterKt.binary2ByteArray($this$decodeToByteArray);
                break;
            }
            case "hex": {
                byArray = ConverterKt.hex2ByteArray($this$decodeToByteArray);
                break;
            }
            case "base64": {
                byArray = Base64Kt.base64Decode$default($this$decodeToByteArray, null, 1, null);
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown encoder: " + encoder).toString());
            }
        }
        return byArray;
    }

    public static /* synthetic */ byte[] decodeToByteArray$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "raw";
        }
        if ((n & 2) != 0) {
            string3 = "UTF-8";
        }
        return ByteArrayKt.decodeToByteArray(string, string2, string3);
    }

    @NotNull
    public static final String encodeTo(@NotNull byte[] $this$encodeTo, @NotNull String encoder, @NotNull String charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$encodeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        switch (encoder) {
            case "raw": {
                byte[] byArray = $this$encodeTo;
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
                Charset charset3 = charset2;
                string = new String(byArray, charset3);
                break;
            }
            case "base64": {
                string = Base64Kt.base64$default($this$encodeTo, null, false, 3, null);
                break;
            }
            case "hex": {
                string = ConverterKt.toHex($this$encodeTo);
                break;
            }
            case "oct": {
                string = OctalKt.octal$default($this$encodeTo, null, 1, null);
                break;
            }
            case "binary": {
                string = ConverterKt.toBinaryString($this$encodeTo);
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown encoder: " + encoder).toString());
            }
        }
        return string;
    }

    public static /* synthetic */ String encodeTo$default(byte[] byArray, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UTF-8";
        }
        return ByteArrayKt.encodeTo(byArray, string, string2);
    }

    static {
        Object[] objectArray = new String[]{"raw", "hex", "base64", "oct", "binary"};
        ENCODERS = CollectionsKt.listOf((Object[])objectArray);
    }
}

