/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.ext.ParamsParserKt;
import me.leon.ext.crypto.RsaKt;
import me.leon.ext.crypto.SMKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import org.bouncycastle.pqc.jcajce.spec.LMSKeyGenParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.SPHINCSPlusParameterSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u001a!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001b\u001a)\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0003\u00a2\u0006\u0002\u0010\u001e\u001a\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00022\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0003\u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002\u001a\u000e\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u000e\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002\u001a\u001c\u0010(\u001a\u00020\"*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010)2\u0006\u0010\u0017\u001a\u00020\u0002\u001a&\u0010*\u001a\u00020\"*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010)2\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u0004\u001a\f\u0010,\u001a\u00020\u0014*\u00020\u0002H\u0002\u001a\n\u0010-\u001a\u00020\"*\u00020\u0002\u001a\n\u0010.\u001a\u00020\u0002*\u00020/\u001a\u001a\u00100\u001a\u00020\"*\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a$\u00101\u001a\u00020\"*\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u0004\u001a\u0014\u00102\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u001a\f\u00103\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\f\u00104\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\u001c\u00105\u001a\u00020\"*\u00020\"2\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u001a\u00105\u001a\u00020\"*\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a&\u00108\u001a\u00020\"*\u00020\"2\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u0004\u001a$\u00108\u001a\u00020\"*\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u0004\u001a\n\u00109\u001a\u00020\u0002*\u00020\u0002\u001a\u0014\u0010:\u001a\u0004\u0018\u00010;*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u0014\u0010<\u001a\u0004\u0018\u000107*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002\"#\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"ASYMMETRIC_ALGOS", "", "", "", "", "getASYMMETRIC_ALGOS", "()Ljava/util/Map;", "HEX_REGEX", "Lkotlin/text/Regex;", "getHEX_REGEX", "()Lkotlin/text/Regex;", "OAEP_PARAM_SPEC_SHA1", "Ljavax/crypto/spec/OAEPParameterSpec;", "getOAEP_PARAM_SPEC_SHA1", "()Ljavax/crypto/spec/OAEPParameterSpec;", "RSA_PADDINGS", "getRSA_PADDINGS", "()Ljava/util/List;", "ecGenParameterSpec", "checkKeyPair", "", "pub", "pri", "alg", "genBase64KeyArray", "", "keySize", "(Ljava/lang/String;I)[Ljava/lang/String;", "params", "", "(Ljava/lang/String;Ljava/util/List;)[Ljava/lang/String;", "genKeyPair", "Ljava/security/KeyPair;", "getPropPublicKey", "", "key", "pkcs1ToPkcs8", "pkcs1", "pkcs8ToPkcs1", "pkcs8", "asymmetricDecrypt", "Ljava/security/Key;", "asymmetricEncrypt", "reserved", "isOAEP", "keyAutoDecode", "parsePublicKeyFromCerFile", "Ljava/io/File;", "privateDecrypt", "privateEncrypt", "privateKeyDerivedPublicKey", "properKeyPairAlg", "properOAEPAlg", "pubDecrypt", "publicKey", "Ljava/security/PublicKey;", "pubEncrypt", "removePemInfo", "toPrivateKey", "Ljava/security/PrivateKey;", "toPublicKey", "app"})
public final class AsymmetircCryptoKt {
    @NotNull
    private static final Map<String, List<Integer>> ASYMMETRIC_ALGOS;
    @NotNull
    private static final List<String> RSA_PADDINGS;
    @NotNull
    private static final OAEPParameterSpec OAEP_PARAM_SPEC_SHA1;
    @NotNull
    private static final Regex HEX_REGEX;
    @NotNull
    private static final Map<String, String> ecGenParameterSpec;

    @NotNull
    public static final Map<String, List<Integer>> getASYMMETRIC_ALGOS() {
        return ASYMMETRIC_ALGOS;
    }

    @NotNull
    public static final List<String> getRSA_PADDINGS() {
        return RSA_PADDINGS;
    }

    @NotNull
    public static final OAEPParameterSpec getOAEP_PARAM_SPEC_SHA1() {
        return OAEP_PARAM_SPEC_SHA1;
    }

    @NotNull
    public static final String removePemInfo(@NotNull String $this$removePemInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$removePemInfo, (String)"<this>");
        CharSequence charSequence = $this$removePemInfo;
        Regex regex = new Regex("---+(?:END|BEGIN) (?:RSA )?\\w+ KEY---+|\n|\r|\r\n");
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final byte[] getPropPublicKey(@NotNull String key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)"-----BEGIN CERTIFICATE-----", (boolean)false, (int)2, null)) {
            String string = key;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            byte[] byArray3 = CertificateFactory.getInstance("X.509", "BC").generateCertificate(byteArrayInputStream).getPublicKey().getEncoded();
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"{\n        val byteArrayI\u2026           .encoded\n    }");
        } else {
            byArray = AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemInfo(key));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String parsePublicKeyFromCerFile(@NotNull File $this$parsePublicKeyFromCerFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$parsePublicKeyFromCerFile, (String)"<this>");
        Closeable closeable = new FileInputStream($this$parsePublicKeyFromCerFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            byte[] byArray = CertificateFactory.getInstance("X.509", "BC").generateCertificate(it).getPublicKey().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"X.509\", \"BC\u2026cKey\n            .encoded");
            string = Base64Kt.base64$default(byArray, null, false, 3, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @Nullable
    public static final PublicKey toPublicKey(@NotNull String $this$toPublicKey, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$toPublicKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(AsymmetircCryptoKt.getPropPublicKey($this$toPublicKey));
            return KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePublic(keySpec);
        }
        catch (Exception ignore) {
            if (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null)) {
                BigInteger bigInteger;
                Map<String, BigInteger> $this$toPublicKey_u24lambda_u2d1 = ParamsParserKt.parseRsaParams($this$toPublicKey);
                boolean bl = false;
                KeyFactory keyFactory = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg));
                BigInteger bigInteger2 = $this$toPublicKey_u24lambda_u2d1.get("n");
                if (bigInteger2 == null) {
                    bigInteger2 = new BigInteger($this$toPublicKey, 16);
                }
                if ((bigInteger = $this$toPublicKey_u24lambda_u2d1.get("e")) == null) {
                    bigInteger = new BigInteger("10001", 16);
                }
                return keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger));
            }
            return null;
        }
    }

    @Nullable
    public static final PrivateKey toPrivateKey(@NotNull String $this$toPrivateKey, @NotNull String alg) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter((Object)$this$toPrivateKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemInfo($this$toPrivateKey)));
            privateKey = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePrivate(keySpec);
        }
        catch (Exception ignore) {
            PrivateKey privateKey2;
            if (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null)) {
                Map<String, BigInteger> $this$toPrivateKey_u24lambda_u2d2 = ParamsParserKt.parseRsaParams($this$toPrivateKey);
                boolean bl = false;
                privateKey2 = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePrivate(new RSAPrivateKeySpec($this$toPrivateKey_u24lambda_u2d2.get("n"), $this$toPrivateKey_u24lambda_u2d2.get("d")));
            } else {
                privateKey2 = null;
            }
            privateKey = privateKey2;
        }
        return privateKey;
    }

    @NotNull
    public static final byte[] pubDecrypt(@NotNull byte[] $this$pubDecrypt, @NotNull String key, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$pubDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        return AsymmetircCryptoKt.pubDecrypt($this$pubDecrypt, AsymmetircCryptoKt.toPublicKey(key, alg), alg);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] pubDecrypt(@NotNull byte[] $this$pubDecrypt, @Nullable PublicKey publicKey, @NotNull String alg) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$pubDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$pubDecrypt_u24lambda_u2d5 = Cipher.getInstance(alg);
        boolean bl = false;
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$pubDecrypt_u24lambda_u2d5.init(2, (Key)publicKey, OAEP_PARAM_SPEC_SHA1);
            byte[] byArray = $this$pubDecrypt_u24lambda_u2d5.doFinal($this$pubDecrypt);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(this@pubDecrypt)");
            return byArray;
        }
        $this$pubDecrypt_u24lambda_u2d5.init(2, publicKey);
        Iterable iterable = ArraysKt.toList((byte[])$this$pubDecrypt);
        PublicKey publicKey2 = publicKey;
        Intrinsics.checkNotNull((Object)publicKey2);
        Iterable iterable2 = CollectionsKt.chunked((Iterable)iterable, (int)(RsaKt.bitLength(publicKey2) / 8), (Function1)((Function1)new Function1<List<? extends Byte>, byte[]>($this$pubDecrypt_u24lambda_u2d5){
            final /* synthetic */ Cipher $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            public final byte[] invoke(@NotNull List<Byte> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
            }
        }));
        ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
        boolean $i$f$fold = false;
        ByteArrayOutputStream accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bytes;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray = (byte[])element$iv;
            ByteArrayOutputStream acc = accumulator$iv;
            boolean bl2 = false;
            ByteArrayOutputStream it = byteArrayOutputStream = acc;
            boolean bl3 = false;
            acc.write((byte[])bytes);
            accumulator$iv = byteArrayOutputStream;
        }
        byte[] byArray = accumulator$iv.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(alg).run {\n \u2026     .toByteArray()\n    }");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] pubEncrypt(@NotNull byte[] $this$pubEncrypt, @Nullable PublicKey publicKey, @NotNull String alg, int reserved) {
        void $this$fold$iv;
        void it;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$pubEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$pubEncrypt_u24lambda_u2d9 = Cipher.getInstance(AsymmetircCryptoKt.properOAEPAlg(alg));
        boolean bl = false;
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$pubEncrypt_u24lambda_u2d9.init(1, (Key)publicKey, OAEP_PARAM_SPEC_SHA1);
            System.out.println((Object)"_______isOAEP");
        } else {
            $this$pubEncrypt_u24lambda_u2d9.init(1, publicKey);
        }
        StringBuilder stringBuilder = new StringBuilder().append("_______ ");
        PublicKey publicKey2 = publicKey;
        Intrinsics.checkNotNull((Object)publicKey2);
        System.out.println((Object)stringBuilder.append(RsaKt.bitLength(publicKey2)).append(' ').append(StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null) ? reserved : 0).toString());
        int n2 = n = RsaKt.bitLength(publicKey) / 8 - (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null) ? reserved : 0);
        Iterable iterable = ArraysKt.toList((byte[])$this$pubEncrypt);
        boolean bl2 = false;
        System.out.println((Object)("chunk size " + (int)it));
        Iterable iterable2 = CollectionsKt.chunked((Iterable)iterable, (int)n, (Function1)((Function1)new Function1<List<? extends Byte>, byte[]>($this$pubEncrypt_u24lambda_u2d9){
            final /* synthetic */ Cipher $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            public final byte[] invoke(@NotNull List<Byte> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                System.out.println((Object)("list size " + it.size()));
                return this.$this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
            }
        }));
        ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
        boolean $i$f$fold = false;
        ByteArrayOutputStream accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bytes;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray = (byte[])element$iv;
            ByteArrayOutputStream acc = accumulator$iv;
            boolean bl3 = false;
            ByteArrayOutputStream it2 = byteArrayOutputStream = acc;
            boolean bl4 = false;
            acc.write((byte[])bytes);
            accumulator$iv = byteArrayOutputStream;
        }
        byte[] byArray = accumulator$iv.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(alg.properOA\u2026     .toByteArray()\n    }");
        return byArray;
    }

    public static /* synthetic */ byte[] pubEncrypt$default(byte[] byArray, PublicKey publicKey, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.pubEncrypt(byArray, publicKey, string, n);
    }

    private static final String properOAEPAlg(String $this$properOAEPAlg) {
        return AsymmetircCryptoKt.isOAEP($this$properOAEPAlg) ? StringsKt.replace$default((String)$this$properOAEPAlg, (String)"OAEP", (String)RSA_PADDINGS.get(4), (boolean)false, (int)4, null) : $this$properOAEPAlg;
    }

    private static final boolean isOAEP(String $this$isOAEP) {
        return StringsKt.endsWith$default((String)$this$isOAEP, (String)"OAEP", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final byte[] pubEncrypt(@NotNull byte[] $this$pubEncrypt, @NotNull String key, @NotNull String alg, int reserved) {
        Intrinsics.checkNotNullParameter((Object)$this$pubEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        return Intrinsics.areEqual((Object)alg, (Object)"SM2") ? SMKt.sm2$default($this$pubEncrypt, true, (CipherParameters)SMKt.toECPublicKeyParams(AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemInfo(key))), null, 4, null) : AsymmetircCryptoKt.pubEncrypt($this$pubEncrypt, AsymmetircCryptoKt.toPublicKey(key, alg), alg, reserved);
    }

    public static /* synthetic */ byte[] pubEncrypt$default(byte[] byArray, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.pubEncrypt(byArray, string, string2, n);
    }

    @NotNull
    public static final Regex getHEX_REGEX() {
        return HEX_REGEX;
    }

    @NotNull
    public static final byte[] keyAutoDecode(@NotNull String $this$keyAutoDecode) {
        Intrinsics.checkNotNullParameter((Object)$this$keyAutoDecode, (String)"<this>");
        return HEX_REGEX.matches((CharSequence)$this$keyAutoDecode) ? ConverterKt.hex2ByteArray($this$keyAutoDecode) : Base64Kt.base64Decode$default($this$keyAutoDecode, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] asymmetricDecrypt(@NotNull byte[] $this$asymmetricDecrypt, @Nullable Key key, @NotNull String alg) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$asymmetricDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$asymmetricDecrypt_u24lambda_u2d12 = Cipher.getInstance(AsymmetircCryptoKt.properOAEPAlg(alg), "BC");
        boolean bl = false;
        System.out.println((Object)("alg " + alg));
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$asymmetricDecrypt_u24lambda_u2d12.init(2, key, OAEP_PARAM_SPEC_SHA1);
            byte[] byArray = $this$asymmetricDecrypt_u24lambda_u2d12.doFinal($this$asymmetricDecrypt);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(this@asymmetricDecrypt)");
            return byArray;
        }
        $this$asymmetricDecrypt_u24lambda_u2d12.init(2, key);
        Object object = key;
        int bitLen = object instanceof PublicKey ? RsaKt.bitLength((PublicKey)key) : (object instanceof PrivateKey ? RsaKt.bitLength((PrivateKey)key) : 1024);
        System.out.println(bitLen);
        object = CollectionsKt.chunked((Iterable)ArraysKt.toList((byte[])$this$asymmetricDecrypt), (int)(bitLen / 8), (Function1)((Function1)new Function1<List<? extends Byte>, byte[]>($this$asymmetricDecrypt_u24lambda_u2d12){
            final /* synthetic */ Cipher $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            public final byte[] invoke(@NotNull List<Byte> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
            }
        }));
        ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
        boolean $i$f$fold = false;
        ByteArrayOutputStream accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bytes;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray = (byte[])element$iv;
            ByteArrayOutputStream acc = accumulator$iv;
            boolean bl2 = false;
            ByteArrayOutputStream it = byteArrayOutputStream = acc;
            boolean bl3 = false;
            acc.write((byte[])bytes);
            accumulator$iv = byteArrayOutputStream;
        }
        byte[] byArray = accumulator$iv.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(alg.properOA\u2026     .toByteArray()\n    }");
        return byArray;
    }

    @NotNull
    public static final byte[] privateDecrypt(@NotNull byte[] $this$privateDecrypt, @NotNull String key, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$privateDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        return Intrinsics.areEqual((Object)alg, (Object)"SM2") ? SMKt.sm2$default($this$privateDecrypt, false, (CipherParameters)SMKt.toECPrivateKeyParams(AsymmetircCryptoKt.keyAutoDecode(key)), null, 4, null) : AsymmetircCryptoKt.asymmetricDecrypt($this$privateDecrypt, AsymmetircCryptoKt.toPrivateKey(key, alg), alg);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] asymmetricEncrypt(@NotNull byte[] $this$asymmetricEncrypt, @Nullable Key key, @NotNull String alg, int reserved) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$asymmetricEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$asymmetricEncrypt_u24lambda_u2d15 = Cipher.getInstance(AsymmetircCryptoKt.properOAEPAlg(alg));
        boolean bl = false;
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$asymmetricEncrypt_u24lambda_u2d15.init(1, key, OAEP_PARAM_SPEC_SHA1);
        } else {
            $this$asymmetricEncrypt_u24lambda_u2d15.init(1, key);
        }
        Object object = key;
        int bitLen = object instanceof PublicKey ? RsaKt.bitLength((PublicKey)key) : (object instanceof PrivateKey ? RsaKt.bitLength((PrivateKey)key) : 1024);
        object = CollectionsKt.chunked((Iterable)ArraysKt.toList((byte[])$this$asymmetricEncrypt), (int)(bitLen / 8 - (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null) ? reserved : 0)), (Function1)((Function1)new Function1<List<? extends Byte>, byte[]>($this$asymmetricEncrypt_u24lambda_u2d15){
            final /* synthetic */ Cipher $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            public final byte[] invoke(@NotNull List<Byte> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
            }
        }));
        ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
        boolean $i$f$fold = false;
        ByteArrayOutputStream accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bytes;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray = (byte[])element$iv;
            ByteArrayOutputStream acc = accumulator$iv;
            boolean bl2 = false;
            ByteArrayOutputStream it = byteArrayOutputStream = acc;
            boolean bl3 = false;
            acc.write((byte[])bytes);
            accumulator$iv = byteArrayOutputStream;
        }
        byte[] byArray = accumulator$iv.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(alg.properOA\u2026     .toByteArray()\n    }");
        return byArray;
    }

    public static /* synthetic */ byte[] asymmetricEncrypt$default(byte[] byArray, Key key, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.asymmetricEncrypt(byArray, key, string, n);
    }

    @NotNull
    public static final byte[] privateEncrypt(@NotNull byte[] $this$privateEncrypt, @NotNull String key, @NotNull String alg, int reserved) {
        Intrinsics.checkNotNullParameter((Object)$this$privateEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        return AsymmetircCryptoKt.asymmetricEncrypt($this$privateEncrypt, AsymmetircCryptoKt.toPrivateKey(key, alg), alg, reserved);
    }

    public static /* synthetic */ byte[] privateEncrypt$default(byte[] byArray, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.privateEncrypt(byArray, string, string2, n);
    }

    @NotNull
    public static final String[] genBase64KeyArray(@NotNull String alg, int keySize) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        KeyPairGenerator $this$genBase64KeyArray_u24lambda_u2d16 = KeyPairGenerator.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg));
        boolean bl = false;
        $this$genBase64KeyArray_u24lambda_u2d16.initialize(keySize);
        KeyPair keyPair = $this$genBase64KeyArray_u24lambda_u2d16.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String[] stringArray = new String[2];
        byte[] byArray = publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
        stringArray[0] = Base64Kt.base64$default(byArray, null, false, 3, null);
        byte[] byArray2 = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"privateKey.encoded");
        stringArray[1] = Base64Kt.base64$default(byArray2, null, false, 3, null);
        return stringArray;
    }

    private static final String properKeyPairAlg(String $this$properKeyPairAlg) {
        return Intrinsics.areEqual((Object)$this$properKeyPairAlg, (Object)"SM2") ? "EC" : (StringsKt.startsWith$default((String)$this$properKeyPairAlg, (String)"RSA", (boolean)false, (int)2, null) ? "RSA" : (StringsKt.contains$default((CharSequence)$this$properKeyPairAlg, (CharSequence)"/", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)$this$properKeyPairAlg, (char)'/', null, (int)2, null) : $this$properKeyPairAlg));
    }

    @NotNull
    public static final String[] genBase64KeyArray(@NotNull String alg, @NotNull List<? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        KeyPair $this$genBase64KeyArray_u24lambda_u2d17 = AsymmetircCryptoKt.genKeyPair(alg, params);
        boolean bl = false;
        String[] stringArray = new String[2];
        byte[] byArray = $this$genBase64KeyArray_u24lambda_u2d17.getPublic().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"public.encoded");
        stringArray[0] = Base64Kt.base64$default(byArray, null, false, 3, null);
        byte[] byArray2 = $this$genBase64KeyArray_u24lambda_u2d17.getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"private.encoded");
        stringArray[1] = Base64Kt.base64$default(byArray2, null, false, 3, null);
        return stringArray;
    }

    public static /* synthetic */ String[] genBase64KeyArray$default(String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return AsymmetircCryptoKt.genBase64KeyArray(string, list);
    }

    @NotNull
    public static final KeyPair genKeyPair(@NotNull String alg, @NotNull List<? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        KeyPairGenerator $this$genKeyPair_u24lambda_u2d18 = KeyPairGenerator.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg), "BC");
        boolean bl = false;
        if (Intrinsics.areEqual((Object)alg, (Object)"SM2")) {
            String string = alg.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            $this$genKeyPair_u24lambda_u2d18.initialize(new ECGenParameterSpec(ecGenParameterSpec.get(string)));
        } else if (StringsKt.startsWith$default((String)alg, (String)"EC", (boolean)false, (int)2, null)) {
            String string = alg.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            $this$genKeyPair_u24lambda_u2d18.initialize(new ECGenParameterSpec(ecGenParameterSpec.get(string)));
        } else if (Intrinsics.areEqual((Object)alg, (Object)"SPHINCSPLUS")) {
            $this$genKeyPair_u24lambda_u2d18.initialize((AlgorithmParameterSpec)SPHINCSPlusParameterSpec.fromName((String)CollectionsKt.first(params).toString()));
        } else if (Intrinsics.areEqual((Object)alg, (Object)"LMS")) {
            Object object = params.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.pqc.crypto.lms.LMSigParameters");
            LMSigParameters lMSigParameters = (LMSigParameters)object;
            Object object2 = params.get(1);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.bouncycastle.pqc.crypto.lms.LMOtsParameters");
            $this$genKeyPair_u24lambda_u2d18.initialize((AlgorithmParameterSpec)new LMSKeyGenParameterSpec(lMSigParameters, (LMOtsParameters)object2));
        } else if (Intrinsics.areEqual((Object)alg, (Object)"GOST3410")) {
            $this$genKeyPair_u24lambda_u2d18.initialize((AlgorithmParameterSpec)new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()));
        } else if (StringsKt.contains$default((CharSequence)alg, (CharSequence)"ECGOST3410", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = alg.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append('-');
            Object object = params.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            $this$genKeyPair_u24lambda_u2d18.initialize(new ECGenParameterSpec(ecGenParameterSpec.get(stringBuilder2.append((Integer)object).toString())), new SecureRandom());
        } else {
            Object[] objectArray = new String[]{"ED448", "ED25519"};
            if (!ArraysKt.contains((Object[])objectArray, (Object)alg)) {
                Object object = params.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                $this$genKeyPair_u24lambda_u2d18.initialize((Integer)object);
            }
        }
        KeyPair keyPair = $this$genKeyPair_u24lambda_u2d18.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"getInstance(alg.properKe\u2026  generateKeyPair()\n    }");
        return keyPair;
    }

    public static /* synthetic */ KeyPair genKeyPair$default(String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return AsymmetircCryptoKt.genKeyPair(string, list);
    }

    public static final boolean checkKeyPair(@NotNull String pub, @NotNull String pri, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)pri, (String)"pri");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        byte[] byArray = new byte[]{67};
        byte[] testData = byArray;
        byte[] $this$checkKeyPair_u24lambda_u2d19 = AsymmetircCryptoKt.asymmetricEncrypt$default(testData, AsymmetircCryptoKt.toPublicKey(pub, alg), alg, 0, 4, null);
        boolean bl = false;
        return Arrays.equals(AsymmetircCryptoKt.asymmetricDecrypt($this$checkKeyPair_u24lambda_u2d19, AsymmetircCryptoKt.toPrivateKey(pri, alg), alg), testData);
    }

    public static /* synthetic */ boolean checkKeyPair$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "RSA";
        }
        return AsymmetircCryptoKt.checkKeyPair(string, string2, string3);
    }

    @NotNull
    public static final String pkcs8ToPkcs1(@NotNull String pkcs8) {
        Intrinsics.checkNotNullParameter((Object)pkcs8, (String)"pkcs8");
        byte[] byArray = PrivateKeyInfo.getInstance((Object)Base64Kt.base64Decode$default(pkcs8, null, 1, null)).parsePrivateKey().toASN1Primitive().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(pkcs8.base64\u2026mitive()\n        .encoded");
        return Base64Kt.base64$default(byArray, null, false, 3, null);
    }

    @NotNull
    public static final String pkcs1ToPkcs8(@NotNull String pkcs1) {
        Intrinsics.checkNotNullParameter((Object)pkcs1, (String)"pkcs1");
        byte[] $this$pkcs1ToPkcs8_u24lambda_u2d21 = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption), (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])Base64Kt.base64Decode$default(pkcs1, null, 1, null))).getEncoded();
        boolean bl = false;
        PKCS8EncodedKeySpec $this$pkcs1ToPkcs8_u24lambda_u2d21_u24lambda_u2d20 = new PKCS8EncodedKeySpec($this$pkcs1ToPkcs8_u24lambda_u2d21);
        boolean bl2 = false;
        byte[] byArray = KeyFactory.getInstance("RSA").generatePrivate($this$pkcs1ToPkcs8_u24lambda_u2d21_u24lambda_u2d20).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"RSA\").generatePrivate(this).encoded");
        return Base64Kt.base64$default(byArray, null, false, 3, null);
    }

    @NotNull
    public static final String privateKeyDerivedPublicKey(@NotNull String $this$privateKeyDerivedPublicKey, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$privateKeyDerivedPublicKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        PKCS8EncodedKeySpec $this$privateKeyDerivedPublicKey_u24lambda_u2d23 = new PKCS8EncodedKeySpec(AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemInfo($this$privateKeyDerivedPublicKey)));
        boolean bl = false;
        PrivateKey privateKey = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePrivate($this$privateKeyDerivedPublicKey_u24lambda_u2d23);
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateCrtKey");
        RSAPrivateCrtKey $this$privateKeyDerivedPublicKey_u24lambda_u2d23_u24lambda_u2d22 = (RSAPrivateCrtKey)privateKey;
        boolean bl2 = false;
        byte[] byArray = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePublic(new RSAPublicKeySpec($this$privateKeyDerivedPublicKey_u24lambda_u2d23_u24lambda_u2d22.getModulus(), $this$privateKeyDerivedPublicKey_u24lambda_u2d23_u24lambda_u2d22.getPublicExponent())).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(alg.properKe\u2026\n                .encoded");
        return Base64Kt.base64$default(byArray, null, false, 3, null);
    }

    public static /* synthetic */ String privateKeyDerivedPublicKey$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "RSA";
        }
        return AsymmetircCryptoKt.privateKeyDerivedPublicKey(string, string2);
    }

    static {
        Object[] objectArray = new Pair[3];
        Object[] objectArray2 = new Integer[]{512, 1024, 2048, 3072, 4096};
        objectArray[0] = TuplesKt.to((Object)"RSA", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new Integer[]{512, 1024, 2048};
        objectArray[1] = TuplesKt.to((Object)"ElGamal", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[2] = TuplesKt.to((Object)"SM2", (Object)CollectionsKt.listOf((Object)256));
        ASYMMETRIC_ALGOS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"PKCS1Padding", "NoPadding", "ISO9796-1Padding", "OAEP", "OAEPWithMD5AndMGF1Padding", "OAEPWithSHA1AndMGF1Padding", "OAEPWithSHA224AndMGF1Padding", "OAEPWithSHA3-224AndMGF1Padding", "OAEPWithSHA256AndMGF1Padding", "OAEPWithSHA3-256AndMGF1Padding", "OAEPWithSHA384AndMGF1Padding", "OAEPWithSHA3-384AndMGF1Padding", "OAEPWithSHA512AndMGF1Padding", "OAEPWithSHA3-512AndMGF1Padding"};
        RSA_PADDINGS = CollectionsKt.listOf((Object[])objectArray);
        OAEP_PARAM_SPEC_SHA1 = new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
        HEX_REGEX = new Regex("^[\\da-fA-F]+$");
        objectArray = new Pair[]{TuplesKt.to((Object)"ECGOST3410-2012", (Object)"Tc26-Gost-3410-12-512-paramSetA"), TuplesKt.to((Object)"ECGOST3410-2012-512", (Object)"Tc26-Gost-3410-12-512-paramSetA"), TuplesKt.to((Object)"ECGOST3410-2012-256", (Object)"Tc26-Gost-3410-12-256-paramSetA"), TuplesKt.to((Object)"SM2", (Object)"sm2p256v1")};
        ecGenParameterSpec = MapsKt.mapOf((Pair[])objectArray);
    }
}

