/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.util.zip.Checksum;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ULong;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0014J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0005H\u0016R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/leon/ext/crypto/CRC64;", "Ljava/util/zip/Checksum;", "b", "", "len", "", "([BI)V", "value", "", "(J)V", "bytes", "getBytes", "()[B", "crcDecimal", "", "crcHex", "getValue", "reset", "", "update", "", "off", "Companion", "app"})
public final class CRC64
implements Checksum {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long value;
    private static final long POLY = -3932672073523589310L;
    @NotNull
    private static final long[] table = new long[256];
    private static final int GF2_DIM = 64;

    @JvmOverloads
    public CRC64(long value) {
        this.value = value;
        for (int n = 0; n < 256; ++n) {
            long crc = 0L;
            crc = n;
            int n2 = 8;
            for (int i = 0; i < n2; ++i) {
                int it = i;
                boolean bl = false;
                crc = (crc & 1L) == 1L ? crc >>> 1 ^ 0xC96C5795D7870F42L : crc >>> 1;
            }
            CRC64.table[n] = crc;
        }
    }

    public /* synthetic */ CRC64(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        this(l);
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(this.value >>> i * 8);
        }
        return b;
    }

    public CRC64(@NotNull byte[] b, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this(0L);
        this.update(b, len);
    }

    public final void update(@NotNull byte[] b, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int idx = 0;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        for (int lenTmp = len; lenTmp > 0; --lenTmp) {
            this.value = table[(int)(this.value ^ (long)b[idx]) & 0xFF] ^ this.value >>> 8;
            ++idx;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    public final void update(byte b) {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        this.value = table[(int)(this.value ^ (long)b) & 0xFF] ^ this.value >>> 8;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void update(int b) {
        this.update((byte)(b & 0xFF));
    }

    @Override
    public void update(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int i = off;
        for (int tmpLen = len; tmpLen > 0; --tmpLen) {
            this.update(b[i++]);
        }
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @NotNull
    public final String crcHex() {
        return UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)this.value), (int)16);
    }

    @NotNull
    public final String crcDecimal() {
        return Long.toUnsignedString(ULong.constructor-impl((long)this.value));
    }

    @JvmOverloads
    public CRC64() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/leon/ext/crypto/CRC64$Companion;", "", "()V", "GF2_DIM", "", "POLY", "", "table", "", "combine", "crc1", "crc2", "len2", "Lme/leon/ext/crypto/CRC64;", "sum1", "sum2", "fromBytes", "b", "", "gf2MatrixSquare", "", "square", "mat", "gf2MatrixTimes", "vec", "makeOddEvenArray", "Lkotlin/Pair;", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CRC64 fromBytes(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            long l = 0L;
            for (int i = 0; i < 4; ++i) {
                l <<= 8;
                l ^= (long)b[i] & 0xFFL;
            }
            return new CRC64(l);
        }

        private final long gf2MatrixTimes(long[] mat, long vec) {
            long vecTmp = vec;
            long sum = 0L;
            int idx = 0;
            while (vecTmp != 0L) {
                if ((vecTmp & 1L) == 1L) {
                    sum ^= mat[idx];
                }
                vecTmp >>>= 1;
                ++idx;
            }
            return sum;
        }

        private final void gf2MatrixSquare(long[] square, long[] mat) {
            for (int n = 0; n < 64; ++n) {
                square[n] = this.gf2MatrixTimes(mat, mat[n]);
            }
        }

        @NotNull
        public final CRC64 combine(@NotNull CRC64 sum1, @NotNull CRC64 sum2, long len2) {
            Intrinsics.checkNotNullParameter((Object)sum1, (String)"sum1");
            Intrinsics.checkNotNullParameter((Object)sum2, (String)"sum2");
            long tmpLen = len2;
            if (tmpLen == 0L) {
                return new CRC64(sum1.getValue());
            }
            Pair<long[], long[]> pair = this.makeOddEvenArray();
            long[] even = (long[])pair.component1();
            long[] odd = (long[])pair.component2();
            long crc1 = sum1.getValue();
            long crc2 = sum2.getValue();
            do {
                this.gf2MatrixSquare(even, odd);
                if ((tmpLen & 1L) == 1L) {
                    crc1 = this.gf2MatrixTimes(even, crc1);
                }
                if ((tmpLen >>>= 1) == 0L) break;
                this.gf2MatrixSquare(odd, even);
                if ((tmpLen & 1L) != 1L) continue;
                crc1 = this.gf2MatrixTimes(odd, crc1);
            } while ((tmpLen >>>= 1) != 0L);
            return new CRC64(crc1 ^= crc2);
        }

        private final Pair<long[], long[]> makeOddEvenArray() {
            long row = 0L;
            long[] even = new long[64];
            long[] odd = new long[64];
            odd[0] = -3932672073523589310L;
            row = 1L;
            for (int n = 1; n < 64; ++n) {
                odd[n] = row;
                row <<= 1;
            }
            this.gf2MatrixSquare(even, odd);
            this.gf2MatrixSquare(odd, even);
            return new Pair((Object)even, (Object)odd);
        }

        public final long combine(long crc1, long crc2, long len2) {
            long lenTmp = len2;
            if (lenTmp == 0L) {
                return crc1;
            }
            long crc1Tmp = crc1;
            Pair<long[], long[]> pair = this.makeOddEvenArray();
            long[] even = (long[])pair.component1();
            long[] odd = (long[])pair.component2();
            do {
                this.gf2MatrixSquare(even, odd);
                if ((lenTmp & 1L) == 1L) {
                    crc1Tmp = this.gf2MatrixTimes(even, crc1Tmp);
                }
                if ((lenTmp >>>= 1) == 0L) break;
                this.gf2MatrixSquare(odd, even);
                if ((lenTmp & 1L) != 1L) continue;
                crc1Tmp = this.gf2MatrixTimes(odd, crc1Tmp);
            } while ((lenTmp >>>= 1) != 0L);
            return crc1Tmp ^= crc2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

