/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import me.leon.classical.ADFGVXKt;
import me.leon.classical.ADFGXKt;
import me.leon.classical.AffineCipherKt;
import me.leon.classical.AlphabetaIndexKt;
import me.leon.classical.AtbashKt;
import me.leon.classical.AutoKeyKt;
import me.leon.classical.BaconCipherKt;
import me.leon.classical.BeaufortKt;
import me.leon.classical.BifidKt;
import me.leon.classical.FourSquareKt;
import me.leon.classical.GrayCodeKt;
import me.leon.classical.GronsfeldKt;
import me.leon.classical.HillsKt;
import me.leon.classical.MorseKt;
import me.leon.classical.NihilistCipherKt;
import me.leon.classical.OneTimePadCipherKt;
import me.leon.classical.PlayFairKt;
import me.leon.classical.PolybiusSquareCipherKt;
import me.leon.classical.PortaKt;
import me.leon.classical.RailFenceKt;
import me.leon.classical.RailFenceWKt;
import me.leon.classical.RotKt;
import me.leon.classical.TableSubsKt;
import me.leon.classical.TapCodeCipherKt;
import me.leon.classical.TrifidKt;
import me.leon.classical.VirgeneneKt;
import me.leon.classical.Zero1248Kt;
import me.leon.ctf.AsciiSumKt;
import me.leon.ctf.BauDotKt;
import me.leon.ctf.BrailleKt;
import me.leon.ctf.BrainFuckKt;
import me.leon.ctf.BubbleBabbleKt;
import me.leon.ctf.BuddhaCipherKt;
import me.leon.ctf.CaesarBoxCipherKt;
import me.leon.ctf.CetaceanCipherKt;
import me.leon.ctf.CurveCipherKt;
import me.leon.ctf.DNAKt;
import me.leon.ctf.ElementPeriodicTableKt;
import me.leon.ctf.EmojiSubstitutionKt;
import me.leon.ctf.OokKt;
import me.leon.ctf.PawnShopKt;
import me.leon.ctf.PcMoeOnlineCipher;
import me.leon.ctf.QWEKt;
import me.leon.ctf.Rot8000Kt;
import me.leon.ctf.SocialistCoreValuesKt;
import me.leon.ctf.TrollScriptKt;
import me.leon.ctf.YygqCipherKt;
import me.leon.ctf.ZeroWidthCharKt;
import me.leon.ctf.rsa.RsaSolver;
import me.leon.ext.ExtsKt;
import me.leon.ext.ParamsParserKt;
import me.leon.ext.crypto.IClassical;
import me.leon.ext.crypto.JavascriptCipher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b?\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bB\u00a8\u0006C"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType;", "", "Lme/leon/ext/crypto/IClassical;", "type", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "CAESAR", "ROT5", "ROT13", "ROT18", "ROT47", "AFFINE", "RAILFENCE", "RAILFENCEW", "VIRGENENE", "ATBASH", "MORSE", "QWE", "POLYBIUS", "NIHILIST", "ADFGX", "ADFGVX", "PLAYFAIR", "AUTOKEY", "BACON24", "BACON26", "OTP", "SOCIALISM", "BRAINFUCK", "Ook", "TROLLSCRIPT", "Braille", "BauDot", "AlphabetIndex", "Zero1248", "BubbleBabble", "ZWC", "PeriodicTable", "PawnShop", "AsciiSum", "CurveCipher", "EmojiSubstitute", "HandyCode", "Porta", "Beaufort", "FourSquare", "Gronsfeld", "Trifid", "Bifid", "GrayCode", "BuddhaSay", "BuddhaSay2", "Roar", "Bear", "HILL", "Rabbit", "AAEncode", "JJEncode", "RSA_CRACK", "DNA", "TAP_CODE", "CAESAR_BOX", "ROT8000", "CETACEAN", "YYGQ", "app"})
public abstract class ClassicalCryptoType
extends Enum<ClassicalCryptoType>
implements IClassical {
    @NotNull
    private final String type;
    public static final /* enum */ ClassicalCryptoType CAESAR = new CAESAR("CAESAR", 0);
    public static final /* enum */ ClassicalCryptoType ROT5 = new ROT5("ROT5", 1);
    public static final /* enum */ ClassicalCryptoType ROT13 = new ROT13("ROT13", 2);
    public static final /* enum */ ClassicalCryptoType ROT18 = new ROT18("ROT18", 3);
    public static final /* enum */ ClassicalCryptoType ROT47 = new ROT47("ROT47", 4);
    public static final /* enum */ ClassicalCryptoType AFFINE = new AFFINE("AFFINE", 5);
    public static final /* enum */ ClassicalCryptoType RAILFENCE = new RAILFENCE("RAILFENCE", 6);
    public static final /* enum */ ClassicalCryptoType RAILFENCEW = new RAILFENCEW("RAILFENCEW", 7);
    public static final /* enum */ ClassicalCryptoType VIRGENENE = new VIRGENENE("VIRGENENE", 8);
    public static final /* enum */ ClassicalCryptoType ATBASH = new ATBASH("ATBASH", 9);
    public static final /* enum */ ClassicalCryptoType MORSE = new MORSE("MORSE", 10);
    public static final /* enum */ ClassicalCryptoType QWE = new QWE("QWE", 11);
    public static final /* enum */ ClassicalCryptoType POLYBIUS = new POLYBIUS("POLYBIUS", 12);
    public static final /* enum */ ClassicalCryptoType NIHILIST = new NIHILIST("NIHILIST", 13);
    public static final /* enum */ ClassicalCryptoType ADFGX = new ADFGX("ADFGX", 14);
    public static final /* enum */ ClassicalCryptoType ADFGVX = new ADFGVX("ADFGVX", 15);
    public static final /* enum */ ClassicalCryptoType PLAYFAIR = new PLAYFAIR("PLAYFAIR", 16);
    public static final /* enum */ ClassicalCryptoType AUTOKEY = new AUTOKEY("AUTOKEY", 17);
    public static final /* enum */ ClassicalCryptoType BACON24 = new BACON24("BACON24", 18);
    public static final /* enum */ ClassicalCryptoType BACON26 = new BACON26("BACON26", 19);
    public static final /* enum */ ClassicalCryptoType OTP = new OTP("OTP", 20);
    public static final /* enum */ ClassicalCryptoType SOCIALISM = new SOCIALISM("SOCIALISM", 21);
    public static final /* enum */ ClassicalCryptoType BRAINFUCK = new BRAINFUCK("BRAINFUCK", 22);
    public static final /* enum */ ClassicalCryptoType Ook = new Ook("Ook", 23);
    public static final /* enum */ ClassicalCryptoType TROLLSCRIPT = new TROLLSCRIPT("TROLLSCRIPT", 24);
    public static final /* enum */ ClassicalCryptoType Braille = new Braille("Braille", 25);
    public static final /* enum */ ClassicalCryptoType BauDot = new BauDot("BauDot", 26);
    public static final /* enum */ ClassicalCryptoType AlphabetIndex = new AlphabetIndex("AlphabetIndex", 27);
    public static final /* enum */ ClassicalCryptoType Zero1248 = new Zero1248("Zero1248", 28);
    public static final /* enum */ ClassicalCryptoType BubbleBabble = new BubbleBabble("BubbleBabble", 29);
    public static final /* enum */ ClassicalCryptoType ZWC = new ZWC("ZWC", 30);
    public static final /* enum */ ClassicalCryptoType PeriodicTable = new PeriodicTable("PeriodicTable", 31);
    public static final /* enum */ ClassicalCryptoType PawnShop = new PawnShop("PawnShop", 32);
    public static final /* enum */ ClassicalCryptoType AsciiSum = new AsciiSum("AsciiSum", 33);
    public static final /* enum */ ClassicalCryptoType CurveCipher = new CurveCipher("CurveCipher", 34);
    public static final /* enum */ ClassicalCryptoType EmojiSubstitute = new EmojiSubstitute("EmojiSubstitute", 35);
    public static final /* enum */ ClassicalCryptoType HandyCode = new HandyCode("HandyCode", 36);
    public static final /* enum */ ClassicalCryptoType Porta = new Porta("Porta", 37);
    public static final /* enum */ ClassicalCryptoType Beaufort = new Beaufort("Beaufort", 38);
    public static final /* enum */ ClassicalCryptoType FourSquare = new FourSquare("FourSquare", 39);
    public static final /* enum */ ClassicalCryptoType Gronsfeld = new Gronsfeld("Gronsfeld", 40);
    public static final /* enum */ ClassicalCryptoType Trifid = new Trifid("Trifid", 41);
    public static final /* enum */ ClassicalCryptoType Bifid = new Bifid("Bifid", 42);
    public static final /* enum */ ClassicalCryptoType GrayCode = new GrayCode("GrayCode", 43);
    public static final /* enum */ ClassicalCryptoType BuddhaSay = new BuddhaSay("BuddhaSay", 44);
    public static final /* enum */ ClassicalCryptoType BuddhaSay2 = new BuddhaSay2("BuddhaSay2", 45);
    public static final /* enum */ ClassicalCryptoType Roar = new Roar("Roar", 46);
    public static final /* enum */ ClassicalCryptoType Bear = new Bear("Bear", 47);
    public static final /* enum */ ClassicalCryptoType HILL = new HILL("HILL", 48);
    public static final /* enum */ ClassicalCryptoType Rabbit = new Rabbit("Rabbit", 49);
    public static final /* enum */ ClassicalCryptoType AAEncode = new AAEncode("AAEncode", 50);
    public static final /* enum */ ClassicalCryptoType JJEncode = new JJEncode("JJEncode", 51);
    public static final /* enum */ ClassicalCryptoType RSA_CRACK = new RSA_CRACK("RSA_CRACK", 52);
    public static final /* enum */ ClassicalCryptoType DNA = new DNA("DNA", 53);
    public static final /* enum */ ClassicalCryptoType TAP_CODE = new TAP_CODE("TAP_CODE", 54);
    public static final /* enum */ ClassicalCryptoType CAESAR_BOX = new CAESAR_BOX("CAESAR_BOX", 55);
    public static final /* enum */ ClassicalCryptoType ROT8000 = new ROT8000("ROT8000", 56);
    public static final /* enum */ ClassicalCryptoType CETACEAN = new CETACEAN("CETACEAN", 57);
    public static final /* enum */ ClassicalCryptoType YYGQ = new YYGQ("YYGQ", 58);
    private static final /* synthetic */ ClassicalCryptoType[] $VALUES;

    private ClassicalCryptoType(String type2) {
        this.type = type2;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String crack(@NotNull String raw, @NotNull String keyword) {
        return IClassical.DefaultImpls.crack(this, raw, keyword);
    }

    @Override
    public int paramsCount() {
        return IClassical.DefaultImpls.paramsCount(this);
    }

    @Override
    @NotNull
    public List<String> paramsHints() {
        return IClassical.DefaultImpls.paramsHints(this);
    }

    @Override
    public boolean isIgnoreSpace() {
        return IClassical.DefaultImpls.isIgnoreSpace(this);
    }

    @Override
    public boolean hasCrack() {
        return IClassical.DefaultImpls.hasCrack(this);
    }

    public static ClassicalCryptoType[] values() {
        return (ClassicalCryptoType[])$VALUES.clone();
    }

    public static ClassicalCryptoType valueOf(String value) {
        return Enum.valueOf(ClassicalCryptoType.class, value);
    }

    public /* synthetic */ ClassicalCryptoType(String $enum$name, int $enum$ordinal, String type2, DefaultConstructorMarker $constructor_marker) {
        this(type2);
    }

    static {
        $VALUES = classicalCryptoTypeArray = new ClassicalCryptoType[]{ClassicalCryptoType.CAESAR, ClassicalCryptoType.ROT5, ClassicalCryptoType.ROT13, ClassicalCryptoType.ROT18, ClassicalCryptoType.ROT47, ClassicalCryptoType.AFFINE, ClassicalCryptoType.RAILFENCE, ClassicalCryptoType.RAILFENCEW, ClassicalCryptoType.VIRGENENE, ClassicalCryptoType.ATBASH, ClassicalCryptoType.MORSE, ClassicalCryptoType.QWE, ClassicalCryptoType.POLYBIUS, ClassicalCryptoType.NIHILIST, ClassicalCryptoType.ADFGX, ClassicalCryptoType.ADFGVX, ClassicalCryptoType.PLAYFAIR, ClassicalCryptoType.AUTOKEY, ClassicalCryptoType.BACON24, ClassicalCryptoType.BACON26, ClassicalCryptoType.OTP, ClassicalCryptoType.SOCIALISM, ClassicalCryptoType.BRAINFUCK, ClassicalCryptoType.Ook, ClassicalCryptoType.TROLLSCRIPT, ClassicalCryptoType.Braille, ClassicalCryptoType.BauDot, ClassicalCryptoType.AlphabetIndex, ClassicalCryptoType.Zero1248, ClassicalCryptoType.BubbleBabble, ClassicalCryptoType.ZWC, ClassicalCryptoType.PeriodicTable, ClassicalCryptoType.PawnShop, ClassicalCryptoType.AsciiSum, ClassicalCryptoType.CurveCipher, ClassicalCryptoType.EmojiSubstitute, ClassicalCryptoType.HandyCode, ClassicalCryptoType.Porta, ClassicalCryptoType.Beaufort, ClassicalCryptoType.FourSquare, ClassicalCryptoType.Gronsfeld, ClassicalCryptoType.Trifid, ClassicalCryptoType.Bifid, ClassicalCryptoType.GrayCode, ClassicalCryptoType.BuddhaSay, ClassicalCryptoType.BuddhaSay2, ClassicalCryptoType.Roar, ClassicalCryptoType.Bear, ClassicalCryptoType.HILL, ClassicalCryptoType.Rabbit, ClassicalCryptoType.AAEncode, ClassicalCryptoType.JJEncode, ClassicalCryptoType.RSA_CRACK, ClassicalCryptoType.DNA, ClassicalCryptoType.TAP_CODE, ClassicalCryptoType.CAESAR_BOX, ClassicalCryptoType.ROT8000, ClassicalCryptoType.CETACEAN, ClassicalCryptoType.YYGQ};
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$CAESAR;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "crack", "", "raw", "keyword", "decrypt", "params", "", "encrypt", "hasCrack", "", "isIgnoreSpace", "paramsCount", "", "paramsHints", "", "app"})
    static final class CAESAR
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CAESAR() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = raw;
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            int n = Integer.parseInt(string2);
            String string3 = params.get("p2");
            Intrinsics.checkNotNull((Object)string3);
            CharSequence charSequence2 = string3;
            if (charSequence2.length() == 0) {
                int n2 = n;
                String string4 = string;
                boolean bl = false;
                String string5 = params.get("p1");
                string = string4;
                n = n2;
                charSequence = string5;
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNull((Object)charSequence);
            return RotKt.shift26(string, n, Integer.parseInt((String)charSequence));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = raw;
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            int n = 26 - Integer.parseInt(string2);
            int n2 = 26;
            String string3 = params.get("p2");
            Intrinsics.checkNotNull((Object)string3);
            CharSequence charSequence2 = string3;
            if (charSequence2.length() == 0) {
                int n3 = n2;
                int n4 = n;
                String string4 = string;
                boolean bl = false;
                String string5 = params.get("p1");
                string = string4;
                n = n4;
                n2 = n3;
                charSequence = string5;
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNull((Object)charSequence);
            return RotKt.shift26(string, n, n2 - Integer.parseInt((String)charSequence));
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"shift", "shift lower(default is same to shift)"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            for (int i = 1; i < 26; ++i) {
                for (int j = 1; j < 26; ++j) {
                    String decrypted = RotKt.shift26(raw, 26 - i, 26 - j);
                    if (!ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) continue;
                    return "shift: " + i + " shift(lower): " + j + System.lineSeparator() + '\t' + decrypted;
                }
            }
            return "";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ROT5;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class ROT5
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT5() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift10(raw, 5);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift10(raw, 5);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ROT13;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class ROT13
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT13() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift26$default(raw, 13, 0, 2, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift26$default(raw, 13, 0, 2, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ROT18;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class ROT18
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT18() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.rot18(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.rot18(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ROT47;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class ROT47
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT47() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift94(raw, 47);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift94(raw, 47);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$AFFINE;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "crack", "", "raw", "keyword", "decrypt", "params", "", "encrypt", "hasCrack", "", "isIgnoreSpace", "paramsCount", "", "paramsHints", "", "app"})
    static final class AFFINE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AFFINE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return AffineCipherKt.affineEncrypt$default(raw, n, Integer.parseInt(string2), null, 4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return AffineCipherKt.affineDecrypt$default(raw, n, Integer.parseInt(string2), null, 4, null);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"factor a", "b"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            for (int a = 1; a < 27; ++a) {
                for (int b = 1; b < 27; ++b) {
                    Object object;
                    AFFINE aFFINE = this;
                    try {
                        AFFINE $this$crack_u24lambda_u2d0 = aFFINE;
                        boolean bl = false;
                        String decrypted = AffineCipherKt.affineDecrypt$default(raw, a, b, null, 4, null);
                        if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                            return a + "*x+" + b + ": " + System.lineSeparator() + '\t' + decrypted;
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }
            }
            return "";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$RAILFENCE;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "crack", "", "raw", "keyword", "decrypt", "params", "", "encrypt", "hasCrack", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class RAILFENCE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        RAILFENCE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return RailFenceKt.railFenceEncrypt(raw, Integer.parseInt(string));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return RailFenceKt.railFenceDecrypt(raw, Integer.parseInt(string));
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            for (int i = 2; i < 27; ++i) {
                Object object;
                RAILFENCE rAILFENCE = this;
                try {
                    RAILFENCE $this$crack_u24lambda_u2d0 = rAILFENCE;
                    boolean bl = false;
                    String decrypted = RailFenceKt.railFenceDecrypt(raw, i);
                    if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                        return "railFence " + i + ": " + System.lineSeparator() + '\t' + decrypted;
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                    continue;
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            return "";
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"fence number", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$RAILFENCEW;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "crack", "", "raw", "keyword", "decrypt", "params", "", "encrypt", "hasCrack", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class RAILFENCEW
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        RAILFENCEW() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return RailFenceWKt.railFenceWEncrypt(raw, Integer.parseInt(string), (object = params.get("p2")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return RailFenceWKt.railFenceWDecrypt(raw, Integer.parseInt(string), (object = params.get("p2")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"fence number", "offset,default is 0"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            for (int i = 2; i < 27; ++i) {
                Object object;
                RAILFENCEW rAILFENCEW = this;
                try {
                    RAILFENCEW $this$crack_u24lambda_u2d0 = rAILFENCEW;
                    boolean bl = false;
                    String decrypted = RailFenceWKt.railFenceWDecrypt$default(raw, i, 0, 2, null);
                    if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                        return "railFenceW " + i + ": " + System.lineSeparator() + '\t' + decrypted;
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                    continue;
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            return "";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$VIRGENENE;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class VIRGENENE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        VIRGENENE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return VirgeneneKt.virgeneneEncode(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return VirgeneneKt.virgeneneDecode$default(raw, string, 0, 2, null);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ATBASH;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class ATBASH
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ATBASH() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AtbashKt.atBash(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AtbashKt.atBash(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$MORSE;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class MORSE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        MORSE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = ".";
            String string4 = MorseKt.morseEncrypt(raw);
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string5 = !bl2 ? string : null;
            if (string5 == null) {
                string5 = ".";
            }
            String string6 = StringsKt.replace$default((String)string4, (String)string3, (String)string5, (boolean)false, (int)4, null);
            it = string = params.get("p2");
            string3 = "-";
            string4 = string6;
            boolean bl3 = false;
            charSequence = it;
            bl2 = charSequence == null || charSequence.length() == 0;
            String string7 = !bl2 ? string : null;
            if (string7 == null) {
                string7 = "-";
            }
            return StringsKt.replace$default((String)string4, (String)string3, (String)string7, (boolean)false, (int)4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = ".";
            }
            it = string = params.get("p2");
            string3 = StringsKt.replace$default((String)string3, (String)string4, (String)".", (boolean)false, (int)4, null);
            boolean bl3 = false;
            charSequence = it;
            bl2 = charSequence == null || charSequence.length() == 0;
            String string5 = !bl2 ? string : null;
            if (string5 == null) {
                string5 = "-";
            }
            return MorseKt.morseDecrypt(StringsKt.replace$default((String)string3, (String)string5, (String)"-", (boolean)false, (int)4, null));
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"default .", "default -"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$QWE;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class QWE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        QWE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return QWEKt.qweEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return QWEKt.qweDecrypt(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$POLYBIUS;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class POLYBIUS
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        POLYBIUS() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return PolybiusSquareCipherKt.polybius$default(string3, string5, string6, null, 4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return PolybiusSquareCipherKt.polybiusDecrypt(string3, string5, string6);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"table, ABCDEFGHIKLMNOPQRSTUVWXYZ as default", "encode map, 12345 as default"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$NIHILIST;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class NIHILIST
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        NIHILIST() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return NihilistCipherKt.nihilist$default(string3, string5, string6, null, 4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return NihilistCipherKt.nihilistDecrypt(string3, string5, string6);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"keyword", "encodeMap 12345 is as default"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ADFGX;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class ADFGX
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ADFGX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return ADFGXKt.adfgx$default(string3, string5, string6, null, null, 12, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return ADFGXKt.adfgxDecrypt$default(string3, string5, string6, null, 4, null);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"table ABCDEFGHIKLMNOPQRSTUVWXYZ", "keyword"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ADFGVX;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class ADFGVX
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ADFGVX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return ADFGVXKt.adfgvx(string3, string5, string6);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return ADFGVXKt.adfgvxDecrypt(string3, string5, string6);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"table ABCDEFGHIKLMNOPQRSTUVWXYZ", "keyword"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$PLAYFAIR;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class PLAYFAIR
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        PLAYFAIR() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return PlayFairKt.playFair(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return PlayFairKt.playFairDecrypt(string3, string4);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$AUTOKEY;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class AUTOKEY
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AUTOKEY() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return AutoKeyKt.autoKey(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return AutoKeyKt.autoKeyDecrypt(string3, string4);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BACON24;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class BACON24
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BACON24() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BaconCipherKt.baconEncrypt24(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BaconCipherKt.baconDecrypt24(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BACON26;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class BACON26
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BACON26() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BaconCipherKt.baconEncrypt26(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BaconCipherKt.baconDecrypt26(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$OTP;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class OTP
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        OTP() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return OneTimePadCipherKt.oneTimePad(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return OneTimePadCipherKt.oneTimePadDecrypt(raw, string);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key data as long as data size", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$SOCIALISM;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class SOCIALISM
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        SOCIALISM() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return SocialistCoreValuesKt.socialistCoreValues(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return SocialistCoreValuesKt.socialistCoreValuesDecrypt(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BRAINFUCK;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class BRAINFUCK
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BRAINFUCK() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BrainFuckKt.brainFuckEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BrainFuckKt.brainFuckDecrypt(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Ook;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class Ook
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Ook() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return OokKt.ookEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return OokKt.ookDecrypt(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$TROLLSCRIPT;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class TROLLSCRIPT
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        TROLLSCRIPT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TrollScriptKt.trollScriptEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TrollScriptKt.trollScriptDecrypt(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Braille;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class Braille
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Braille() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String it = string = BrailleKt.blindEncode(raw);
            boolean bl = false;
            System.out.println((Object)("Braille " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BrailleKt.blindDecode(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BauDot;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class BauDot
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BauDot() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String it = string = BauDotKt.baudot(raw);
            boolean bl = false;
            System.out.println((Object)("baudot " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BauDotKt.baudotDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$AlphabetIndex;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class AlphabetIndex
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AlphabetIndex() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            String string2;
            String string3;
            String string4;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string5 = raw;
            String string6 = params.get("p1");
            if (string6 != null) {
                CharSequence charSequence2;
                charSequence = string6;
                if (charSequence.length() == 0) {
                    string4 = string5;
                    boolean bl = false;
                    charSequence2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                    string5 = string4;
                } else {
                    charSequence2 = charSequence;
                }
                string3 = (String)charSequence2;
            } else {
                string3 = " ";
            }
            String string7 = params.get("p2");
            if (string7 != null) {
                CharSequence charSequence3;
                charSequence = string7;
                if (charSequence.length() == 0) {
                    String string8 = string3;
                    string4 = string5;
                    boolean bl = false;
                    String string9 = " ";
                    string5 = string4;
                    string3 = string8;
                    charSequence3 = string9;
                } else {
                    charSequence3 = charSequence;
                }
                string2 = (String)charSequence3;
            } else {
                string2 = " ";
            }
            String it = string = AlphabetaIndexKt.alphabetIndex$default(string5, string3, string2, false, 4, null);
            boolean bl = false;
            System.out.println((Object)("alphabetIndex " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AlphabetaIndexKt.alphabetIndexDecode$default(raw, null, false, 3, null);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"table, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' as default", "delimiter(space as default)"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Zero1248;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class Zero1248
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Zero1248() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String it = string = Zero1248Kt.zero1248(raw);
            boolean bl = false;
            System.out.println((Object)("01248 " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Zero1248Kt.zero1248Decode(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BubbleBabble;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class BubbleBabble
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BubbleBabble() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BubbleBabbleKt.bubbleBabble(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BubbleBabbleKt.bubbleBabbleDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ZWC;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class ZWC
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ZWC() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = raw;
            String string3 = params.get("p1");
            if (string3 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string3;
                if (charSequence2.length() == 0) {
                    String string4 = string2;
                    boolean bl = false;
                    charSequence = "hide";
                    string2 = string4;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = "hide";
            }
            return ZeroWidthCharKt.zwc(string2, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return ZeroWidthCharKt.zwcDecode(raw);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"show plain text", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$PeriodicTable;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class PeriodicTable
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        PeriodicTable() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return ElementPeriodicTableKt.elementPeriodEncode(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return ElementPeriodicTableKt.elementPeriodDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$PawnShop;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class PawnShop
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        PawnShop() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PawnShopKt.pawnshop(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PawnShopKt.pawnshopDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$AsciiSum;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class AsciiSum
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AsciiSum() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AsciiSumKt.asciiSum(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AsciiSumKt.asciiSumDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$CurveCipher;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class CurveCipher
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CurveCipher() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return CurveCipherKt.curveCipher(raw, n, Integer.parseInt(string2));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return CurveCipherKt.curveCipherDecode(raw, n, Integer.parseInt(string2));
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"row", "column"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$EmojiSubstitute;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class EmojiSubstitute
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        EmojiSubstitute() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            return EmojiSubstitutionKt.emojiReplace(string3, string4 != null ? Integer.parseInt(string4) : 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            return EmojiSubstitutionKt.emojiReplaceDecode(string3, string4 != null ? Integer.parseInt(string4) : 0);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"shift, default 0", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$HandyCode;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class HandyCode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        HandyCode() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "2 22 222 3 33 333 4 44 444 5 55 555 6 66 666 7 77 777 7777 8 88 888 9 99 999 9999";
            }
            return TableSubsKt.tableEncode$default(string3, string4, null, '\u0000', 6, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "2 22 222 3 33 333 4 44 444 5 55 555 6 66 666 7 77 777 7777 8 88 888 9 99 999 9999";
            }
            return TableSubsKt.tableDecode$default(string3, string4, null, '\u0000', 6, null);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"default table '2 22 222 3 33 333 4 44 444 5 55 555 6 66 666 7 77 777 7777 8 88 888 9 99 999 9999'", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Porta;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class Porta
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Porta() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "porta";
            }
            return PortaKt.porta(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "porta";
            }
            return PortaKt.porta(string3, string4);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key,PORTA as default", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Beaufort;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class Beaufort
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Beaufort() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "beaufort";
            }
            return BeaufortKt.beaufort(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "beaufort";
            }
            return BeaufortKt.beaufort(string3, string4);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key,beaufort as default", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$FourSquare;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class FourSquare
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        FourSquare() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return FourSquareKt.fourSquare(string3, string5, string6);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return FourSquareKt.fourSquareDecrypt(string3, string5, string6);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key1, length 25 ", "key2, length 25"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Gronsfeld;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class Gronsfeld
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Gronsfeld() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "123456";
            }
            return GronsfeldKt.gronsfeld(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "123456";
            }
            return GronsfeldKt.gronsfeldDecrypt(string3, string4);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key, a sequence of numbers 0-9,default 123456 ", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Trifid;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class Trifid
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Trifid() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string = params.get("p2");
            String string4 = string2;
            String string5 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl2 ? string : null;
            return TrifidKt.trifid(string5, string4, string6 != null ? Integer.parseInt(string6) : 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string = params.get("p2");
            String string4 = string2;
            String string5 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl2 ? string : null;
            return TrifidKt.trifidDecrypt(string5, string4, string6 != null ? Integer.parseInt(string6) : 5);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key,length 27 ", "period, default 5"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Bifid;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class Bifid
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Bifid() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            CharSequence charSequence;
            String string2;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            Intrinsics.checkNotNull((Object)string4);
            CharSequence charSequence2 = string4;
            if (charSequence2.length() == 0) {
                string2 = string3;
                boolean bl = false;
                charSequence = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                string3 = string2;
            } else {
                charSequence = charSequence2;
            }
            String string5 = string = params.get("p2");
            String string6 = (String)charSequence;
            string2 = string3;
            boolean bl = false;
            CharSequence charSequence3 = (CharSequence)it;
            boolean bl2 = charSequence3 == null || charSequence3.length() == 0;
            String string7 = !bl2 ? string : null;
            return BifidKt.bifid(string2, string6, string7 != null ? Integer.parseInt(string7) : 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            CharSequence charSequence;
            String string2;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            Intrinsics.checkNotNull((Object)string4);
            CharSequence charSequence2 = string4;
            if (charSequence2.length() == 0) {
                string2 = string3;
                boolean bl = false;
                charSequence = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                string3 = string2;
            } else {
                charSequence = charSequence2;
            }
            String string5 = string = params.get("p2");
            String string6 = (String)charSequence;
            string2 = string3;
            boolean bl = false;
            CharSequence charSequence3 = (CharSequence)it;
            boolean bl2 = charSequence3 == null || charSequence3.length() == 0;
            String string7 = !bl2 ? string : null;
            return BifidKt.bifidDecrypt(string2, string6, string7 != null ? Integer.parseInt(string7) : 5);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{" key,length 25,default A-Z(w/o J) ", "period, default 5"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$GrayCode;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class GrayCode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        GrayCode() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            int n;
            String string2;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            if (string4 != null) {
                CharSequence charSequence2;
                charSequence = string4;
                if (charSequence.length() == 0) {
                    string2 = string3;
                    boolean bl = false;
                    charSequence2 = "0";
                    string3 = string2;
                } else {
                    charSequence2 = charSequence;
                }
                n = Integer.parseInt((String)charSequence2);
            } else {
                n = 0;
            }
            String string5 = params.get("p2");
            if (string5 != null) {
                CharSequence charSequence3;
                charSequence = string5;
                if (charSequence.length() == 0) {
                    int n2 = n;
                    string2 = string3;
                    boolean bl = false;
                    String string6 = " ";
                    string3 = string2;
                    n = n2;
                    charSequence3 = string6;
                } else {
                    charSequence3 = charSequence;
                }
                string = (String)charSequence3;
            } else {
                string = " ";
            }
            return GrayCodeKt.grayEncode(string3, n, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            int n;
            String string2;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            if (string4 != null) {
                CharSequence charSequence2;
                charSequence = string4;
                if (charSequence.length() == 0) {
                    string2 = string3;
                    boolean bl = false;
                    charSequence2 = "0";
                    string3 = string2;
                } else {
                    charSequence2 = charSequence;
                }
                n = Integer.parseInt((String)charSequence2);
            } else {
                n = 0;
            }
            String string5 = params.get("p2");
            if (string5 != null) {
                CharSequence charSequence3;
                charSequence = string5;
                if (charSequence.length() == 0) {
                    int n2 = n;
                    string2 = string3;
                    boolean bl = false;
                    String string6 = " ";
                    string3 = string2;
                    n = n2;
                    charSequence3 = string6;
                } else {
                    charSequence3 = charSequence;
                }
                string = (String)charSequence3;
            } else {
                string = " ";
            }
            return GrayCodeKt.grayDecode(string3, n, string);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"length, default is binary string length", "delimiter(space as default)"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BuddhaSay;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class BuddhaSay
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BuddhaSay() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BuddhaCipherKt.buddhaSays(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BuddhaCipherKt.buddhaExplain(raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$BuddhaSay2;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class BuddhaSay2
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BuddhaSay2() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PcMoeOnlineCipher.INSTANCE.encrypt("Buddha", raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PcMoeOnlineCipher.INSTANCE.decrypt("Buddha", raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Roar;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class Roar
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Roar() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PcMoeOnlineCipher.INSTANCE.encrypt("Roar", raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PcMoeOnlineCipher.INSTANCE.decrypt("Roar", raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Bear;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "app"})
    static final class Bear
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Bear() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PcMoeOnlineCipher.INSTANCE.encrypt("Bear", raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PcMoeOnlineCipher.INSTANCE.decrypt("Bear", raw);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$HILL;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "crack", "", "raw", "keyword", "decrypt", "params", "", "encrypt", "hasCrack", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class HILL
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        HILL() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            String string2 = params.get("p2");
            return HillsKt.hillEncrypt$default(raw, string, null, string2 != null ? ((CharSequence)string2).length() == 0 : true, 2, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            String string2 = params.get("p2");
            return HillsKt.hillDecrypt$default(raw, string, null, string2 != null ? ((CharSequence)string2).length() == 0 : true, 2, null);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            IntRange range = new IntRange(0, 25);
            List results = new ArrayList();
            int k1 = range.getFirst();
            int n = range.getLast();
            if (k1 <= n) {
                while (true) {
                    int n2;
                    int k2;
                    if ((k2 = range.getFirst()) <= (n2 = range.getLast())) {
                        while (true) {
                            int n3;
                            int k3;
                            if ((k3 = range.getFirst()) <= (n3 = range.getLast())) {
                                while (true) {
                                    int n4;
                                    int k4;
                                    if ((k4 = range.getFirst()) <= (n4 = range.getLast())) {
                                        while (true) {
                                            Object object;
                                            HILL hILL = this;
                                            try {
                                                HILL $this$crack_u24lambda_u2d0 = hILL;
                                                boolean bl = false;
                                                String decrypted = HillsKt.hillDecrypt$default(raw, "" + k1 + ' ' + k2 + ' ' + k3 + ' ' + k4, null, false, 2, null);
                                                if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                                                    results.add("hill " + k1 + ' ' + k2 + ' ' + k3 + ' ' + k4 + ": " + System.lineSeparator() + '\t' + decrypted);
                                                }
                                                object = Result.constructor-impl((Object)Unit.INSTANCE);
                                            }
                                            catch (Throwable throwable) {
                                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                            }
                                            if (k4 == n4) break;
                                            ++k4;
                                        }
                                    }
                                    if (k3 == n3) break;
                                    ++k3;
                                }
                            }
                            if (k2 == n2) break;
                            ++k2;
                        }
                    }
                    if (k1 == n) break;
                    ++k1;
                }
            }
            Iterable iterable = results;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
            return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"key matrix,like 1 2 0 1 or bcab", "A = 0 as default,if has value A =1"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$Rabbit;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class Rabbit
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Rabbit() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            return JavascriptCipher.INSTANCE.rabbitEncrypt(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            return JavascriptCipher.INSTANCE.rabbitDecrypt(raw, string);
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"password,default is empty string", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$AAEncode;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class AAEncode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AAEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return JavascriptCipher.INSTANCE.aaEncode(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return JavascriptCipher.INSTANCE.aaDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$JJEncode;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "paramsCount", "", "paramsHints", "", "app"})
    static final class JJEncode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        JJEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "$";
            }
            String string2 = params.get("p2");
            return JavascriptCipher.INSTANCE.jjEncode(raw, string, string2 != null ? ((CharSequence)string2).length() == 0 : true);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return JavascriptCipher.INSTANCE.jjDecode(raw);
        }

        @Override
        public int paramsCount() {
            return 2;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"global variable name, default is '$'", "palindromic,false as default,if has value is true"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$RSA_CRACK;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class RSA_CRACK
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        RSA_CRACK() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return this.decrypt(raw, params);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Map<String, BigInteger> $this$decrypt_u24lambda_u2d0 = ParamsParserKt.parseRsaParams(raw);
            boolean bl = false;
            return RsaSolver.INSTANCE.solve($this$decrypt_u24lambda_u2d0);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$DNA;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class DNA
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        DNA() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return DNAKt.dna(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return DNAKt.dnaDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$TAP_CODE;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class TAP_CODE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        TAP_CODE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TapCodeCipherKt.tapCode$default(raw, null, null, 3, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TapCodeCipherKt.tapCodeDecrypt$default(raw, null, null, 3, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a8\u0006\u000e"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$CAESAR_BOX;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "paramsCount", "", "paramsHints", "", "app"})
    static final class CAESAR_BOX
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CAESAR_BOX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return CaesarBoxCipherKt.caesarBox(raw, Integer.parseInt(string));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return CaesarBoxCipherKt.caesarBoxDecrypt(raw, Integer.parseInt(string));
        }

        @Override
        public int paramsCount() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> paramsHints() {
            Object[] objectArray = new String[]{"height", ""};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$ROT8000;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class ROT8000
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT8000() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Rot8000Kt.rot8000$default(raw, 0, 1, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Rot8000Kt.rot8000$default(raw, 0, 1, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$CETACEAN;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class CETACEAN
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CETACEAN() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return CetaceanCipherKt.cetacean(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return CetaceanCipherKt.cetaceanDecrypt(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType$YYGQ;", "Lme/leon/ext/crypto/ClassicalCryptoType;", "decrypt", "", "raw", "params", "", "encrypt", "isIgnoreSpace", "", "app"})
    static final class YYGQ
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        YYGQ() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return YygqCipherKt.yygq(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return YygqCipherKt.yygqDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }
}

