/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.encode.DecimalKt;
import me.leon.encode.EscapeUtilsKt;
import me.leon.encode.OctalKt;
import me.leon.encode.PunyCodeKt;
import me.leon.encode.QuotePrintableKt;
import me.leon.encode.UuEncodeKt;
import me.leon.encode.XxEncodeKt;
import me.leon.encode.base.Base100Kt;
import me.leon.encode.base.Base16Kt;
import me.leon.encode.base.Base32Kt;
import me.leon.encode.base.Base36Kt;
import me.leon.encode.base.Base45Kt;
import me.leon.encode.base.Base58CheckKt;
import me.leon.encode.base.Base58Kt;
import me.leon.encode.base.Base62Kt;
import me.leon.encode.base.Base64Kt;
import me.leon.encode.base.Base85Kt;
import me.leon.encode.base.Base91Kt;
import me.leon.encode.base.Base92Kt;
import me.leon.encode.base.Radix10Kt;
import me.leon.encode.base.Radix32Kt;
import me.leon.encode.base.Radix64Kt;
import me.leon.encode.base.Radix8Kt;
import me.leon.ext.ConverterKt;
import me.leon.ext.crypto.IEncode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b)\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,\u00a8\u0006-"}, d2={"Lme/leon/ext/crypto/EncodeType;", "", "Lme/leon/ext/crypto/IEncode;", "type", "", "defaultDict", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getDefaultDict", "()Ljava/lang/String;", "getType", "Hex", "Base64", "Base16", "Base32", "Base36", "Base58", "Base58Check", "Base85IPv6", "Base62", "Base91", "Base92", "Base64Url", "Base85", "Z85", "Base100", "Radix64", "Radix8", "Radix10", "Radix32", "UrlEncode", "Unicode", "Decimal", "Octal", "Binary", "Base45", "JsHexEncode", "JsOctalEncode", "Escape", "EscapeAll", "UuEncode", "XxEncode", "QuotePrintable", "PunyCode", "HtmlEntity", "HexReverse", "app"})
public abstract class EncodeType
extends Enum<EncodeType>
implements IEncode {
    @NotNull
    private final String type;
    @NotNull
    private final String defaultDict;
    public static final /* enum */ EncodeType Hex = new Hex("Hex", 0);
    public static final /* enum */ EncodeType Base64 = new Base64("Base64", 1);
    public static final /* enum */ EncodeType Base16 = new Base16("Base16", 2);
    public static final /* enum */ EncodeType Base32 = new Base32("Base32", 3);
    public static final /* enum */ EncodeType Base36 = new Base36("Base36", 4);
    public static final /* enum */ EncodeType Base58 = new Base58("Base58", 5);
    public static final /* enum */ EncodeType Base58Check = new Base58Check("Base58Check", 6);
    public static final /* enum */ EncodeType Base85IPv6 = new Base85IPv6("Base85IPv6", 7);
    public static final /* enum */ EncodeType Base62 = new Base62("Base62", 8);
    public static final /* enum */ EncodeType Base91 = new Base91("Base91", 9);
    public static final /* enum */ EncodeType Base92 = new Base92("Base92", 10);
    public static final /* enum */ EncodeType Base64Url = new Base64Url("Base64Url", 11);
    public static final /* enum */ EncodeType Base85 = new Base85("Base85", 12);
    public static final /* enum */ EncodeType Z85 = new Z85("Z85", 13);
    public static final /* enum */ EncodeType Base100 = new Base100("Base100", 14);
    public static final /* enum */ EncodeType Radix64 = new Radix64("Radix64", 15);
    public static final /* enum */ EncodeType Radix8 = new Radix8("Radix8", 16);
    public static final /* enum */ EncodeType Radix10 = new Radix10("Radix10", 17);
    public static final /* enum */ EncodeType Radix32 = new Radix32("Radix32", 18);
    public static final /* enum */ EncodeType UrlEncode = new UrlEncode("UrlEncode", 19);
    public static final /* enum */ EncodeType Unicode = new Unicode("Unicode", 20);
    public static final /* enum */ EncodeType Decimal = new Decimal("Decimal", 21);
    public static final /* enum */ EncodeType Octal = new Octal("Octal", 22);
    public static final /* enum */ EncodeType Binary = new Binary("Binary", 23);
    public static final /* enum */ EncodeType Base45 = new Base45("Base45", 24);
    public static final /* enum */ EncodeType JsHexEncode = new JsHexEncode("JsHexEncode", 25);
    public static final /* enum */ EncodeType JsOctalEncode = new JsOctalEncode("JsOctalEncode", 26);
    public static final /* enum */ EncodeType Escape = new Escape("Escape", 27);
    public static final /* enum */ EncodeType EscapeAll = new EscapeAll("EscapeAll", 28);
    public static final /* enum */ EncodeType UuEncode = new UuEncode("UuEncode", 29);
    public static final /* enum */ EncodeType XxEncode = new XxEncode("XxEncode", 30);
    public static final /* enum */ EncodeType QuotePrintable = new QuotePrintable("QuotePrintable", 31);
    public static final /* enum */ EncodeType PunyCode = new PunyCode("PunyCode", 32);
    public static final /* enum */ EncodeType HtmlEntity = new HtmlEntity("HtmlEntity", 33);
    public static final /* enum */ EncodeType HexReverse = new HexReverse("HexReverse", 34);
    private static final /* synthetic */ EncodeType[] $VALUES;

    private EncodeType(String type2, String defaultDict) {
        this.type = type2;
        this.defaultDict = defaultDict;
    }

    /* synthetic */ EncodeType(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string3 = "";
        }
        this(string2, string3);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getDefaultDict() {
        return this.defaultDict;
    }

    public static EncodeType[] values() {
        return (EncodeType[])$VALUES.clone();
    }

    public static EncodeType valueOf(String value) {
        return Enum.valueOf(EncodeType.class, value);
    }

    public /* synthetic */ EncodeType(String $enum$name, int $enum$ordinal, String type2, String defaultDict, DefaultConstructorMarker $constructor_marker) {
        this(type2, defaultDict);
    }

    static {
        $VALUES = encodeTypeArray = new EncodeType[]{EncodeType.Hex, EncodeType.Base64, EncodeType.Base16, EncodeType.Base32, EncodeType.Base36, EncodeType.Base58, EncodeType.Base58Check, EncodeType.Base85IPv6, EncodeType.Base62, EncodeType.Base91, EncodeType.Base92, EncodeType.Base64Url, EncodeType.Base85, EncodeType.Z85, EncodeType.Base100, EncodeType.Radix64, EncodeType.Radix8, EncodeType.Radix10, EncodeType.Radix32, EncodeType.UrlEncode, EncodeType.Unicode, EncodeType.Decimal, EncodeType.Octal, EncodeType.Binary, EncodeType.Base45, EncodeType.JsHexEncode, EncodeType.JsOctalEncode, EncodeType.Escape, EncodeType.EscapeAll, EncodeType.UuEncode, EncodeType.XxEncode, EncodeType.QuotePrintable, EncodeType.PunyCode, EncodeType.HtmlEntity, EncodeType.HexReverse};
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Hex;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Hex
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Hex() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            CharSequence charSequence = encoded;
            Regex regex = new Regex("\\\\x|\\s|0x|\\\\");
            String string = "";
            return ConverterKt.hex2ByteArray(regex.replace(charSequence, string));
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return ConverterKt.toHex(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base64;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base64
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base64() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base64Kt.base64Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base64Kt.base64$default(bytes, dict, false, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base16;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base16
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base16() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base16Kt.base16Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base16Kt.base16(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base32;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base32
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base32() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base32Kt.base32Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base32Kt.base32(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base36;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base36
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base36() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base36Kt.base36Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base36Kt.base36(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base58;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base58
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base58() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base58Kt.base58Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base58Kt.base58(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base58Check;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base58Check
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base58Check() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base58CheckKt.base58CheckDecode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base58CheckKt.base58Check(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base85IPv6;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base85IPv6
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base85IPv6() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = encoded;
            CharSequence charSequence2 = dict;
            if (charSequence2.length() == 0) {
                String string2 = string;
                boolean bl = false;
                charSequence = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~";
                string = string2;
            } else {
                charSequence = charSequence2;
            }
            return Base85Kt.base85Decode(string, (String)charSequence);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = bytes;
            CharSequence charSequence2 = dict;
            if (charSequence2.length() == 0) {
                byte[] byArray2 = byArray;
                boolean bl = false;
                charSequence = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~";
                byArray = byArray2;
            } else {
                charSequence = charSequence2;
            }
            return Base85Kt.base85(byArray, (String)charSequence);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base62;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base62
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base62() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base62Kt.base62Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base62Kt.base62(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base91;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base91
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base91() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base91Kt.base91Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base91Kt.base91$default(bytes, dict, null, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base92;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base92
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base92() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base92Kt.base92Decode(encoded, dict, charset);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base92Kt.base92Encode(bytes, dict, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base64Url;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base64Url
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base64Url() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base64Kt.base64UrlDecode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base64Kt.base64Url(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base85;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base85
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base85() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base85Kt.base85Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base85Kt.base85(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Z85;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Z85
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Z85() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = encoded;
            CharSequence charSequence2 = dict;
            if (charSequence2.length() == 0) {
                String string2 = string;
                boolean bl = false;
                charSequence = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#";
                string = string2;
            } else {
                charSequence = charSequence2;
            }
            return Base85Kt.base85Decode(string, (String)charSequence);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = bytes;
            CharSequence charSequence2 = dict;
            if (charSequence2.length() == 0) {
                byte[] byArray2 = byArray;
                boolean bl = false;
                charSequence = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#";
                byArray = byArray2;
            } else {
                charSequence = charSequence2;
            }
            return Base85Kt.base85(byArray, (String)charSequence);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base100;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base100
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base100() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base100Kt.base100Decode(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base100Kt.base100(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Radix64;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Radix64
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Radix64() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix64Kt.radix64Decode(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix64Kt.radix64(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Radix8;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Radix8
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Radix8() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix8Kt.radix8Decode(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix8Kt.radix8(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Radix10;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Radix10
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Radix10() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix10Kt.radix10Decode(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix10Kt.radix10(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Radix32;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Radix32
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Radix32() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix32Kt.radix32Decode(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Radix32Kt.radix32(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$UrlEncode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class UrlEncode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        UrlEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            String string;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string2 = encoded;
            Object object = charset;
            if (object.length() == 0) {
                String string3 = string2;
                boolean bl = false;
                charSequence = "UTF-8";
                string2 = string3;
            } else {
                charSequence = object;
            }
            if ((string = URLDecoder.decode(string2, (String)charSequence)) == null) {
                string = "";
            }
            String string4 = string;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            object = charset2;
            byte[] byArray = string4.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Object object2 = bytes;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            Charset charset3 = charset2;
            String string = new String((byte[])object2, charset3);
            object2 = charset;
            if (object2.length() == 0) {
                String string2 = string;
                boolean bl = false;
                object = "UTF-8";
                string = string2;
            } else {
                object = object2;
            }
            String string3 = URLEncoder.encode(string, (String)object);
            return string3 != null && (object2 = StringsKt.replace$default((String)string3, (String)"+", (String)"%20", (boolean)false, (int)4, null)) != null ? object2 : "";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Unicode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Unicode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Unicode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = ConverterKt.unicodeMix2String(encoded);
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = bytes;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            Charset charset3 = charset2;
            return ConverterKt.toUnicodeString(new String(byArray, charset3));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Decimal;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Decimal
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Decimal() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return DecimalKt.decimalDecode(encoded, charset);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return DecimalKt.decimal(bytes, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Octal;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Octal
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Octal() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return OctalKt.octalDecode(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return OctalKt.octal(bytes, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Binary;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Binary
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Binary() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return ConverterKt.binary2ByteArray(encoded);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return ConverterKt.toBinaryString(bytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Base45;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Base45
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Base45() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base45Kt.base45Decode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return Base45Kt.base45(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$JsHexEncode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class JsHexEncode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        JsHexEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = ConverterKt.jsHexDecodeString(encoded);
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = bytes;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            Charset charset3 = charset2;
            return ConverterKt.toJsHexEncodeString(new String(byArray, charset3));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$JsOctalEncode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class JsOctalEncode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        JsOctalEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = ConverterKt.jsOctalDecodeString(encoded);
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = bytes;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            Charset charset3 = charset2;
            return ConverterKt.toJsOctalEncodeString(new String(byArray, charset3));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$Escape;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class Escape
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        Escape() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return EscapeUtilsKt.unescape(encoded, charset);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return EscapeUtilsKt.escape(bytes, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$EscapeAll;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class EscapeAll
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        EscapeAll() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return EscapeUtilsKt.unescape(encoded, charset);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return EscapeUtilsKt.escapeAll(bytes, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$UuEncode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class UuEncode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        UuEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return UuEncodeKt.uuDecode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return UuEncodeKt.uuEncode(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$XxEncode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class XxEncode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        XxEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return XxEncodeKt.xxDecode(encoded, dict);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return XxEncodeKt.xxEncode(bytes, dict);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$QuotePrintable;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class QuotePrintable
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        QuotePrintable() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return QuotePrintableKt.quotePrintableDecode(encoded, charset);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return QuotePrintableKt.quotePrintable(bytes, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$PunyCode;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class PunyCode
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        PunyCode() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return PunyCodeKt.punyCodeDecode(encoded, charset);
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return PunyCodeKt.punyCode(bytes, charset);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$HtmlEntity;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class HtmlEntity
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        HtmlEntity() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = ConverterKt.htmlEntity2String(encoded);
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = bytes;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
            Charset charset3 = charset2;
            return ConverterKt.toHtmlEntity$default(new String(byArray, charset3), 0, true, 1, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/leon/ext/crypto/EncodeType$HexReverse;", "Lme/leon/ext/crypto/EncodeType;", "decode", "", "encoded", "", "dict", "charset", "encode2String", "bytes", "app"})
    static final class HexReverse
    extends EncodeType {
        /*
         * WARNING - void declaration
         */
        HexReverse() {
            void var1_1;
        }

        @Override
        @NotNull
        public byte[] decode(@NotNull String encoded, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            CharSequence charSequence = encoded;
            Regex regex = new Regex("\\\\x|\\s|0x|\\\\");
            String string = "";
            return ConverterKt.hexReverse2ByteArray(regex.replace(charSequence, string));
        }

        @Override
        @NotNull
        public String encode2String(@NotNull byte[] bytes, @NotNull String dict, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return ConverterKt.toHexReverse(bytes);
        }
    }
}

