/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.DSTU7624Engine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.engines.TnepresEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.macs.KGMac;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.KGCMBlockCipher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lme/leon/ext/crypto/GMac;", "", "()V", "getInstance", "Lorg/bouncycastle/crypto/Mac;", "alg", "", "app"})
public final class GMac {
    @NotNull
    public static final GMac INSTANCE = new GMac();

    private GMac() {
    }

    @NotNull
    public final Mac getInstance(@NotNull String alg) {
        BlockCipher blockCipher;
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        String string = alg.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String string2 = string;
        Object[] objectArray = new String[]{"SERPENT-GMAC", "TNEPRES-GMAC"};
        if (ArraysKt.contains((Object[])objectArray, (Object)string2)) {
            blockCipher = (BlockCipher)new TnepresEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"TWOFISH-GMAC")) {
            blockCipher = (BlockCipher)new TwofishEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"ARIA-GMAC")) {
            blockCipher = (BlockCipher)new ARIAEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"SEED-GMAC")) {
            blockCipher = (BlockCipher)new SEEDEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"AES-GMAC")) {
            blockCipher = (BlockCipher)new AESEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"SM4-GMAC")) {
            blockCipher = (BlockCipher)new SM4Engine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"CAMELLIA-GMAC")) {
            blockCipher = (BlockCipher)new CamelliaEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"NOEKEON-GMAC")) {
            blockCipher = (BlockCipher)new NoekeonEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"CAST6-GMAC")) {
            blockCipher = (BlockCipher)new CAST6Engine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"RC6-GMAC")) {
            blockCipher = (BlockCipher)new RC6Engine();
        } else {
            objectArray = new String[]{"DSTU7624-128GMAC", "DSTU7624GMAC"};
            if (ArraysKt.contains((Object[])objectArray, (Object)string2)) {
                blockCipher = (BlockCipher)new DSTU7624Engine(128);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"DSTU7624-256GMAC")) {
                blockCipher = (BlockCipher)new DSTU7624Engine(256);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"DSTU7624-512GMAC")) {
                blockCipher = (BlockCipher)new DSTU7624Engine(512);
            } else {
                throw new IllegalArgumentException("illegal alg");
            }
        }
        BlockCipher blockCipher2 = blockCipher;
        return StringsKt.contains((CharSequence)alg, (CharSequence)"DSTU7624", (boolean)true) ? (Mac)new KGMac(new KGCMBlockCipher(blockCipher2)) : (Mac)new org.bouncycastle.crypto.macs.GMac(new GCMBlockCipher(blockCipher2));
    }
}

