/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.engines.TnepresEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.macs.Poly1305;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lme/leon/ext/crypto/Poly1305Serial;", "", "()V", "getInstance", "Lorg/bouncycastle/crypto/macs/Poly1305;", "alg", "", "app"})
public final class Poly1305Serial {
    @NotNull
    public static final Poly1305Serial INSTANCE = new Poly1305Serial();

    private Poly1305Serial() {
    }

    @NotNull
    public final Poly1305 getInstance(@NotNull String alg) {
        BlockCipher blockCipher;
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        String string = alg.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String string2 = string;
        Object[] objectArray = new String[]{"POLY1305", "POLY1305-AES"};
        if (ArraysKt.contains((Object[])objectArray, (Object)string2)) {
            blockCipher = (BlockCipher)new AESEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-TWOFISH")) {
            blockCipher = (BlockCipher)new TwofishEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-ARIA")) {
            blockCipher = (BlockCipher)new ARIAEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-SEED")) {
            blockCipher = (BlockCipher)new SEEDEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-SM4")) {
            blockCipher = (BlockCipher)new SM4Engine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-CAMELLIA")) {
            blockCipher = (BlockCipher)new CamelliaEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-NOEKEON")) {
            blockCipher = (BlockCipher)new NoekeonEngine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-CAST6")) {
            blockCipher = (BlockCipher)new CAST6Engine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-RC6")) {
            blockCipher = (BlockCipher)new RC6Engine();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"POLY1305-SERPENT")) {
            blockCipher = (BlockCipher)new TnepresEngine();
        } else {
            throw new IllegalArgumentException("illegal alg");
        }
        BlockCipher blockCipher2 = blockCipher;
        return new Poly1305(blockCipher2);
    }
}

