/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.argon2;

import java.util.Base64;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/leon/hash/argon2/Argon2EncodingUtils;", "", "()V", "b64decoder", "Ljava/util/Base64$Decoder;", "kotlin.jvm.PlatformType", "b64encoder", "Ljava/util/Base64$Encoder;", "decode", "Lme/leon/hash/argon2/Argon2EncodingUtils$Argon2Hash;", "encodedHash", "", "encode", "hash", "", "parameters", "Lorg/bouncycastle/crypto/params/Argon2Parameters;", "Argon2Hash", "app"})
public final class Argon2EncodingUtils {
    @NotNull
    public static final Argon2EncodingUtils INSTANCE = new Argon2EncodingUtils();
    private static final Base64.Encoder b64encoder = Base64.getEncoder().withoutPadding();
    private static final Base64.Decoder b64decoder = Base64.getDecoder();

    private Argon2EncodingUtils() {
    }

    @NotNull
    public final String encode(@Nullable byte[] hash, @NotNull Argon2Parameters parameters) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        StringBuilder stringBuilder = new StringBuilder();
        switch (parameters.getType()) {
            case 0: {
                stringBuilder.append("$argon2d");
                break;
            }
            case 1: {
                stringBuilder.append("$argon2i");
                break;
            }
            case 2: {
                stringBuilder.append("$argon2id");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm type: " + parameters.getType());
            }
        }
        stringBuilder.append("$v=").append(parameters.getVersion()).append("$m=").append(parameters.getMemory()).append(",t=").append(parameters.getIterations()).append(",p=").append(parameters.getLanes());
        if (parameters.getSalt() != null) {
            stringBuilder.append("$").append(b64encoder.encodeToString(parameters.getSalt()));
        }
        stringBuilder.append("$").append(b64encoder.encodeToString(hash));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    @NotNull
    public final Argon2Hash decode(@NotNull String encodedHash) throws IllegalArgumentException {
        Argon2Parameters.Builder builder;
        Intrinsics.checkNotNullParameter((Object)encodedHash, (String)"encodedHash");
        Argon2Parameters.Builder paramsBuilder = null;
        String[] stringArray = new String[]{"$"};
        String[] $this$toTypedArray$iv = (String[])StringsKt.split$default((CharSequence)encodedHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray2;
        if (!(parts.length >= 4)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$62 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$62 = "Invalid encoded Argon2-hash";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$62.toString());
        }
        int currentPart = 1;
        switch (parts[currentPart++]) {
            case "argon2d": {
                builder = new Argon2Parameters.Builder(0);
                break;
            }
            case "argon2i": {
                builder = new Argon2Parameters.Builder(1);
                break;
            }
            case "argon2id": {
                builder = new Argon2Parameters.Builder(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm type: " + parts[0]);
            }
        }
        paramsBuilder = builder;
        if (StringsKt.startsWith$default((String)parts[currentPart], (String)"v=", (boolean)false, (int)2, null)) {
            String string = parts[currentPart].substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            paramsBuilder.withVersion(Integer.parseInt(string));
        }
        int n = ++currentPart;
        ++currentPart;
        thisCollection$iv = new String[]{","};
        Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)parts[n], (String[])thisCollection$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] performanceParams = stringArray3;
        if (!(performanceParams.length == 3)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$72 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$72 = "Amount of performance parameters invalid";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$72.toString());
        }
        if (!StringsKt.startsWith$default((String)performanceParams[0], (String)"m=", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$82 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$82 = "Invalid memory parameter";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$82.toString());
        }
        String string = performanceParams[0].substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        paramsBuilder.withMemoryAsKB(Integer.parseInt(string));
        if (!StringsKt.startsWith$default((String)performanceParams[1], (String)"t=", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$92 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$92 = "Invalid iterations parameter";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$92.toString());
        }
        String string2 = performanceParams[1].substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        paramsBuilder.withIterations(Integer.parseInt(string2));
        if (!StringsKt.startsWith$default((String)performanceParams[2], (String)"p=", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string3 = "Invalid parallelity parameter";
            throw new IllegalArgumentException(string3.toString());
        }
        String string4 = performanceParams[2].substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        paramsBuilder.withParallelism(Integer.parseInt(string4));
        paramsBuilder.withSalt(b64decoder.decode(parts[currentPart++]));
        byte[] byArray = b64decoder.decode(parts[currentPart]);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"b64decoder.decode(parts[currentPart])");
        Argon2Parameters argon2Parameters = paramsBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)argon2Parameters, (String)"paramsBuilder.build()");
        return new Argon2Hash(byArray, argon2Parameters);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lme/leon/hash/argon2/Argon2EncodingUtils$Argon2Hash;", "", "hash", "", "parameters", "Lorg/bouncycastle/crypto/params/Argon2Parameters;", "([BLorg/bouncycastle/crypto/params/Argon2Parameters;)V", "getHash", "()[B", "setHash", "([B)V", "getParameters", "()Lorg/bouncycastle/crypto/params/Argon2Parameters;", "app"})
    public static final class Argon2Hash {
        @NotNull
        private byte[] hash;
        @NotNull
        private final Argon2Parameters parameters;

        public Argon2Hash(@NotNull byte[] hash, @NotNull Argon2Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.hash = hash;
            this.parameters = parameters;
        }

        @NotNull
        public final byte[] getHash() {
            return this.hash;
        }

        public final void setHash(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.hash = byArray;
        }

        @NotNull
        public final Argon2Parameters getParameters() {
            return this.parameters;
        }
    }
}

