/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.argon2;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.leon.hash.argon2.Argon2EncodingUtils;
import me.leon.hash.keygen.BytesKeyGenerator;
import me.leon.hash.keygen.KeyGenerators;
import me.leon.hash.password.PasswordEncoder;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B9\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\fR\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\f\u00a8\u0006'"}, d2={"Lme/leon/hash/argon2/Argon2PasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "saltLength", "", "hashLength", "parallelism", "memory", "iterations", "(IIIII)V", "getHashLength", "()I", "setHashLength", "(I)V", "getIterations", "setIterations", "getMemory", "setMemory", "getParallelism", "setParallelism", "saltGenerator", "Lme/leon/hash/keygen/BytesKeyGenerator;", "type", "getType", "setType", "version", "getVersion", "setVersion", "encode", "", "password", "", "rawPassword", "salt", "", "matches", "", "encodedPassword", "upgradeEncoding", "Companion", "app"})
public final class Argon2PasswordEncoder
implements PasswordEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int hashLength;
    private int parallelism;
    private int memory;
    private int iterations;
    @NotNull
    private final BytesKeyGenerator saltGenerator;
    private int type;
    private int version;
    private static final int DEFAULT_SALT_LENGTH = 16;
    private static final int DEFAULT_HASH_LENGTH = 32;
    private static final int DEFAULT_PARALLELISM = 1;
    private static final int DEFAULT_MEMORY = 4096;
    private static final int DEFAULT_ITERATIONS = 3;

    @JvmOverloads
    public Argon2PasswordEncoder(int saltLength, int hashLength, int parallelism, int memory, int iterations) {
        this.hashLength = hashLength;
        this.parallelism = parallelism;
        this.memory = memory;
        this.iterations = iterations;
        this.saltGenerator = KeyGenerators.secureRandom(saltLength);
        this.type = 2;
        this.version = 19;
    }

    public /* synthetic */ Argon2PasswordEncoder(int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 16;
        }
        if ((n6 & 2) != 0) {
            n2 = 32;
        }
        if ((n6 & 4) != 0) {
            n3 = 1;
        }
        if ((n6 & 8) != 0) {
            n4 = 4096;
        }
        if ((n6 & 0x10) != 0) {
            n5 = 3;
        }
        this(n, n2, n3, n4, n5);
    }

    public final int getHashLength() {
        return this.hashLength;
    }

    public final void setHashLength(int n) {
        this.hashLength = n;
    }

    public final int getParallelism() {
        return this.parallelism;
    }

    public final void setParallelism(int n) {
        this.parallelism = n;
    }

    public final int getMemory() {
        return this.memory;
    }

    public final void setMemory(int n) {
        this.memory = n;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final void setIterations(int n) {
        this.iterations = n;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n) {
        this.version = n;
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.encode(password, this.saltGenerator.generateKey());
    }

    @NotNull
    public final String encode(@NotNull CharSequence rawPassword, @NotNull byte[] salt) {
        Argon2BytesGenerator argon2BytesGenerator;
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        byte[] hash = new byte[this.hashLength];
        Argon2Parameters params = new Argon2Parameters.Builder(this.type).withVersion(this.version).withSalt(salt).withParallelism(this.parallelism).withMemoryAsKB(this.memory).withIterations(this.iterations).build();
        Argon2BytesGenerator $this$encode_u24lambda_u2d0 = argon2BytesGenerator = new Argon2BytesGenerator();
        boolean bl = false;
        $this$encode_u24lambda_u2d0.init(params);
        char[] cArray = ((Object)rawPassword).toString().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        argon2BytesGenerator.generateBytes(cArray, hash);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
        return Argon2EncodingUtils.INSTANCE.encode(hash, params);
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Argon2EncodingUtils.Argon2Hash argon2Hash;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        try {
            argon2Hash = Argon2EncodingUtils.INSTANCE.decode(encodedPassword);
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
        Argon2EncodingUtils.Argon2Hash decoded = argon2Hash;
        byte[] hashBytes = new byte[decoded.getHash().length];
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(decoded.getParameters());
        char[] cArray = ((Object)password).toString().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        generator.generateBytes(cArray, hashBytes);
        return Argon2PasswordEncoder.Companion.constantTimeArrayEquals(decoded.getHash(), hashBytes);
    }

    @Override
    public boolean upgradeEncoding(@NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        if (((CharSequence)encodedPassword).length() == 0) {
            System.out.println((Object)"password hash is null");
            return false;
        }
        Argon2Parameters parameters = Argon2EncodingUtils.INSTANCE.decode(encodedPassword).getParameters();
        return parameters.getMemory() < this.memory || parameters.getIterations() < this.iterations;
    }

    @JvmOverloads
    public Argon2PasswordEncoder(int saltLength, int hashLength, int parallelism, int memory) {
        this(saltLength, hashLength, parallelism, memory, 0, 16, null);
    }

    @JvmOverloads
    public Argon2PasswordEncoder(int saltLength, int hashLength, int parallelism) {
        this(saltLength, hashLength, parallelism, 0, 0, 24, null);
    }

    @JvmOverloads
    public Argon2PasswordEncoder(int saltLength, int hashLength) {
        this(saltLength, hashLength, 0, 0, 0, 28, null);
    }

    @JvmOverloads
    public Argon2PasswordEncoder(int saltLength) {
        this(saltLength, 0, 0, 0, 0, 30, null);
    }

    @JvmOverloads
    public Argon2PasswordEncoder() {
        this(0, 0, 0, 0, 0, 31, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/leon/hash/argon2/Argon2PasswordEncoder$Companion;", "", "()V", "DEFAULT_HASH_LENGTH", "", "DEFAULT_ITERATIONS", "DEFAULT_MEMORY", "DEFAULT_PARALLELISM", "DEFAULT_SALT_LENGTH", "constantTimeArrayEquals", "", "expected", "", "actual", "app"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean constantTimeArrayEquals(byte[] expected, byte[] actual) {
            if (expected.length != actual.length) {
                return false;
            }
            int result = 0;
            int n = expected.length;
            for (int i = 0; i < n; ++i) {
                result |= expected[i] ^ actual[i];
            }
            return result == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

