/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.password;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.hash.keygen.BytesKeyGenerator;
import me.leon.hash.keygen.KeyGenerators;
import me.leon.hash.password.PasswordEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/leon/hash/password/LdapShaPasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "saltGenerator", "Lme/leon/hash/keygen/BytesKeyGenerator;", "(Lme/leon/hash/keygen/BytesKeyGenerator;)V", "forceLowerCasePrefix", "", "combineHashAndSalt", "", "hash", "salt", "encode", "", "password", "", "extractPrefix", "encPass", "extractSalt", "getPrefix", "getSalt", "encodedPassword", "prefix", "getSha", "Ljava/security/MessageDigest;", "matches", "setForceLowerCasePrefix", "", "Companion", "app"})
public final class LdapShaPasswordEncoder
implements PasswordEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesKeyGenerator saltGenerator;
    private boolean forceLowerCasePrefix;
    private static final int SHA_LENGTH = 20;
    @NotNull
    private static final String SSHA_PREFIX = "{SSHA}";
    @NotNull
    private static final String SSHA_PREFIX_LC;
    @NotNull
    private static final String SHA_PREFIX = "{SHA}";
    @NotNull
    private static final String SHA_PREFIX_LC;

    @JvmOverloads
    public LdapShaPasswordEncoder(@NotNull BytesKeyGenerator saltGenerator) {
        Intrinsics.checkNotNullParameter((Object)saltGenerator, (String)"saltGenerator");
        this.saltGenerator = saltGenerator;
    }

    public /* synthetic */ LdapShaPasswordEncoder(BytesKeyGenerator bytesKeyGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bytesKeyGenerator = KeyGenerators.secureRandom();
        }
        this(bytesKeyGenerator);
    }

    private final byte[] combineHashAndSalt(byte[] hash, byte[] salt) {
        if (salt == null) {
            return hash;
        }
        return ArraysKt.plus((byte[])hash, (byte[])salt);
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.encode(password, this.saltGenerator.generateKey());
    }

    @NotNull
    public final String encode(@NotNull CharSequence password, @Nullable byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        MessageDigest sha = this.getSha(password);
        if (salt != null && !(salt.length == 0)) {
            sha.update(salt);
        }
        byte[] byArray = sha.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha.digest()");
        byte[] hash = this.combineHashAndSalt(byArray, salt);
        String prefix = this.getPrefix(salt);
        return prefix + Base64Kt.base64$default(hash, null, false, 3, null);
    }

    private final MessageDigest getSha(CharSequence password) {
        MessageDigest messageDigest;
        try {
            MessageDigest messageDigest2;
            MessageDigest $this$getSha_u24lambda_u2d0 = messageDigest2 = MessageDigest.getInstance("SHA");
            boolean bl = false;
            byte[] byArray = ((Object)password).toString().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            $this$getSha_u24lambda_u2d0.update(byArray);
            MessageDigest messageDigest3 = messageDigest2;
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest3, (String)"{\n            MessageDig\u2026oByteArray()) }\n        }");
            messageDigest = messageDigest3;
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new IllegalStateException("No SHA implementation available!".toString());
        }
        return messageDigest;
    }

    private final String getPrefix(byte[] salt) {
        if (salt == null || salt.length == 0) {
            return this.forceLowerCasePrefix ? SHA_PREFIX_LC : SHA_PREFIX;
        }
        return this.forceLowerCasePrefix ? SSHA_PREFIX_LC : SSHA_PREFIX;
    }

    private final byte[] extractSalt(String encPass) {
        String string = encPass.substring(6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String encPassNoLabel = string;
        byte[] hashAndSalt = Base64Kt.base64Decode$default(encPassNoLabel, null, 1, null);
        int saltLength = hashAndSalt.length - 20;
        byte[] salt = new byte[saltLength];
        System.arraycopy(hashAndSalt, 20, salt, 0, saltLength);
        return salt;
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        return this.matches(((Object)password).toString(), encodedPassword);
    }

    private final boolean matches(String password, String encodedPassword) {
        String string = this.extractPrefix(encodedPassword);
        if (string == null) {
            return Intrinsics.areEqual((Object)encodedPassword, (Object)password);
        }
        String prefix = string;
        byte[] salt = this.getSalt(encodedPassword, prefix);
        int startOfHash = prefix.length();
        String string2 = this.encode(password, salt).substring(startOfHash);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String encodedRawPass = string2;
        String string3 = encodedPassword.substring(startOfHash);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        return Intrinsics.areEqual((Object)encodedRawPass, (Object)string3);
    }

    private final byte[] getSalt(String encodedPassword, String prefix) {
        if (Intrinsics.areEqual((Object)prefix, (Object)SSHA_PREFIX) || Intrinsics.areEqual((Object)prefix, (Object)SSHA_PREFIX_LC)) {
            return this.extractSalt(encodedPassword);
        }
        if (!(Intrinsics.areEqual((Object)prefix, (Object)SHA_PREFIX) || Intrinsics.areEqual((Object)prefix, (Object)SHA_PREFIX_LC))) {
            boolean bl = false;
            String string = "Unsupported password prefix '" + prefix + '\'';
            throw new IllegalArgumentException(string.toString());
        }
        return null;
    }

    private final String extractPrefix(String encPass) {
        if (!StringsKt.startsWith$default((String)encPass, (String)"{", (boolean)false, (int)2, null)) {
            return null;
        }
        int secondBrace = StringsKt.lastIndexOf$default((CharSequence)encPass, (char)'}', (int)0, (boolean)false, (int)6, null);
        if (!(secondBrace >= 0)) {
            boolean bl = false;
            String string = "Couldn't find closing brace for SHA prefix";
            throw new IllegalArgumentException(string.toString());
        }
        String string = encPass.substring(0, secondBrace + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final void setForceLowerCasePrefix(boolean forceLowerCasePrefix) {
        this.forceLowerCasePrefix = forceLowerCasePrefix;
    }

    @Override
    public boolean upgradeEncoding(@NotNull String encodedPassword) {
        return PasswordEncoder.DefaultImpls.upgradeEncoding(this, encodedPassword);
    }

    @JvmOverloads
    public LdapShaPasswordEncoder() {
        this(null, 1, null);
    }

    static {
        String string = SSHA_PREFIX.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        SSHA_PREFIX_LC = string;
        String string2 = SHA_PREFIX.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        SHA_PREFIX_LC = string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/leon/hash/password/LdapShaPasswordEncoder$Companion;", "", "()V", "SHA_LENGTH", "", "SHA_PREFIX", "", "SHA_PREFIX_LC", "SSHA_PREFIX", "SSHA_PREFIX_LC", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

