/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.scrypt;

import java.security.MessageDigest;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.hash.keygen.BytesKeyGenerator;
import me.leon.hash.keygen.KeyGenerators;
import me.leon.hash.password.PasswordEncoder;
import org.bouncycastle.crypto.generators.SCrypt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\f\u00a8\u0006$"}, d2={"Lme/leon/hash/scrypt/SCryptPasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "cpuCost", "", "memoryCost", "parallelization", "keyLength", "saltLength", "(IIIII)V", "getCpuCost", "()I", "setCpuCost", "(I)V", "getKeyLength", "setKeyLength", "getMemoryCost", "setMemoryCost", "getParallelization", "setParallelization", "saltGenerator", "Lme/leon/hash/keygen/BytesKeyGenerator;", "getSaltLength", "setSaltLength", "decodeAndCheckMatches", "", "rawPassword", "", "encodedPassword", "", "digest", "salt", "", "encode", "password", "matches", "upgradeEncoding", "app"})
public final class SCryptPasswordEncoder
implements PasswordEncoder {
    private int cpuCost;
    private int memoryCost;
    private int parallelization;
    private int keyLength;
    private int saltLength;
    @NotNull
    private final BytesKeyGenerator saltGenerator;

    @JvmOverloads
    public SCryptPasswordEncoder(int cpuCost, int memoryCost, int parallelization, int keyLength, int saltLength) {
        this.cpuCost = cpuCost;
        this.memoryCost = memoryCost;
        this.parallelization = parallelization;
        this.keyLength = keyLength;
        this.saltLength = saltLength;
        if (!(this.cpuCost > 1)) {
            boolean $i$a$-require-SCryptPasswordEncoder$72 = false;
            String $i$a$-require-SCryptPasswordEncoder$72 = "Cpu cost parameter must be > 1.";
            throw new IllegalArgumentException($i$a$-require-SCryptPasswordEncoder$72.toString());
        }
        if (!(this.memoryCost != 1 || this.cpuCost <= 65536)) {
            boolean $i$a$-require-SCryptPasswordEncoder$82 = false;
            String $i$a$-require-SCryptPasswordEncoder$82 = "Cpu cost parameter must be > 1 and < 65536.";
            throw new IllegalArgumentException($i$a$-require-SCryptPasswordEncoder$82.toString());
        }
        if (!(this.memoryCost >= 1)) {
            boolean bl = false;
            String string = "Memory cost must be >= 1.";
            throw new IllegalArgumentException(string.toString());
        }
        int maxParallel = Integer.MAX_VALUE / (128 * this.memoryCost * 8);
        if (!(this.parallelization >= 1 && this.parallelization <= maxParallel)) {
            boolean $i$a$-require-SCryptPasswordEncoder$92 = false;
            String $i$a$-require-SCryptPasswordEncoder$92 = "Parallelization parameter p must be >= 1 and <= " + maxParallel + " (based on block size r of " + this.memoryCost + ')';
            throw new IllegalArgumentException($i$a$-require-SCryptPasswordEncoder$92.toString());
        }
        if (!(this.keyLength >= 1)) {
            boolean $i$a$-require-SCryptPasswordEncoder$102 = false;
            String $i$a$-require-SCryptPasswordEncoder$102 = "Key length must be >= ";
            throw new IllegalArgumentException($i$a$-require-SCryptPasswordEncoder$102.toString());
        }
        if (!(this.saltLength >= 1)) {
            boolean bl = false;
            String string = "Salt length must be >= 1  ";
            throw new IllegalArgumentException(string.toString());
        }
        this.saltGenerator = KeyGenerators.secureRandom(this.saltLength);
    }

    public /* synthetic */ SCryptPasswordEncoder(int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 16384;
        }
        if ((n6 & 2) != 0) {
            n2 = 8;
        }
        if ((n6 & 4) != 0) {
            n3 = 1;
        }
        if ((n6 & 8) != 0) {
            n4 = 32;
        }
        if ((n6 & 0x10) != 0) {
            n5 = 64;
        }
        this(n, n2, n3, n4, n5);
    }

    public final int getCpuCost() {
        return this.cpuCost;
    }

    public final void setCpuCost(int n) {
        this.cpuCost = n;
    }

    public final int getMemoryCost() {
        return this.memoryCost;
    }

    public final void setMemoryCost(int n) {
        this.memoryCost = n;
    }

    public final int getParallelization() {
        return this.parallelization;
    }

    public final void setParallelization(int n) {
        this.parallelization = n;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }

    public final void setKeyLength(int n) {
        this.keyLength = n;
    }

    public final int getSaltLength() {
        return this.saltLength;
    }

    public final void setSaltLength(int n) {
        this.saltLength = n;
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.digest(password, this.saltGenerator.generateKey());
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        if (encodedPassword.length() < this.keyLength) {
            System.out.println((Object)"Empty encoded password");
            return false;
        }
        return this.decodeAndCheckMatches(password, encodedPassword);
    }

    @Override
    public boolean upgradeEncoding(@NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        if (((CharSequence)encodedPassword).length() == 0) {
            return false;
        }
        String[] stringArray = new String[]{"$"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)encodedPassword, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray2;
        if (!(parts.length == 4)) {
            boolean bl = false;
            String string = "Encoded password does not look like SCrypt: " + encodedPassword;
            throw new IllegalArgumentException(string.toString());
        }
        long params = Long.parseLong(parts[1], CharsKt.checkRadix((int)16));
        int cpuCost = (int)Math.pow(2.0, params >> 16 & 0xFFFFL);
        int memoryCost = (int)params >> 8 & 0xFF;
        int parallelization = (int)params & 0xFF;
        return cpuCost < this.cpuCost || memoryCost < this.memoryCost || parallelization < this.parallelization;
    }

    private final boolean decodeAndCheckMatches(CharSequence rawPassword, String encodedPassword) {
        String[] stringArray = new String[]{"$"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)encodedPassword, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray2;
        if (parts.length != 4) {
            return false;
        }
        long params = Long.parseLong(parts[1], CharsKt.checkRadix((int)16));
        byte[] salt = Base64Kt.base64Decode$default(parts[2], null, 1, null);
        byte[] derived = Base64Kt.base64Decode$default(parts[3], null, 1, null);
        int cpuCost = (int)Math.pow(2.0, params >> 16 & 0xFFFFL);
        int memoryCost = (int)params >> 8 & 0xFF;
        int parallelization = (int)params & 0xFF;
        String string = ((Object)rawPassword).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] generated = SCrypt.generate((byte[])byArray, (byte[])salt, (int)cpuCost, (int)memoryCost, (int)parallelization, (int)this.keyLength);
        return MessageDigest.isEqual(derived, generated);
    }

    @NotNull
    public final String digest(@NotNull CharSequence rawPassword, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        String string = ((Object)rawPassword).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] derived = SCrypt.generate((byte[])byArray, (byte[])salt, (int)this.cpuCost, (int)this.memoryCost, (int)this.parallelization, (int)this.keyLength);
        String string2 = Long.toString((int)(Math.log(this.cpuCost) / Math.log(2.0)) << 16 | this.memoryCost << 8 | this.parallelization, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        String params = string2;
        StringBuilder stringBuilder = new StringBuilder((salt.length + derived.length) * 2).append("$").append(params).append('$').append(Base64Kt.base64$default(salt, null, false, 3, null)).append('$');
        Intrinsics.checkNotNullExpressionValue((Object)derived, (String)"derived");
        StringBuilder sb = stringBuilder.append(Base64Kt.base64$default(derived, null, false, 3, null));
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
        return string3;
    }

    @JvmOverloads
    public SCryptPasswordEncoder(int cpuCost, int memoryCost, int parallelization, int keyLength) {
        this(cpuCost, memoryCost, parallelization, keyLength, 0, 16, null);
    }

    @JvmOverloads
    public SCryptPasswordEncoder(int cpuCost, int memoryCost, int parallelization) {
        this(cpuCost, memoryCost, parallelization, 0, 0, 24, null);
    }

    @JvmOverloads
    public SCryptPasswordEncoder(int cpuCost, int memoryCost) {
        this(cpuCost, memoryCost, 0, 0, 0, 28, null);
    }

    @JvmOverloads
    public SCryptPasswordEncoder(int cpuCost) {
        this(cpuCost, 0, 0, 0, 0, 30, null);
    }

    @JvmOverloads
    public SCryptPasswordEncoder() {
        this(0, 0, 0, 0, 0, 31, null);
    }
}

