Scriptname TrainingDummiesSpeech extends ObjectReference  
{Replacement script for certain altars. If the player has the blessing already, instead award speach experience.}

GlobalVariable Property TrainingDummySpeechEnable auto	; Set to zero to disable
GlobalVariable Property TrainingDummySpeechBaseXP auto	; Base XP awarded for each meditation
GlobalVariable Property TrainingDummySpeechVarXP auto	; 0 to this number extra XP awarded each time
GlobalVariable Property GameHour auto					; Skyrim global var that controls the time
MagicEffect    Property BlessingToCheck auto			; Check to see if the blessing is in effect
Message        Property MeditationQueryMsg auto			; Player prompt, yes/no mesage box (0 = Yes, 1 = No)
Message        Property MeditationCompleteMsg auto		; Shown at the end of meditation

Message        Property AltarRemoveMsg auto				; These three properties are from the original script
Message        Property BlessingMessage auto
Spell          Property TempleBlessing auto

Event OnActivate(ObjectReference akActionRef)

	if (akActionRef != Game.GetPlayer())
		; The original script always casts the BlessingSpell and then shows the messages
		; only if it's the player. So, we've restructured a bit to emulate that behavior.
		TempleBlessing.Cast(akActionRef, akActionRef)
	Else
		Actor akActor = akActionRef as Actor
		If akActor.HasMagicEffect(BlessingToCheck) && TrainingDummySpeechEnable.GetValue() as Int != 0
			; Offer the opportunity to meditate
			Int iChoice = MeditationQueryMsg.Show()
			If (iChoice == 0)
				Int xp = TrainingDummySpeechBaseXP.GetValue() as Int + Utility.RandomInt(0, TrainingDummySpeechVarXP.GetValue() as Int)
				Float lvlMult = Game.GetPlayer().GetActorValue("Speechcraft") * 0.75
				Float xpToAward = xp * lvlMult
				; Debug.Notification("Advance Speech by " + xpToAward)
				Game.AdvanceSkill("Speechcraft", xpToAward)
				; Game.FadeOutGame(true, true, 0.0, 3.5)
				; Game.FadeOutGame(false, true, 0.0, 3.5)
				; Utility.Wait(4.0)
				; Game.FadeOutGame(True, True, 3.0, 2.0)Utility.Wait(2)Game.FadeOutGame(False, True, 10.0, 2.0)
				Game.FadeOutGame(True, True, 1.0, 3.0)
				Utility.Wait(1.5)
				Game.FadeOutGame(False, True, 8.0, 3.0)
				GameHour.Mod(1.0)
				Utility.Wait(3)
				MeditationCompleteMsg.Show()
			EndIf
		Else
			; Bestow the blessing
			TempleBlessing.Cast(akActionRef, akActionRef)
			AltarRemoveMsg.Show()
			BlessingMessage.Show()
		EndIf
	EndIf

EndEvent
