Scriptname TrainingDummiesXP extends ObjectReference  
{ Increment skill XP slightly when practicing on dummies and targets }

GlobalVariable Property TrainingDummyBaseXP auto       ; Base XP awarded for successful attack
GlobalVariable Property TrainingDummyVariableXP auto   ; 0 to this number extra XP awarded each time
GlobalVariable Property TrainingDummyPowerMult auto    ; Multiplier for power attack (doesn't work)

GlobalVariable Property TrainingDummyBonusEnable auto  ; Disable distance bonuses by setting this to 0
GlobalVariable Property TrainingDummyMinDist auto      ; Minimum distance for projectile attacks
GlobalVariable Property TrainingDummyBonusDist auto    ; Distance at which a bonus will apply
GlobalVariable Property TrainingDummyBonusIncr auto    ; Extra XP awarded based on this increment over bonus distance
GlobalVariable Property TrainingDummyBonusXP auto      ; Amount of bonus XP award per distance increment
GlobalVariable Property TrainingDummyWarnTooClose auto ; If not 0, warn the archer if too close to target

GlobalVariable Property TrainingDummyMagicXP auto      ; If not 0, award XP for destruction spells
GlobalVariable Property TrainingDummyPerSecondXP auto  ; XP awarded per second for spells with duration > 0

GlobalVariable Property TrainingDummyBashBlockXP Auto  ; If not 0, award Blocking XP for Bash attacks

Message Property TrainingDummyWarnTooCloseMessage auto

; **********************************************************************************************
; Examples:
;	Attack with handheld weapon:
;		Award BaseXP (could be 0) plus 0 to VariableXP extra (could be 0 either by seetting VariableXP to 0 or by 'rolling' a 0)
;	Attack with a bow:
;		Archer distance less than MinDist:
;			0 XP awarded
;		Archer distance at least MinDist and less than BonusDist:
;			Calculated as per handheld example above
;		Archer distance greater than BonusDist:
;			Calculated as per handheld example above PLUS BonusXP PLUS BonusXP for each BonusIncr units distance above BonusDist
;	Attack with a duration 0 spell (i.e., Firebolt)
;		Calculated as per handheld example above
;	Attack with a spell with duration > 0 (i.e., Flames)
;		PerSecondXP awarded for each second of duration
; **********************************************************************************************

Event onHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)

	; Debug.Notification("ouch")
	If akAggressor == Game.GetPlayer()
		; Debug.Notification("Hello Dovahkin")
		
		; *******************************
		; Calculate the basic XP to award
		; *******************************
		Int baseXP = TrainingDummyBaseXP.GetValue() as Int
		; I guess power attacks don't register on dummies
		if abPowerAttack
			Debug.Notification("woah! power!")
			baseXP *= TrainingDummyPowerMult.GetValue() as Int
		EndIf
		Int xp = baseXP + Utility.RandomInt(0, TrainingDummyVariableXP.GetValue() as Int)
		
		; ********************************************************
		; Discover the weapon type to see what kind of XP to award
		; ********************************************************
		Weapon akWeapon = akSource as Weapon
		Int weaponType = akWeapon.GetWeaponType()
		Int sourceType = akSource.GetType()
		; Debug.Notification("Weapon type: " + weaponType)
		; Debug.Notification("Source type: " + sourceType)
		; Debug.Notification("Bash: " + abBashAttack)
		Bool isATarget = self.HasKeywordString("TrainingDummyTarget");
		; Debug.Notification("isATarget=" + isATarget)
		
		if sourceType == 41
			If weaponType > 0 && weaponType <= 4 && !isATarget
				; Debug.Notification("OneHanded + " + xp)
				Game.AdvanceSkill("OneHanded", xp as Float)
			
			ElseIf (weaponType == 5 || weaponType == 6) && !isATarget
				; Debug.Notification("TwoHanded + " + xp)
				Game.AdvanceSkill("TwoHanded", xp as Float)
			
			ElseIf weaponType == 7 || weaponType == 9
				Int iArcherDistance = akAggressor.GetDistance(Self) as Int
				Int iBonusDistance  = TrainingDummyBonusDist.GetValue() as Int
				Int iBonusIncrement = TrainingDummyBonusIncr.GetValue() as Int
				Int iMinDistance    = TrainingDummyMinDist.GetValue() as Int
				Int iBaseBonusXP    = TrainingDummyBonusXP.GetValue() as Int
				Bool fBonusEnabled  = TrainingDummyBonusEnable.GetValue() as Int != 0
				
				If iArcherDistance >= iMinDistance
					; Calculate distance bonus if not disabled (iBonusDist <= 0)
					If fBonusEnabled ; used to be: iBonusDistance > 0
						Int iOverBonusDist = (iArcherDistance - iBonusDistance) / iBonusIncrement
						If iOverBonusDist >= 0
							; Int iBonusXP = iBaseBonusXP + (iOverBonusDist * iBaseBonusXP)
							; Debug.Notification("Distance " + iOverBonusDist + " over. Bonus = " + iBonusXP)
							xp += iBaseBonusXP + (iOverBonusDist * iBaseBonusXP)
						EndIf
					EndIf
					
					; Debug.Notification("Marksman + " + xp)
					Game.AdvanceSkill("Marksman", xp as Float)
					
				ElseIf TrainingDummyWarnTooClose.GetValue() as Int != 0
					TrainingDummyWarnTooCloseMessage.Show()
				EndIf
			EndIf
			
		ElseIf sourceType == 0 && weaponType == 0 && !isATarget && TrainingDummyBashBlockXP.GetValue() as Int != 0
			; Assume shield bash. abBashAttack doesn't get set on dummies
			; Debug.Notification("Block + " + xp)
			Game.AdvanceSkill("Block", xp as Float)
		
		ElseIf sourceType == 22 && !isATarget && TrainingDummyMagicXP.GetValue() as Int != 0
			; This was a spell
			Spell akSpell = akSource as Spell
			int numEffects = akSpell.GetNumEffects()
			int index = 0
			While index < numEffects
				MagicEffect effect = akSpell.GetNthEffectMagicEffect(index)
				If effect.GetAssociatedSkill() == "Destruction"
					Int duration = akSpell.GetNthEffectDuration(index)
					If (duration > 0)
						xp = duration * TrainingDummyPerSecondXP.GetValue() as Int
					EndIf
					; Debug.Notification("Destruction + " + xp)
					Game.AdvanceSkill("Destruction", xp as Float)
				EndIf
				index += 1
			EndWhile
		EndIf
		
	EndIf

EndEvent
