ScriptName TrainingDummies_Config Extends SKI_ConfigBase
{ Configuration menu for the Training Dummies mod }

; Properties ------------------------------------------------------------------------------------------------
GlobalVariable Property TrainingDummyBaseXP auto       ; Base XP awarded for successful attack
GlobalVariable Property TrainingDummyVariableXP auto   ; 0 to this number extra XP awarded each time
GlobalVariable Property TrainingDummyPowerMult auto    ; Multiplier for power attack (doesn't work)

GlobalVariable Property TrainingDummyBonusEnable auto  ; Distance bonus enabled/disabled (zero to disable)
GlobalVariable Property TrainingDummyMinDist auto      ; Minimum distance for projectile attacks
GlobalVariable Property TrainingDummyBonusDist auto    ; Distance at which a bonus will apply
GlobalVariable Property TrainingDummyBonusIncr auto    ; Extra XP awarded based on this increment over bonus distance
GlobalVariable Property TrainingDummyBonusXP auto      ; Amount of bonus XP award per distance increment
GlobalVariable Property TrainingDummyWarnTooClose auto ; If not 0, warn the archer if too close to target

GlobalVariable Property TrainingDummyMagicXP auto      ; If not 0, award XP for destruction spells
GlobalVariable Property TrainingDummyPerSecondXP auto  ; XP awarded per second for spells with duration > 0

GlobalVariable Property TrainingDummySpeechEnable auto ; Set to zero to disable
GlobalVariable Property TrainingDummySpeechBaseXP auto ; Base XP awarded for each meditation
GlobalVariable Property TrainingDummySpeechVarXP auto  ; 0 to this number extra XP awarded each time

; Version 4
GlobalVariable Property TrainingDummyBashBlockXP Auto  ; If not 0, award Blocking XP for Bash attacks

; Option IDs ------------------------------------------------------------------------------------------------
Int baseXPSlider
Int variableXPSlider
Int powerMultSlider
int warnTooCloseToggle
Int minimumDistSlider
Int enableBonusToggle
Int bonusDistanceSlider
Int bonusIncrementSlider
Int bonusXPSlider
Int magicToggle
Int magicPerSecondSlider
Int speechToggle
Int speechBaseXPSlider
Int speechVarXPSlider
Int bashBlockToggle

; Defaults --------------------------------------------------------------------------------------------------
; NOTE: The default values are HARDCODED into the translation file(s).
;       If they change here, these files need to be edited as well.
Int defaultBaseXP = 5
Int defaultVariableXP = 5
Int defaultPowerMult = 2
Int defaultMinDistance = 500
Int defaultBonusDistance = 1000
Int defaultBonusIncr = 100
Int defaultBonusXP = 1
Int defaultPerSecond = 1
Int defaultSpeechEnable = 1
Int defaultSpeechBaseXP = 10
Int defaultSpeechVarXP = 10
; Version 4
Int defaultBashBlockEnable = 0

; -----------------------------------------------------------------------------------------------------------

Int Function GetVersion()
	Return 4
EndFunction

Event OnPageReset(String page)
	{Called when a new page is selected, including the initial empty page}

	Bool bonusEnabled = TrainingDummyBonusEnable.GetValue() != 0
	int bonusSliderOption = OPTION_FLAG_DISABLED
	If bonusEnabled
		bonusSliderOption = OPTION_FLAG_NONE
	EndIf
	
	Bool bashBlockEnabled = TrainingDummyBashBlockXP.GetValue() != 0

	Bool magicEnabled = TrainingDummyMagicXP.GetValue() != 0
	int magicSliderOption = OPTION_FLAG_DISABLED
	If magicEnabled
		magicSliderOption = OPTION_FLAG_NONE
	EndIf
	
	If TrainingDummyBonusDist.GetValue() < TrainingDummyMinDist.GetValue()
		ShowMessage("$TDXP_MINDISTWARNING1", False)
		TrainingDummyBonusDist.SetValue(TrainingDummyMinDist.GetValue())
	EndIf
	
	SetCursorFillMode(TOP_TO_BOTTOM)
	AddHeaderOption("$Base Settings")
	baseXPSlider = AddSliderOption("$Base XP", TrainingDummyBaseXP.GetValue())
	variableXPSlider = AddSliderOption("$Variable XP", TrainingDummyBaseXP.GetValue())
	powerMultSlider = AddSliderOption("$Power Multiplier", TrainingDummyPowerMult.GetValue())
	
	AddEmptyOption()
	
	AddHeaderOption("$Block Options")
	bashBlockToggle = AddToggleOption("$Enable Block experience for Bash", bashBlockEnabled)
	
	AddEmptyOption()
	
	AddHeaderOption("$Magic Settings")
	magicToggle = AddToggleOption("$Enable experience for Magic", magicEnabled)
	magicPerSecondSlider = AddSliderOption("$XP per Second", TrainingDummyPerSecondXP.GetValue(), "{0}", magicSliderOption)
	
	SetCursorPosition(1)
	AddHeaderOption("$Archery Settings")
	warnTooCloseToggle = AddToggleOption("$Warn if too close to target", TrainingDummyWarnTooClose.GetValue() != 0.0)
	minimumDistSlider = AddSliderOption("$Minimum Distance to target", TrainingDummyMinDist.GetValue())
	enableBonusToggle = AddToggleOption("$Enable bonus experience", bonusEnabled)
	bonusDistanceSlider = AddSliderOption("$Bonus Minimum Distance", TrainingDummyBonusDist.GetValue(), "{0}", bonusSliderOption)
	bonusIncrementSlider = AddSliderOption("$Bonus Incremental Distance", TrainingDummyBonusIncr.GetValue(), "{0}", bonusSliderOption)
	bonusXPSlider = AddSliderOption("$Bonus XP per Increment", TrainingDummyBonusXP.GetValue(), "{0}", bonusSliderOption)

	AddEmptyOption()
	
	AddHeaderOption("$Speechcraft Settings")
	speechToggle = AddToggleOption("$Enable experience for worship", TrainingDummySpeechEnable.GetValue() != 0.0)
	speechBaseXPSlider = AddSliderOption("$Base shrine XP", TrainingDummySpeechBaseXP.GetValue())
	speechVarXPSlider = AddSliderOption("$Variable shrine XP", TrainingDummySpeechVarXP.GetValue())
	
EndEvent

Event OnOptionSelect(int option)
	if option == warnTooCloseToggle
		Bool toggleVal = (TrainingDummyWarnTooClose.GetValue() == 0.0)
		If toggleVal
			TrainingDummyWarnTooClose.SetValue(1.0)
		Else
			TrainingDummyWarnTooClose.SetValue(0.0)
		EndIf
		SetToggleOptionValue(option, toggleVal)
	ElseIf option == enableBonusToggle
		Bool toggleVal = (TrainingDummyBonusEnable.GetValue() == 0.0)
		If toggleVal
			TrainingDummyBonusEnable.SetValue(1.0)
		Else
			TrainingDummyBonusEnable.SetValue(0.0)
		EndIf
		SetToggleOptionValue(option, toggleVal)
		int optionVal = OPTION_FLAG_DISABLED
		If toggleVal
			optionVal = OPTION_FLAG_NONE
		EndIf
		SetOptionFlags(bonusDistanceSlider, optionVal)
		SetOptionFlags(bonusIncrementSlider, optionVal)
		SetOptionFlags(bonusXPSlider, optionVal)
	ElseIf option == bashBlockToggle
		Bool toggleVal = (TrainingDummyBashBlockXP.GetValue() == 0.0)
		If toggleVal
			TrainingDummyBashBlockXP.SetValue(1.0)
		Else
			TrainingDummyBashBlockXP.SetValue(0.0)
		EndIf
		SetToggleOptionValue(option, toggleVal)
	ElseIf option == magicToggle
		Bool toggleVal = (TrainingDummyMagicXP.GetValue() == 0.0)
		If toggleVal
			TrainingDummyMagicXP.SetValue(1.0)
		Else
			TrainingDummyMagicXP.SetValue(0.0)
		EndIf
		SetToggleOptionValue(option, toggleVal)
		int optionVal = OPTION_FLAG_DISABLED
		If toggleVal
			optionVal = OPTION_FLAG_NONE
		EndIf
		SetOptionFlags(magicPerSecondSlider, optionVal)
	ElseIf option == speechToggle
		Bool toggleVal = (TrainingDummySpeechEnable.GetValue() == 0.0)
		If toggleVal
			TrainingDummySpeechEnable.SetValue(1.0)
		Else
			TrainingDummySpeechEnable.SetValue(0.0)
		EndIf
		SetToggleOptionValue(option, toggleVal)
		int optionVal = OPTION_FLAG_DISABLED
		If toggleVal
			optionVal = OPTION_FLAG_NONE
		EndIf
		SetOptionFlags(speechBaseXPSlider, optionVal)
		SetOptionFlags(speechVarXPSlider, optionVal)
	EndIf
EndEvent

Event OnOptionSliderOpen(Int option)
	If option == baseXPSlider
		SetSliderDialogStartValue(TrainingDummyBaseXP.GetValue())
		SetSliderDialogDefaultValue(defaultBaseXP)
		SetSliderDialogRange(0.0, 50.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == variableXPSlider
		SetSliderDialogStartValue(TrainingDummyVariableXP.GetValue())
		SetSliderDialogDefaultValue(defaultVariableXP)
		SetSliderDialogRange(0.0, 50.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == powerMultSlider
		SetSliderDialogStartValue(TrainingDummyPowerMult.GetValue())
		SetSliderDialogDefaultValue(defaultPowerMult)
		SetSliderDialogRange(1.0, 10.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == minimumDistSlider
		float value = TrainingDummyMinDist.GetValue()
		SetSliderDialogStartValue(value)
		SetSliderDialogDefaultValue(defaultMinDistance)
		SetSliderDialogRange(0.0, 5000.0)
		SetSliderDialogInterval(10.0)
	ElseIf option == bonusDistanceSlider
		SetSliderDialogStartValue(TrainingDummyBonusDist.GetValue())
		Int defaultValue = defaultBonusDistance
		If defaultValue < TrainingDummyMinDist.GetValue()
			; No way to pop up a warning when default is selected in this scenario?
			defaultValue = TrainingDummyMinDist.GetValue() as Int
		EndIf
		SetSliderDialogDefaultValue(defaultValue)
		SetSliderDialogRange(TrainingDummyMinDist.GetValue(), 5000.0)
		SetSliderDialogInterval(10.0)
	ElseIf option == bonusIncrementSlider
		SetSliderDialogStartValue(TrainingDummyBonusIncr.GetValue())
		SetSliderDialogDefaultValue(defaultBonusIncr)
		SetSliderDialogRange(10.0, 500.0)
		SetSliderDialogInterval(10.0)
	ElseIf option == bonusXPSlider
		SetSliderDialogStartValue(TrainingDummyBonusXP.GetValue())
		SetSliderDialogDefaultValue(defaultBonusXP)
		SetSliderDialogRange(1.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == magicPerSecondSlider
		SetSliderDialogStartValue(TrainingDummyPerSecondXP.GetValue())
		SetSliderDialogDefaultValue(defaultPerSecond)
		SetSliderDialogRange(1.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == speechBaseXPSlider
		SetSliderDialogStartValue(TrainingDummySpeechBaseXP.GetValue())
		SetSliderDialogDefaultValue(defaultSpeechBaseXP)
		SetSliderDialogRange(1.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == speechVarXPSlider
		SetSliderDialogStartValue(TrainingDummySpeechVarXP.GetValue())
		SetSliderDialogDefaultValue(defaultSpeechVarXP)
		SetSliderDialogRange(1.0, 100.0)
		SetSliderDialogInterval(1.0)
	EndIf
EndEvent

Event OnOptionSliderAccept(Int option, Float value)
	If option == baseXPSlider
		TrainingDummyBaseXP.SetValue(value)
	ElseIf option == variableXPSlider
		TrainingDummyVariableXP.SetValue(value)
	ElseIf option == powerMultSlider
		TrainingDummyPowerMult.SetValue(value)
	ElseIf option == minimumDistSlider
		Bool ok = True
		If TrainingDummyBonusDist.GetValue() < value
			ok = ShowMessage("$TDXP_MINDISTWARNING2")
		EndIf
		If ok
			TrainingDummyBonusDist.SetValue(value)
			SetSliderOptionValue(bonusDistanceSlider, value)
			TrainingDummyMinDist.SetValue(value)
		Else
			value = TrainingDummyMinDist.GetValue()
		EndIf
	ElseIf option == bonusDistanceSlider
		TrainingDummyBonusDist.SetValue(value)
	ElseIf option == bonusIncrementSlider
		TrainingDummyBonusIncr.SetValue(value)
	ElseIf option == bonusXPSlider
		TrainingDummyBonusXP.SetValue(value)
	ElseIf option == magicPerSecondSlider
		TrainingDummyPerSecondXP.SetValue(value)
	ElseIf option == speechBaseXPSlider
		TrainingDummySpeechBaseXP.SetValue(value)
	ElseIf option == speechVarXPSlider
		TrainingDummySpeechVarXP.SetValue(value)
	EndIf
	SetSliderOptionValue(option, value)
EndEvent

Event OnOptionDefault(Int option)
	Float value
	If option == baseXPSlider
		value = defaultBaseXP
		TrainingDummyBaseXP.SetValue(value)
		SetSliderOptionValue(option, value)
	ElseIf option == variableXPSlider
		value = defaultVariableXP
		TrainingDummyVariableXP.SetValue(value)
		SetSliderOptionValue(option, value)
	ElseIf option == powerMultSlider
		value = defaultPowerMult
		TrainingDummyPowerMult.SetValue(value)
		SetSliderOptionValue(option, value)
	ElseIf option == warnTooCloseToggle
		TrainingDummyWarnTooClose.SetValue(1.0)
		SetToggleOptionValue(option, True)
	ElseIf option == minimumDistSlider
		value = defaultMinDistance
		TrainingDummyMinDist.SetValue(value)
		SetSliderOptionValue(option, value)
	ElseIf option == enableBonusToggle
		TrainingDummyBonusEnable.SetValue(1.0)
		SetToggleOptionValue(option, True)
		SetOptionFlags(bonusDistanceSlider, OPTION_FLAG_NONE)
		SetOptionFlags(bonusIncrementSlider, OPTION_FLAG_NONE)
		SetOptionFlags(bonusXPSlider, OPTION_FLAG_NONE)
	ElseIf option == bonusDistanceSlider
		value = defaultBonusDistance
		Bool ok = True
		If value < TrainingDummyMinDist.GetValue()
			value = TrainingDummyMinDist.GetValue()
			; ok = ShowMessage("The default value is less than current Minimum Distance. Bonus Distance will be set to " + value as Int)
			ok = ShowMessage("$TDXP_MINDISTWARNING3")
		EndIf
		If ok
			TrainingDummyBonusDist.SetValue(value)
			SetSliderOptionValue(option, value)
		EndIf
	ElseIf option == bonusIncrementSlider
		value = defaultBonusIncr
		TrainingDummyBonusIncr.SetValue(value)
		SetSliderOptionValue(option, value)	
	ElseIf option == bonusXPSlider
		value = defaultBonusXP
		TrainingDummyBonusXP.SetValue(value)
		SetSliderOptionValue(option, value)	
	ElseIf option == bashBlockToggle
		TrainingDummyBashBlockXP.SetValue(0.0)
		SetToggleOptionValue(option, False)
	ElseIf option == magicToggle
		TrainingDummyMagicXP.SetValue(1.0)
		SetToggleOptionValue(option, True)
		; ForcePageReset()
		SetOptionFlags(magicPerSecondSlider, OPTION_FLAG_NONE)
	ElseIf option == magicPerSecondSlider
		value = defaultPerSecond
		TrainingDummyPerSecondXP.SetValue(value)
		SetSliderOptionValue(option, value)	
	ElseIf option == speechToggle
		TrainingDummySpeechEnable.SetValue(1.0)
		SetToggleOptionValue(option, True)
		SetOptionFlags(speechBaseXPSlider, OPTION_FLAG_NONE)
		SetOptionFlags(speechVarXPSlider, OPTION_FLAG_NONE)
	ElseIf option == speechBaseXPSlider
		value = defaultSpeechBaseXP
		TrainingDummySpeechBaseXP.SetValue(value)
		SetSliderOptionValue(option, value)	
	ElseIf option == speechVarXPSlider
		value = defaultSpeechVarXP
		TrainingDummySpeechVarXP.SetValue(value)
		SetSliderOptionValue(option, value)	
	EndIf
EndEvent

Event OnOptionHighlight(Int option)
	If option == baseXPSlider
		; SetInfoText("The base experience added for a successful hit.\nDefault: " + defaultBaseXP)
		SetInfoText("$TDXP_DESC_BASEXP")
	ElseIf option == variableXPSlider
		; SetInfoText("The variable amount of experience added for a successful hit. In game this will be a random number ranging from 0 to the value specified here.\nDefault: " + defaultVariableXP)
		SetInfoText("$TDXP_DESC_VARXP")
	ElseIf option == powerMultSlider
		; SetInfoText("Multiplier for successful Power Attack. Currently the game does not register Power Attacks against dummies and targets but the setting remains here for possible future use.\nDefault: " + defaultBaseXP)
		SetInfoText("$TDXP_DESC_PWRMULT")
	ElseIf option == warnTooCloseToggle
		; SetInfoText("Show a warning if you are too close to the target or dummy to get archery experience.\nDefault: true")
		SetInfoText("$TDXP_DESC_TOOCLOSE")
	ElseIf option == minimumDistSlider
		; SetInfoText("The minimum distance you must be from the target or dummy in order to receive experience.\nDefault: " + defaultMinDistance)
		SetInfoText("$TDXP_DESC_MINDIST")
	ElseIf option == enableBonusToggle
		; SetInfoText("Enable or disable the awarding of bonus experience.\nDefault: true")
		SetInfoText("$TDXP_DESC_ENABLE")
	ElseIf option == bonusDistanceSlider
		; SetInfoText("The distance at which you begin to get awarded bonus experience.\nDefault: " + defaultBonusDistance)
		SetInfoText("$TDXP_DESC_BNSDIST")
	ElseIf option == bonusIncrementSlider
		; SetInfoText("Incremental distance past the bonus distance at which to award additional experience.\nDefault: " + defaultBonusIncr)
		SetInfoText("$TDSP_DESC_BNSINCR")
	ElseIf option == bonusXPSlider
		; SetInfoText("Amount of bonus experience to award per distance increment.\nDefault: " + defaultBonusXP)
		SetInfoText("$TDSP_DESC_BNSAMT")
	ElseIf option == bashBlockToggle
		; SetInfoText("Enable or disable the awarding of Block experience for for Bashing (dummies only).\nDefault: false")
		SetInfoText("$TDSP_DESC_BASHBLK")
	ElseIf option == magicToggle
		; SetInfoText("Enable or disable the awarding of experience for Destruction magic spells.\nDefault: true")
		SetInfoText("$TDSP_DESC_MAGIC")
	ElseIf option == magicPerSecondSlider
		; SetInfoText("Amount of bonus experience to award per second for spells that have a duration.\nDefault: " + defaultPerSecond)
		SetInfoText("$TDSP_DESC_MAGICAMT")
	ElseIf option == speechToggle
		SetInfoText("$TDSP_DESC_SPEECH")
	ElseIf option == speechBaseXPSlider
		SetInfoText("$TDXP_DESC_SPBASEXP")
	ElseIf option == speechVarXPSlider
		SetInfoText("$TDXP_DESC_SPVARXP")
	EndIf
EndEvent
