RegisterHook("/Script/Engine.PlayerController:ClientRestart", function(self, NewPawn)
    -- CHANGE THIS VALUE TO CHANGE THE CAP
    -- The cap is set to 290 to represent 32 traits with the 2 archetypes subtracted
    local MaxTraitPoints = 290
    
    local PlayerController = self:get()

    if not PlayerController:IsValid() or not PlayerController.Player:IsValid() or not PlayerController.Character:IsValid() or PlayerController:HasAnyInternalFlags(EInternalObjectFlags.PendingKill) then
        print("[TraitCap] PlayerController not found, could not change traits cap\n")
    end

    
    local CharacterFullName = PlayerController.Character:GetFullName()
    local CharacterStringTable = {}
    
    for i in CharacterFullName:gmatch("%S+") do
        table.insert(CharacterStringTable, i)
    end
    
    local TraitsComponent = StaticFindObject(string.format("%s.Traits", CharacterStringTable[#CharacterStringTable]))
    if not TraitsComponent:IsValid() then print("[TraitCap] RemnantTraitsComponent not found, could not change traits cap\n") return end

    TraitsComponent.MaxTraitPoints = MaxTraitPoints
    
end)
