PrefabFiles = {
	"trunk_case",
}

Assets = {
	Asset("ATLAS", "images/inventoryimages/trunk_case.xml"),
}

STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH

STRINGS.NAMES.TRUNK_CASE = "Trunk Case"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TRUNK_CASE = "A portable chest"
STRINGS.RECIPE_DESC.TRUNK_CASE = "A portable chest"


-- regist as starting items
if GetModConfigData("trunk_case_startingtItem") then
	print("---- trunc_case modmain, registed as starting items.")
	if GLOBAL.TUNING.TEMIRUYA_STARTINGITEMS == nil then
		GLOBAL.TUNING.TEMIRUYA_STARTINGITEMS = {}
	end
	GLOBAL.TUNING.TEMIRUYA_STARTINGITEMS[1862555886] = "trunk_case"
end


-- regist to recipe and container UI
local dx, dy, px, py
local trunkSize = GetModConfigData("trunk_case_size") or 2
if trunkSize == 1 then
	dx = -7
	dy = -4
	px = 450
	py = 350
	align = 300
	GLOBAL.Recipe("trunk_case", {Ingredient("boards", 4)}, RECIPETABS.SURVIVAL, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/trunk_case.xml", "trunk_case.tex")
elseif trunkSize == 2 then
	dx = 0
	dy = 0
	px = 300
	py = 200
	GLOBAL.Recipe("trunk_case", {Ingredient("cutstone", 20), Ingredient("goldnugget", 2), Ingredient("boards", 20)}, RECIPETABS.SURVIVAL, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/trunk_case.xml", "trunk_case.tex")
else
	dx = 10
	dy = 0
	px = 50
	py = 200
	GLOBAL.Recipe("trunk_case", {Ingredient("cutstone", 20), Ingredient("goldnugget", 2), Ingredient("boards", 20)}, RECIPETABS.SURVIVAL, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/trunk_case.xml", "trunk_case.tex")
end
    
_G = GLOBAL
local params={} 
params.trunk_case = {
    widget = {
        slotpos = {},
        pos = _G.Vector3(px, py, 0),
        side_align_tip = 0,
    },
    type = "chest",
}

for y = 6.5+dy, -0.5, -1 do
    for x = 0, 9+dx do
        table.insert(params.trunk_case.widget.slotpos, _G.Vector3(75 * x - 75 * 12 + 75, 75 * y - 75 * 6 + 75, 0))
    end
end
local containers = _G.require "containers"
containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, params.trunk_case.widget.slotpos ~= nil and #params.trunk_case.widget.slotpos or 0)
local old_widgetsetup = containers.widgetsetup

function containers.widgetsetup(container, prefab, data)
    local pref = prefab or container.inst.prefab
    if pref == "trunk_case" then
        local t = params[pref]
        if t ~= nil then
            for k, v in pairs(t) do
                container[k] = v
            end
            container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        end
    else
--        return old_widgetsetup(container, prefab)
        return old_widgetsetup(container, prefab, data)
    end
end
