require "prefabutil"

local assets=
{
    Asset("ANIM", "anim/trunk_case.zip"),
    Asset("ATLAS", "images/inventoryimages/trunk_case.xml"),
    Asset("IMAGE", "images/inventoryimages/trunk_case.tex"),
}


local function onPickup(inst)
    inst.components.container:Close()
end


local function onDropped(inst, owner)
    inst.components.container:Close()
end


local function onWalk(inst)
--	print("---- trunk_case onWalk(), inst is "..inst.prefab)
	if not inst.components.locomotor.wantstomoveforward then return end

	if inst.opend_trunk_case then
		local container = inst.opend_trunk_case.components.container
		if container.opener then
    		container:Close()
		end
	end
end


local function onOpen(inst, data)
	local opener = data.doer 
--	print("---- trunk_case onOpen(), opener is "..opener.prefab)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")		
    inst.AnimState:PlayAnimation("opened")

    opener.opend_trunk_case = inst
    inst:ListenForEvent("locomote", onWalk, opener)
end 

local function onClose(inst, opener)
--	print("---- trunk_case onClose(), opener is "..opener.prefab)
	inst.AnimState:PlayAnimation("closed")
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")		

    inst:RemoveEventCallback("locomote", onWalk, opener)
    opener.opend_trunk_case = nil
end 


local function fn(Sim)
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    if not TheWorld.ismastersim then
    return inst
    end

    inst.entity:SetPristine()	

    inst.AnimState:SetBank("trunk_case")
    inst.AnimState:SetBuild("trunk_case")
    inst.AnimState:PlayAnimation("closed")

    inst:AddTag("trunk_case")

    MakeInventoryFloatable(inst, "med", 0.1)
    
    inst:AddComponent("inspectable")

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("trunk_case")    
    inst.components.container.onopenfn = onOpen
    inst.components.container.onclosefn = onClose

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/trunk_case.xml"
    inst.components.inventoryitem:SetOnDroppedFn(onDropped)
    inst.components.inventoryitem:SetOnPickupFn(onPickup)

    return inst
end

return Prefab( "common/trunk_case", fn, assets)