# -*- coding: utf-8 -*-
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from ..extractor.cbssports import CBSSportsIE as CBSSportsBase

class CBSSportsIE(CBSSportsBase):
    def _extract_video_info(self, filter_query, video_id):
        return self._extract_feed_info('dJ5BDC', 'VxxJg8Ymh8sE', filter_query, video_id)

    def _real_extract(self, url):
        try:
            return super(CBSSportsIE, self)._real_extract(url)
        except Exception as ex:
            pass

        video_id = self._get_video_id(url)
        if not video_id:
            video_id = self._match_id(url)
        return self._extract_video_info('byId=%s' % video_id, video_id)

    def _get_video_id(self,url):
        response = self._request_webpage(url, 'get cbssports video id')
        body = response.read()
        videoId = self._search_regex(
                                r'pcid\%3D([\d]+)\%26',
                                body, 'get videoId', default='')
        return videoId

