# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re

import json

import hashlib

from ..extractor.common import (
    InfoExtractor,
)
from ..extractor.lynda import (
    LyndaBaseIE,
    LyndaIE as OldLyndaIE
)

from ..utils import (
    int_or_none,
    ExtractorError,
    qualities,
    js_to_json
)

from ..utilsEX import downloadWebPage_BYHeadlessBrowser_localFile

class daftsexIE(InfoExtractor):
    #https://edu.51cto.com/course/21671.html
    _VALID_URL = r'https?://(?:www\.)?daftsex\.com/watch/(?P<id>.+)'

    def FindServer(self, video, encrypted_server):
        srvs = {'SM':'1','iM':'2','yM':'3','CN':'4','SN':'5',
                'cTM':'17','AjM':'20','MDN':'43','UDN':'45','YDN':'46','cDN':'47','gDN':'48','ATN':'50','ETN':'51','ITN':'52','QTN':'54','MjN':'63',
                'QjN':'64','UjN':'65','YjN':'66','cjN':'67', 'gjN':'68','kjN':'69'}

        if encrypted_server.startswith('1JnLkV3bsNWe6Fmcj5'):
            srv = 'https://psv' + srvs[encrypted_server[21:24]] + '-' + srvs[encrypted_server[18:20]] + '.crazycloud.ru'
            return srv + '/videos/' + video
                                        
        if encrypted_server.startswith('=02bj5iYhhXYk5'):
            srv = 'https://psv' + srvs[encrypted_server[17:20]] + '-' + srvs[encrypted_server[14:16]] + '.daxab.com'
            return srv + '/videos/' + video

        crazycloud_list = ['17-1','17-2','17-3','20-1','20-2','20-3']
        daxab_list = ['12-1','17-4','20-5','32-1','33-1','43-1','45-1','46-1','47-1','48-1','50-1','51-1','52-1','53-1','54-1','55-1','56-1','57-1','58-1','59-1','60-1','63-1','64-1','65-1','66-1','67-1','68-1','68-2','69-1','69-2','69-3','69-4']
        
        if len(encrypted_server)>25:
            i = 1
            for srv in crazycloud_list:
                server = 'https://psv' + srv + '.crazycloud.ru'
                #vp.progress.update(25 + i, "", "Searching on crazycloud.ru ... " + srv, "")
                try:
                    code = urllib2.urlopen(server + '/videos/' + video, timeout = 1).getcode()
                    if code == 200:
                        with open(server_txt, 'a') as f:
                            f.write(encrypted_server + '#' + server +'\r\n')
                        return (server + '/videos/' + video)
                except:
                    i = i+1
        else:
            i = 1
            for srv in daxab_list:
                server = 'https://psv' + srv + '.daxab.com'
                #vp.progress.update(25 + i, "", "Searching on daxab.com ... " + srv, "")
                try:
                    code = urllib2.urlopen(server + '/videos/' + video, timeout = 0.5).getcode()
                    if code == 200:
                        with open(server_txt, 'a') as f:
                            f.write(encrypted_server + '#' + server +'\n')
                        return (server + '/videos/' + video)
                except:
                    i = i+1
        #utils.kodilog('not found ' + video)



    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, url)
        title = self._html_search_regex(r'<h1.+>(.+)</h1>', webpage, 'title', fatal=True)
        if not title:
            title = self._search_regex(r'<title>(.+)</title>', webpage, 'video title')

        ebm_url = self._search_regex(r'<iframe.+src="(https://daxab\.com/player/[^"]+)"', webpage, 'ebm_url')
        ebm_webpage = self._download_webpage(ebm_url, ebm_url, headers={'referer': url})
        ebm_json_str = self._search_regex(r'window\.globParams\s*=\s*(\{[\s\S]+?\});', ebm_webpage, 'ebm_url').replace('\n','')
        data = json.loads(js_to_json(ebm_json_str))
        formats = []
        
        for key, cdn_file in data['video']['cdn_files'].items():
            ext, width = key.split('_')
            cdn_file = cdn_file.replace(width + '.', width + '.' + ext + '?extra=') 
            video_url = '%s/%s' % (data['video']['cdn_id'].replace('_', '/') , cdn_file)
            video_url = self.FindServer(video_url, data['server'])
            formats.append({
                'width': width, 
                'url': video_url,
                'ext': ext
            })

        self._sort_formats(formats)
        return {
            'id': video_id,
            'title': title,
            'formats': formats
        }