#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse, compat_urllib_parse_unquote
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
    unescapeHTML
)
from ..utilsEX import (
    url_result
)

class edddhIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?edddh\.com/vod/.+/.+$'

    def _real_extract(self, url):
        video_id = 'edddhID'
        webpage = self._download_webpage(url, '')
        title = self._html_search_regex(r'<title>(.+)</title>', webpage, '')
        info_str =  self._search_regex(r'<script>var zanpiancms_player\s*=\s*(.+)?;</script>', webpage, '123123', fatal=False)
        info = self._parse_json(info_str, video_id)        
        webpage = self._download_webpage('http://m3u8.yyd.me/3hzl.php?vd=' + info['url'], '', headers = {'Referer': 'http://www.edddh.com/'})
        video_url = self._search_regex(r'var\s+urla\s*=\s*"([^"]+)', webpage, '')
        video_url = video_url.replace('\\u0026', '&')
        # video_url = compat_urllib_parse_unquote(video_url).replace('pxlato','dl106')        
        return {
            'id': video_id,
            'formats': [{
                    'url': video_url,
                    'ext': 'mp4'
                    }],
            'title': title,
        }            
        
class edddhEpisodeIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?edddh\.com/vod/(?P<id>.+)/$'

    def _real_extract(self, url):
        playlist_id = self._match_id(url)
        webpage = self._download_webpage(url, '')
        title = self._html_search_regex(r'<title>(.+)</title>', webpage, '')

        webpage = self._search_regex('<ul class="clearfix fade in active"  id="con_playlist_1">(.+?)</ul>', webpage, '')
        items = re.findall('href\="(.+?)">(.+?)</a>', webpage)
        entries = []
        items.reverse()
        for item in items:
            entries.append(url_result('http://www.edddh.com{0}'.format(item[0]), 'edddh', item[1], item[1], '45:00'))
        
        return {
            '_type': 'playlist',
            'id': playlist_id,
            'title': title,         
            'entries': entries,
        }        