# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
from ..extractor.common import InfoExtractor


class gotowebinarlIE(InfoExtractor):
    IE_NAME = 'gotowebinar.com'
    _VALID_URL = r'.*\.gotowebinar\.com/recording'
    def _real_extract(self, url):
        obj = re.search(r'viewRecording/([^/]+)?/([^/]+)?/.+registrantKey=([^&]+).+type=([^&]+)?', url)
        temp = 'https://api.services.gotomeeting.com/registrationservice/api/v1/webinars/{0}/registrants/{1}/recordingAssets?type={2}&client=spa'.format(obj.groups()[0], obj.groups()[2],obj.groups()[3])
        data = self._download_json(temp, '')
        return {
            'id': obj.groups()[3],
            'title': obj.groups()[3],
            'formats': [{
                'url': data['cdnLocation'],
            }],
        }
