#coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import hashlib
import hmac
import re
import time
import uuid

from ..compat import (
    compat_HTTPError,
    compat_str,
)

from ..extractor.hotstar import HotStarIE as OldIE

class HotStarIE(OldIE):

    def _call_api_impl(self, path, video_id, query):
        guest_user_token = self._get_cookies('https://www.hotstar.com/').get('guest_user_token').value
        st = int(time.time())
        exp = st + 6000
        auth = 'st=%d~exp=%d~acl=/*' % (st, exp)
        auth += '~hmac=' + hmac.new(self._AKAMAI_ENCRYPTION_KEY, auth.encode(), hashlib.sha256).hexdigest()
        response = self._download_json(
            'https://api.hotstar.com/' + path, video_id, headers={
                'hotstarauth': auth,
                'x-hs-usertoken': guest_user_token, 
                'x-country-code': 'IN',
                'x-hs-platform': 'web',
                'x-hs-appversion': '6.70.1',
            }, query=query)
        return response['data']

    def _call_api(self, path, video_id, query_name='contentId'):
        return self._call_api_impl(path, video_id, {
            query_name: video_id,
            'tas': 10000,
        })

    def _call_api_v2(self, path, video_id):            
        return self._call_api_impl(
            'play/v1/playback/content/%s?os-name=Windows&os-version=10&desired-config=audio_channel:stereo|encryption:widevine|ladder:tv|package:dash|video_codec:vp9&device-id=%s' % 
                (video_id, compat_str(uuid.uuid4())), video_id, query={})

    def _real_extract(self, url):
        result = super(HotStarIE, self)._real_extract(url)

        # hdntl = self._get_cookies('https://hotstar.com').get('hdntl').value
        # formats = result['formats']
        # for f in formats:
        #     f['http_headers'].update({'hdntl': hdntl})

        return result
        
        
