#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from ..extractor.howcast import HowcastIE as HowcastIEBase
from ..utils import parse_iso8601

class HowcastIE(HowcastIEBase):

    def _real_extract(self, url):
        try:
            return super(HowcastIE, self)._real_extract(url)
        except Exception as ex:
            pass

        video_id = self._match_id(url)
        webpage = self._download_webpage(url, video_id)

        try:
            embed_code = self._search_regex(
                r'<iframe[^>]+src="[^"]+\bembed_code=([^\b]+)\b',
                webpage, 'ooyala embed code')

            return {
                '_type': 'url_transparent',
                'ie_key': 'Ooyala',
                'url': 'ooyala:%s' % embed_code,
                'id': video_id,
                'timestamp': parse_iso8601(self._html_search_meta(
                    'article:published_time', webpage, 'timestamp')),
            }
        except Exception as ex:
            _url = self._search_regex(
                r'<(?:phoenix-)?iframe[^>]+src="([^"]+)"',
                webpage, 'youtube embed code')
            return self.url_result(_url)