#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys 
import threading

try:
    import Queue
except:
    
    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url,
    ExtractorError,
    xpath_text
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs,
    compat_xpath
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, downloadWebPage_BYHeadlessBrowser_localFile

class Jin10IE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?jin10\.com/'

    def _real_extract(self, url):
        print('jin10 begin')
        webpage = self._download_webpage(url, 'embVideo_url')
        title = self._search_regex(r'<title>(.+)</title>', webpage, '', fatal=False) or 'title'
        js = '''function output(txt){
                        if (window.external){
                            window.external.output(txt);
                        }
                        if (window.WebViewJavascriptBridge){
                            window.WebViewJavascriptBridge.callHandler('JSSendToOC', txt);
                        }
        }
        var vf = document.getElementById("J_videoBox");
        if  (vf){
            var v_url = vf.getAttribute("data-video-url");
            var p_url = vf.getAttribute("data-poster-url");
            output('<video id="kv_player" src="' + v_url + '" thumbnail="' + p_url + '" />');
        }'''
            #var title = document.title;	
            #output('<video id="kv_player" src= "' + v_url + '" thumbnail="' + p_url + '" title="' + title + '" />');	
        print('jin10 normal')
        webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)
        if 'kv_player' in webpage:
            embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')
            formats = []
            formats.append({
                'format_id': 'asnuf',
                'url': embVideo_url,
            })
            return {
                '_type': 'video',
                'url': embVideo_url,
                'ie_key': Jin10IE.ie_key(),
                'id': 'asd',
                'formats': formats,
                'title': title,
            }    
        else: 
            return self._hx_extract(url, js)