#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
)

class JWIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?jw\.org/'

    def _real_extract(self, url):
        webpage = self._download_webpage(url, '', headers={
                'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36',
            })
        json_url = self._search_regex(r'data-jsonurl=(?:"|\')([^\'|^"]+)?', webpage, '123123', fatal=False)
        if not json_url:
            video_id = self._search_regex(r'((pub|docid).+?VIDEO)', url, 'id')
            json_url = 'https://data.jw-api.org/mediator/v1/media-items/S/{0}?clientType=www'.format(video_id)
            response = self._download_json(json_url,'', 'Downloading course curriculum')
            media = response['media'][0]
            formats = []
            for file in media['files']:
                formats.append({
                    'width': int_or_none(file.get('frameWidth')),
                    'height': int_or_none(file.get('frameHeight')),
                    'url': file['progressiveDownloadURL'],
                    'ext': 'mp4'
                })
            return {
                'id': 'video_id',
                'formats': formats,
                'title': media['title'],
            }            
        else:
            response = self._download_json(json_url,'', 'Downloading course curriculum')
            formats = []
            files = response['files']['E']
            title = None
            if files.get('MP4', None):
                title = files.get('MP4', None)[0]['title']
                for file in files.get('MP4', None):
                    formats.append({
                        'width': int_or_none(file.get('frameWidth')),
                        'height': int_or_none(file.get('frameHeight')),
                        'url': file['file']['url'],
                        'ext': 'mp4'
                    })
            
            if files.get('MP3', None):
                title = title if title else files.get('MP3', None)[0]['title']
                for file in files.get('MP3', None):
                    formats.append({
                        'width': 0,
                        'height': 0,
                        'url': file['file']['url'],
                        'ext': 'mp3'
                    })

            self._sort_formats(formats)

            return {
                'id': 'video_id',
                'formats': formats,
                'title': title,
            }
