# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys 
import threading

try:
    import Queue
except:
    
    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url,
    HEADRequest
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, downloadWebPage_BYHeadlessBrowser_localFile

class KissanimeIE(InfoExtractor):

    _VALID_URL = r'https?://(?:.+\.)?(?:kissanime|kisscartoon)\.(?:io|ru|so|me|ac|info|nz|love|to)'

    def _real_extract(self, url):
        #curl "https://kisscartoon.nz/ajax/anime/load_episodes_v2?s=oserver" -H "origin: https://kisscartoon.nz" --data "episode_id=7213"
        url = url.replace('.ru/', '.ac/').replace('.so', '.ac').replace('.io', '.ac').replace('.eu', '.ac')
        id = self._search_regex(r'id=(\d+)', url, '')
        headers = {'content-type': 'application/x-www-form-urlencoded; charset=UTF-8','referer': url}
        parsed_sub_url = compat_urllib_parse_urlparse(url)
        post_data = 'episode_id=%s' % id
        post_data = post_data.encode('utf-8')
        data = self._download_json('https://%s/ajax/anime/load_episodes_v2?s=ptserver' % parsed_sub_url.netloc, '', data=post_data, headers=headers)
        if not data['status']:
            data = self._download_json('https://%s/ajax/anime/load_episodes_v2?s=oserver' % parsed_sub_url.netloc, '', data='episode_id=%s' % id, headers=headers)
        headers = {'referer': url}
        try:
            if data['value']:
                data = self._download_json(data['value'], '', headers=headers)
                formats = []
                thumbnail = data['playlist'][0].get('image', '')
                if 'file' in data['playlist'][0]:
                    formats.append({
                        'url': data['playlist'][0]['file']
                    })
                else:
                    for source in data['playlist'][0]['sources']:
                        formats.append({
                            'quality': source['label'].strip('p'),
                            'ext': source['type'],
                            'url': source['file']
                            })
                return {
                    'id': id,
                    'title': self._search_regex(r'(?:Anime|Cartoon)/(.+?)\?id=(\d+)', url, ''),
                    'thumbnail': thumbnail,
                    'formats': formats,
                }
            elif data['download_get']:
                data = self._download_json(data['value'], '', headers=headers)
                video_url = data['playlist'][0]['file']
                return {
                    'id': id,
                    'title': self._search_regex(r'(?:Anime|Cartoon)/(.+?)\?id=(\d+)', url, ''),
                    'url': video_url,
                }
            else:
                raise Exception('1213')
        except Exception as ex:
            print(ex)

class kissasianIE(InfoExtractor):
    
    _VALID_URL = r'https?://(?:.+\.)?kissasian\.sh/.+\?id=(\d+)'

    def _hx_extract(self, url, js):
        print('kissasian hx begin')
        domain = 'kissasian.sh'
        webpage = downloadWebPage_BYHeadlessBrowser_withJS(url + '&s=hx', js)         
        embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url') 
        title = self._search_regex(r'alt="([^"]+)"', webpage, 'video_url')                                
        apiKey, _type, value = re.findall(r'/hdx\.aspx\?apiKey=(?P<apiKey>.+)&type=(?P<type>.+)&value=(?P<value>.+)', embVideo_url)[0]            
        webpage = self._download_webpage('https://multi.idocdn.com/vip', value, data=urlencode_postdata({'key': apiKey, 'type': _type, 'value': value}))
        keyAndIV = re.findall(r'hd.+?"hash":"(.+?)".+?"iv":"(.+?)"', webpage)
        if not keyAndIV:
            keyAndIV = re.findall(r'sd.+?"hash":"(.+?)".+?"iv":"(.+?)"', webpage)
        key, iv = keyAndIV[0]
        jsTemplte = '<script>var obj = ' + webpage + '''
        function get(t, e) {
                var n = "#EXTM3U\\n#EXT-X-VERSION:4\\n#EXT-X-PLAYLIST-TYPE:VOD\\n#EXT-X-TARGETDURATION:" + t.duration + "\\n#EXT-X-MEDIA-SEQUENCE:0\\n";
                void 0 !== t.hash && t.hash && (n += "#EXT-X-HASH:" + t.hash + "\\n");
                var i = 0,
                r = 0,
                o = t.id || null,
                a = t.ids || null,
                c = t.expired || t.sig || null,
                s = t.datas || null,
                u = t.ranges || null,
                l = u ? u.length : 0;
                if (s) {
                    o = e.length;
                    for (var h = 0; h < l; h++) {
                        for (var f, d = s[h].file, p = 0; p < u[h].length; p++) {
                            var y = l <= h + p + 1 ? l <= p + 1 ? s[0].file : s[p + 1].file : s[h + p + 1].file;
                            i < o ? (f = e[i], i++) : (i = 1, f = e[0]),
                            a = u[h][p],
                            f = "https://" + f,
                            n += "#EXTINF:" + t.extinfs[r] + ",\\n",
                            n += "#EXT-X-BYTERANGE:" + a + "\\n",
                            n = c ? n + (f + "/") + c + "/" + d + "/" + a + "/" + y + "\\n" : n + (f + "/") + r + "/" + d + "/" + a + "/" + y + "\\n",
                            r++
                        }
                        l == h + 1 && (n += "#EXT-X-ENDLIST")
                    }
                } else if (a){
                    if (u)
                        for (h = 0; h < l; h++) {
                            for (d = a[h], p = 0; p < u[h].length; p++)
                                y = l <= h + p + 1 ? l <= p + 1 ? a[0] : a[p + 1] : a[h + p + 1], "object" == typeof e.redirect ? i < e.redirect.length ? (s = e.redirect[i], i++) : (i = 1, s = e.redirect[0]) : s = e.redirect, n += "#EXTINF:" + t.extinfs[r] + ",\\n", 1 < u[h].length && (n += "#EXT-X-BYTERANGE:" + u[h][p] + "\\n"), n += "https://" + s + "/redirect/" + c + "/" + o + "/" + d + "/" + y + "\\n", r++;
                            l == h + 1 && (n += "#EXT-X-ENDLIST")
                        }
                    else{
                        for (h = 0; h < a.length; h++)
                            d = a[h], y = a.length <= h + 1 && a.length <= h + 1 ? a[0] : a[h + 1], "object" == typeof e.redirect ? i < e.redirect.length ? (s = e.redirect[i], i++) : (i = 1, s = e.redirect[0]) : s = e.redirect, n += "#EXTINF:" + t.extinfs[r] + ",\\n", n += "https://" + s + "/redirect/" + c + "/" + o + "/" + d + "/" + y + "\\n", r++, a.length == h + 1 && (n += "#EXT-X-ENDLIST");
            }
            }
            if(window.external){
                window.external.output('<MyManifest>' + n + '</MyManifest>');
            }else{
                window.WebViewJavascriptBridge.callHandler('JSSendToOC','<MyManifest>' + n + '</MyManifest>');
            }
        }
        key  = 'hd' in obj ? 'hd' : 'sd'
        get(obj[key],obj['servers']);
        </script>'''

        webpage = downloadWebPage_BYHeadlessBrowser_localFile(jsTemplte)
        m3u8doc = self._search_regex(r'<MyManifest>([\s\S]+)<\/MyManifest>', webpage, 'm3u8doc')  
        m3u8doc = m3u8doc.replace('\n#EXTINF','\n#EXT-X-KEY:METHOD=AES-128,KEY="%s",IV="%s"\n#EXTINF' %(key, iv))
        #part_urls = re.findall('#EXT-X-BYTERANGE\:(\d+)@(\d+)[\s\S]+?(https://.+?)\n', m3u8doc)
        part_urls = re.findall('(#EXT-X-KEY[\s\S]+?http.+)\n', m3u8doc)
        
        parts = []
        for idx, item in enumerate(part_urls):                
            part_url = re.findall('(https.+)', item)[0]
            part = {
                'id': idx,
                'title': 'part%d' % idx,
                'url': part_url,
                'http_headers': {
                    'origin': 'https://kissasian.sh',
                },
                'ext': 'ts',
                'decryptMethod': 'aes-128',
                'key': key,
                'iv' : iv,
                'filesize': 1024*1024*2
            }
            query_range = re.findall('#EXT-X-BYTERANGE\:(\d+)@(\d+)', item)
            if query_range:
                part['http_headers']['range'] = 'bytes=%s-%s' % (query_range[0][1], int(query_range[0][1]) + int(query_range[0][0]))                    

            parts.append(part)
            
        self._downloader.params['playlistend'] = -1
        print('kissasian hx end')
        return {
            '_type': 'multi_video',
            'id': 'v_id',
            'title': title,
            'entries': parts,       
        } 

    def _real_extract(self, url):
        print('kissasian begin')
        url = self._search_regex(r'(.+id=\d+)', url, 'url')
        js = '''var vp = document.getElementById('my_video_1'); if (vp && vp.src) { window.external.output('<video id="kv_player" src="' + vp.src + '" alt="' + document.title + '" />'); } else { window.external.output('nothing...'); }'''
        if sys.platform != 'win32':
            js = '''var vp = document.getElementById('video');
                    if (window.WebViewJavascriptBridge && vp && vp.src) { 
                        window.WebViewJavascriptBridge.callHandler('JSSendToOC','<video id="kv_player" src="' + vp.src + '" alt="' + document.title + '" />'); 
            }'''
        print('kissasian normal')
        webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)
        if 'kv_player' in webpage:
            embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')
            title = self._search_regex(r'alt="([^"]+)"', webpage, 'video_url')
            webpage = self._download_webpage(embVideo_url, 'embVideo_url') 
            v_id = self._search_regex(r'gaobook.review/v/(.+)', embVideo_url, 'v_id', fatal = False)
            if v_id:
                jsondata = self._download_json("https://www.gaobook.review/api/source/%s" % v_id, v_id, data=urlencode_postdata({'d': 'www.gaobook.review'}))
                            
                formats = [{
                    'format_id': item['label'].strip(),
                    'url': item['file'],
                    'width': item['label'].strip(),
                    'ext': item['type']
                } for item in jsondata['data']]   
                print('kissasian end')         
                return {
                    'id': v_id,
                    'title': title,
                    'formats': formats,                
                }            
        else: 
            return self._hx_extract(url, js)

class kisscartoonIE(InfoExtractor):
    _VALID_URL = r'https?://(?:.+\.)?kisscartoon\.(?:xyz|info)/'    


    def _getEntries(self, m3u8Doc, host_url, http_headers):

        entries = []   
        part_urls = re.findall('(#EXTINF[\s\S]+?)\n#(?:EXTINF|EXT-X-ENDLIST)', m3u8Doc)     
        for idx, item in enumerate(part_urls):                
            fileName = re.findall('ch\=([^&]+)', item)[0]
            mid = fileName.split('-')[0]
            part_url = '%s/getChunkLink?chunkFile=%s&mid=%s' %(host_url, fileName,mid)            
            part = {
                'id': idx,
                'title': 'part%d' % idx,
                'url': part_url,
                'http_headers': http_headers.copy(),
                'ext': 'ts',
                'decryptMethod': 'aes-128',
                'key': '',
                'iv' : '',
                'filesize': 1024*1024*2,
                'needQueryRedirect': True
            }
            query_range = re.findall('#EXT-X-BYTERANGE\:(\d+)@(\d+)', item)
            if query_range:
                part['http_headers']['range'] = 'bytes=%s-%s' % (query_range[0][1], int(query_range[0][1]) + int(query_range[0][0]))                    
            part['filesize'] = int(query_range[0][0])
            entries.append(part)
        return entries  
         
    def _real_extract_drive1(self, url):
        return self._real_extract_method1(url, 'drive1')

    def _real_extract_vip(self, url):    
        formats = []
        try:
            video_id = self._search_regex(r'there\.to/v/(.+)', url, 'embVideo_url')
            if video_id:
                jsondata = self._download_json('https://there.to/api/source/%s' % video_id, video_id, data=urlencode_postdata({'d': 'there.to'}))                                                                
                formats = [{
                    'format_id': item['label'].strip(),
                    'url': item['file'],
                    'width': item['label'].strip(),
                    'ext': item['type']
                } for item in jsondata['data']]         
                return {
                    'id': video_id,
                    'title': self.title,
                    'formats': formats,                
                }  
        except:
            return []  

    def _real_extract_rapidvideo(self, url):    
        try:
            
            webpage = downloadWebPage_BYHeadlessBrowser_withJS(url + '?server=rapidvideo', self.js % 'rapidvideo')
            if 'kv_player' not in webpage:
                return []
            title = self._search_regex(r'alt="([^"]+)"', webpage, 'video_url')             
            embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')  
            webpage = self._download_webpage(embVideo_url, embVideo_url, headers={'referer': url + '?server=rapidvideo'})           
            key, _type, value = re.findall(r'new Player\({"key":"(.+)","type":"(.+)","value":"(.+?)"', webpage)[0]            
            ie = idocdnVIPIE()
            ie.set_downloader(self._downloader)
            result = ie._real_extract(smuggle_url('https://multi.idocdn.com/vip', {'key':key, 'type': _type, 'value': value, 'origin': compat_urllib_parse_urlparse(url).netloc}))
            result['title'] = title
            return result
        except:
            return []    

    def _real_extract_comedyshow(self, url):
        webpage = self._download_webpage(url, url, fatal=False) 
        if webpage and webpage.find('No file') == -1:
            video_id = self._search_regex(r'<iframe src=\"https\://www\.fembed\.net/v/([^"]+)"', webpage, '')
            link ='https://feurl.com/api/source/%s' % video_id
            data = urlencode_postdata({'r': '', 'd': 'feurl.com'})
            jsondata = self._download_json(link, link, data=data)
            formats = [{
                    'format_id': item['label'].strip(),
                    'url': item['file'],
                    'width': item['label'].strip(),
                    'ext': item['type']
                } for item in jsondata['data']]         
            return {
                'id': video_id,
                'title': self.title,
                'formats': formats,                
            }  
            
        return None

    def _real_extract_cartoonwire(self, url):
        webpage = self._download_webpage(url, url, fatal=False) 
        if webpage and webpage.find('No file') == -1:
            return self._real_extract_zmovies(url)
        return None        

    def _real_extract_comicsonline(self, url):
        video_id = self._search_regex(r'html\?id\=(\w+)', url, 'video_id', fatal=False)
        if video_id:
            formats = []
            
            host_url = self._search_regex(r'(http(?:s*)://[^/]+)', url, 'host_url')        
            linkUrl = '%s/getLinkStreamMd5/%s' % (host_url, video_id)
            obj = self._download_json(linkUrl, linkUrl, fatal=False)                                                                    
            if not obj: return None
            
            formats = [{
                    'format_id': item['label'].strip(),
                    'url': item['file'],
                    'width': item['label'].strip(),
                    'ext': item['type']
            } for item in obj]  

            return {
                'id': video_id,
                'title': self.title,
                'formats': formats,                
            }                               

        return None

    def _real_extract_hydrax(self, url):
        
        headers = {'Referer': url}
        webpage = self._download_webpage('https://ping.hqdfgihyum.monster/ping.gif', '', headers=headers)
        video_url = 'https://hqdfgihyum.monster/'
        obj = self._request_webpage(HEADRequest(video_url), video_url, headers=headers, fatal = False)
        if obj:# self._is_valid_url(video_url, video_url, headers=headers):        
            return {
                    'id': '123',
                    'title': self.title,
                    'formats': [{
                            'url': 'https://hqdfgihyum.monster/',
                            'http_headers': headers,
                            'ext': 'mp4'
                        }
                    ],                
            }           
        return None

    def _real_extract_zmovies(self, url):
        video_id = self._search_regex(r'html\?id\=(\w+)', url, 'video_id', fatal=False)
        if video_id:
            formats = []
            
            host_url = self._search_regex(r'(http(?:s*)://[^/]+)', url, 'host_url')
            playlist_url = '%s/hls/%s/%s.playlist.m3u8' % (host_url, video_id, video_id)
            request = sanitized_Request(playlist_url, headers={'referer': url})
            formats.extend(self._extract_m3u8_formats(request, video_id, 'mp4', m3u8_id='hls', fatal=False))
            if formats:
                self._sort_formats(formats, ('width'))
                formats.reverse()
                for f in formats:
                    webpage = self._download_webpage(f['url'], url, headers={'referer': url}) 
                    urls = re.findall(r'(/drive/hls/.+)', webpage)
                    if urls:
                        parts = self._getEntries(webpage, host_url, {'referer': url})

                        self._downloader.params['playlistend'] = -1            
                        return {
                            '_type': 'multi_video',
                            'id': 'v_id',
                            'title': self.title,
                            'entries': parts,       
                        }                  
        return None
    
    def _real_extract_method1(self, url, server):    
        formats = []
        try:
            webpage = downloadWebPage_BYHeadlessBrowser_withJS(url + '?server=%s' % server, self.js % server)
            
            if 'kv_player' in webpage:
                embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')
                title = self._search_regex(r'alt="([^"]+)"', webpage, 'video_url')
                if embVideo_url.find('html?id=') > -1:
                    video_id = self._search_regex(r'html\?id\=(\w+)', webpage, 'video_id')
                    host_url = self._search_regex(r'(http(?:s*)://[^/]+)', webpage, 'host_url')
                    playlist_url = '%s/hls/%s/%s.playlist.m3u8' % (host_url, video_id, video_id)
                    request = sanitized_Request(playlist_url, headers={'referer': embVideo_url})
                    formats.extend(self._extract_m3u8_formats(request, video_id, 'mp4', m3u8_id='hls', fatal=False))
                    if formats:
                        self._sort_formats(formats, ('width'))
                        formats.reverse()
                        for f in formats:
                            webpage = self._download_webpage(f['url'], embVideo_url, headers={'referer': embVideo_url}) 
                            urls = re.findall(r'(/drive/hls/.+)', webpage)
                            if urls:
                                parts = self._getEntries(webpage, host_url, {'referer': embVideo_url})

                                self._downloader.params['playlistend'] = -1            
                                return {
                                    '_type': 'multi_video',
                                    'id': 'v_id',
                                    'title': title,
                                    'entries': parts,       
                                }                 
        except:
            return []      

    def _real_extract_photos(self, url):   
        return self._real_extract_method1(url, 'photos')    

    def _real_extract(self, url):
        arrayList = url.split('?server=')
        servers = ['photoss', 'drive1', 'drive2', 'drive3', 'drive4', 'vip', 'youtu', 'photo', 'photos', 'rapidvideo', 'streamango', 'openload']
        if len(arrayList)>1: servers.insert(0, arrayList[1])
        webpage = self._download_webpage(url, url)

        self.title = self._search_regex(r'<title>(.+)</title>', webpage, 'title')
         
        filmId = self._search_regex(r'var filmId = "(.+?)"', webpage, 'filmId')
        netloc = compat_urllib_parse_urlparse(url).netloc
        scheme = compat_urllib_parse_urlparse(url).scheme
        result = None
        for server in servers:       
            query_iframeUrl = '%s://%s/ajax-get-link-stream/?server=%s&filmId=%s' % (scheme, netloc, server, filmId)
            iframeUrl = self._download_webpage(query_iframeUrl, query_iframeUrl, fatal=False)
            if iframeUrl.find('there.to') > -1:
                result = self._real_extract_vip(iframeUrl)
            if iframeUrl.find('comedyshow.to') > -1:   
                result = self._real_extract_comedyshow(iframeUrl)     
            if iframeUrl.find('cartoonwire.to') > -1:                   
                result = self._real_extract_cartoonwire(iframeUrl)                     
            if iframeUrl.find('comicsonline.to') > -1:                   
                result = self._real_extract_comicsonline(iframeUrl)   
            if iframeUrl.find('zmovies.to') > -1:                   
                result = self._real_extract_zmovies(iframeUrl)      
            if iframeUrl.find('hydrax.net') > -1:       
                result = self._real_extract_hydrax(iframeUrl)                                         
            print(iframeUrl)                
            if result: break

        return result   

        
                                                           
class idocdnVIPIE(InfoExtractor):

    def _real_extract(self, url):
        url, smuggled_data = unsmuggle_url(url)
        #qs = compat_parse_qs(compat_urllib_parse_urlparse(url).query)    
        query = {'key': smuggled_data['key'], 'type': smuggled_data['type'], 'value': smuggled_data['value']}    
        webpage = self._download_webpage(url, '', data=urlencode_postdata(query))
        keyAndIV = re.findall(r'hd.+?"hash":"(.+?)".+?"iv":"(.+?)"', webpage)
        if not keyAndIV:
            keyAndIV = re.findall(r'sd.+?"hash":"(.+?)".+?"iv":"(.+?)"', webpage)
        key, iv = keyAndIV[0]
        jsTemplte = '<script>var obj = ' + webpage + '''
        function get(t, e) {
                var n = "#EXTM3U\\n#EXT-X-VERSION:4\\n#EXT-X-PLAYLIST-TYPE:VOD\\n#EXT-X-TARGETDURATION:" + t.duration + "\\n#EXT-X-MEDIA-SEQUENCE:0\\n";
                void 0 !== t.hash && t.hash && (n += "#EXT-X-HASH:" + t.hash + "\\n");
                var i = 0,
                r = 0,
                o = t.id || null,
                a = t.ids || null,
                c = t.expired || t.sig || null,
                s = t.datas || null,
                u = t.ranges || null,
                l = u ? u.length : 0;
                if (s) {
                    o = e.length;
                    for (var h = 0; h < l; h++) {
                        for (var f, d = s[h].file, p = 0; p < u[h].length; p++) {
                            var y = l <= h + p + 1 ? l <= p + 1 ? s[0].file : s[p + 1].file : s[h + p + 1].file;
                            i < o ? (f = e[i], i++) : (i = 1, f = e[0]),
                            a = u[h][p],
                            f = "https://" + f,
                            n += "#EXTINF:" + t.extinfs[r] + ",\\n",
                            n += "#EXT-X-BYTERANGE:" + a + "\\n",
                            n = c ? n + (f + "/") + c + "/" + d + "/" + a + "/" + y + "\\n" : n + (f + "/") + r + "/" + d + "/" + a + "/" + y + "\\n",
                            r++
                        }
                        l == h + 1 && (n += "#EXT-X-ENDLIST")
                    }
                } else if (a){
                    if (u)
                        for (h = 0; h < l; h++) {
                            for (d = a[h], p = 0; p < u[h].length; p++)
                                y = l <= h + p + 1 ? l <= p + 1 ? a[0] : a[p + 1] : a[h + p + 1], "object" == typeof e.redirect ? i < e.redirect.length ? (s = e.redirect[i], i++) : (i = 1, s = e.redirect[0]) : s = e.redirect, n += "#EXTINF:" + t.extinfs[r] + ",\\n", 1 < u[h].length && (n += "#EXT-X-BYTERANGE:" + u[h][p] + "\\n"), n += "https://" + s + "/redirect/" + c + "/" + o + "/" + d + "/" + y + "\\n", r++;
                            l == h + 1 && (n += "#EXT-X-ENDLIST")
                        }
                    else{
                        for (h = 0; h < a.length; h++)
                            d = a[h], y = a.length <= h + 1 && a.length <= h + 1 ? a[0] : a[h + 1], "object" == typeof e.redirect ? i < e.redirect.length ? (s = e.redirect[i], i++) : (i = 1, s = e.redirect[0]) : s = e.redirect, n += "#EXTINF:" + t.extinfs[r] + ",\\n", n += "https://" + s + "/redirect/" + c + "/" + o + "/" + d + "/" + y + "\\n", r++, a.length == h + 1 && (n += "#EXT-X-ENDLIST");
            }
            }
            if(window.external){
                window.external.output('<MyManifest>' + n + '</MyManifest>');
            }else{
                window.WebViewJavascriptBridge.callHandler('JSSendToOC','<MyManifest>' + n + '</MyManifest>');
            }
        }
        key  = 'hd' in obj ? 'hd' : 'sd'
        get(obj[key],obj['servers']);
        </script>'''

        webpage = downloadWebPage_BYHeadlessBrowser_localFile(jsTemplte)
        m3u8doc = self._search_regex(r'<MyManifest>([\s\S]+)<\/MyManifest>', webpage, 'm3u8doc')  
        m3u8doc = m3u8doc.replace('\n#EXTINF','\n#EXT-X-KEY:METHOD=AES-128,KEY="%s",IV="%s"\n#EXTINF' %(key, iv))
        #part_urls = re.findall('#EXT-X-BYTERANGE\:(\d+)@(\d+)[\s\S]+?(https://.+?)\n', m3u8doc)
        part_urls = re.findall('(#EXT-X-KEY[\s\S]+?http.+)\n', m3u8doc)
        
        parts = []
        for idx, item in enumerate(part_urls):                
            part_url = re.findall('(https.+)', item)[0]
            part = {
                'id': idx,
                'title': 'part%d' % idx,
                'url': part_url,
                'http_headers': {
                    'origin': smuggled_data['origin'],
                },
                'ext': 'ts',
                'decryptMethod': 'aes-128',
                'key': key,
                'iv' : iv,
                'filesize': 1024*1024*2
            }
            query_range = re.findall('#EXT-X-BYTERANGE\:(\d+)@(\d+)', item)
            if query_range:
                part['http_headers']['range'] = 'bytes=%s-%s' % (query_range[0][1], int(query_range[0][1]) + int(query_range[0][0]))                    

            parts.append(part)
            
        self._downloader.params['playlistend'] = -1
        print('kissasian hx end')
        return {
            '_type': 'multi_video',
            'id': 'v_id',
            'entries': parts,       
        } 