# coding: utf-8
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor
from ..extractor.vimeo import VHXEmbedIE

class lesmillsondemandIE(InfoExtractor):
    IE_NAME = 'lesmillsondemand'
    _VALID_URL = r'https?://(?:watch\.)?lesmillsondemand\.com/.+'    

    def _real_extract(self, url):    
        webpage = self._download_webpage(url, url)
        title = self._html_search_regex(r'<title>(.*?)</title>', webpage, 'title')
        
        iframe_url = self._search_regex(r'src="(https://embed\.vhx\.tv/[^"]+)', webpage, 'iframe')
        return {
            '_type': 'url_transparent',
            'ie_key': VHXEmbedIE.ie_key(),
            'url': iframe_url,
            'id': title,
            'title': title
        }
        
                       