#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..extractor.kaltura import KalturaIE as Old
from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
)

class manoramamaxIE(InfoExtractor):    
    #https://www.manoramamax.com/details/_6097031934001
    #https://www.manoramamax.com/page/5d39085623eec6001c799757?clip=_6097290177001&season=5d390892a0e845001caee24e
    _VALID_URL = r'https?://(?:.+\.)?manoramamax\.com/(?:details|page)/.*_(?P<id>\d+)|https?://(?:.+\.)?manoramamax\.com/(?:details|page)'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, '')

        accountId = self._search_regex(r'"accountId":"(\d+)', webpage, '123123')
        if video_id == 'None':
            video_id = self._search_regex(r'"assetId":"(\d+)', webpage, '123123')
        json_url = 'https://edge.api.brightcove.com/playback/v1/accounts/'+ accountId+ '/videos/' + video_id

        jsurl = self._search_regex(r'<script src="https://players.brightcove.net/'+accountId + '/(.*?)/index.min.js"></script>',webpage,'12315')
        alljs = self._download_webpage('https://players.brightcove.net/' +accountId +'/'+ jsurl + '/index.min.js','js')

        policyKey = self._search_regex(r'policyKey:"(.*?)"', alljs, '123123')
        if policyKey:
            response = self._download_json(json_url,'', 'manoramamax', headers={'Accept': 'application/json;pk='+ policyKey,'Origin':'https://www.manoramamax.com'})
        else:
            response = self._download_json(json_url, '', 'manoramamax', headers={
                'Accept': 'application/json;pk=BCpkADawqM2jz3GQNtAGiFiMclMF_vNBvuJsBKhNc-fOaJCiYieTXTwz5qEPfpkeTAK3oxdMTc4I9yqaXIGJTqDIiVn5XQcy3pQ675YFhXUeD0XO8mXaMwurXFaQLi9pxCua2khhHVFATi3N6OQ5zJNeygjikBJuIt0MKf7ryjgiXEJlbjbDWoDkTxg',
                'Origin': 'https://www.manoramamax.com'})
        formats = []
        sources = response['sources']
        sources = [source for source in sources if source['type'] == 'application/x-mpegURL']
        formats.extend(self._extract_m3u8_formats(
            sources[0]['src'], video_id, 'mp4', m3u8_id='hls', fatal=False))
            

        self._sort_formats(formats)

        return {
            'id': 'video_id',
            'formats': formats,
            'title': response.get('name', 'title'),
            'thumbnail': response.get('thumbnail', None)
        }
