# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
from ..extractor.common import InfoExtractor
from ..utils import determine_ext
import re

class Movies123IE(InfoExtractor):
    _VALID_URL = r'https?://(?:www\w?\.)?123movies?\.\w+/'

    def _real_extract(self, url):
        # https://123movies.film/film/the-handmaid-s-tale-season-1-2017.74909/watching.html?episode_id=93254
        if '.film' in url:
            return self._extract_film(url)

        # http://123movies.net/watch/GpDJMmgG-shooter-season-2/episode-8.html/watching.html
        # 以net结尾的，它嵌入的url代码经base64编码，存于代码中，解之
        if '.net' in url:
            return self._extract_net(url)

        # http://123movies.sc/watch-clouds-of-sils-maria-2014-123movies.html/watching.html
        # 此网站通常引用openload网站视频，解析出来，丢给它
        if '.sc' in url or '.ag' in url:
            return self._extract_sc(url)

        # https://www1.123movie.cc/movies/how-to-train-your-dragon/
        if '.cc' in url:
            return self._extract_cc(url)

        # https://www1.123movies.solar/15093-the-perverts-guide-to-cinema.html#/watching.html
        if '.solar' in url:
            return self._extract_solar(url)

        # 判断是否跳转
        try:
            wb = self._request_webpage(url, 'video_id')
            if wb and wb.code == 200 and wb.url != url:
                return self.url_result(wb.url)
        except:
            pass

        # https://123movies.co/movie/baby-driver-free112/?watching=HNGgShnEZp/watching.html
        webpage = self._download_webpage(url, 'video_id')
        # 需要再中转
        if '<meta http-equiv="refresh"' in webpage:
            real_url = self._search_regex(r'url=([^"]+)', webpage, 'real_url')
            return self.url_result(real_url)
        if '<div class="ds_seriesplay dsclear">' in webpage:
            real_url = self._search_regex(r'<div class="ds_seriesplay dsclear">\s*<a href="([^"]+)', webpage, 'real_url')
            return self.url_result(real_url)

        # 内嵌url http://123movies.md/movies/the-mummy-2017/
        frame_url = self._search_regex(r'<div class="embed">\s*<iframe[^>]+src="([^"]+)"', webpage, 'frame_url', fatal=False)
        if frame_url:
            return self.url_result(frame_url)

        # 内嵌播放器，putstream
        frame_url = self._search_regex(r'<div class="videoPlayer">\s*<iframe[^>]+src="([^"]+)"', webpage, 'frame_url', fatal=False)
        if frame_url:
            return self.url_result(frame_url)

        # 其它类型frame
        frame_url = self._search_regex(r'<iframe[^>]+src="([^"]+)"', webpage, 'frame_url', fatal=False)
        if frame_url:
            return self.url_result(frame_url)

        return super(Movies123IE, self)._real_extract(url)


    def _extract_film(self, url):
        webpage = self._download_webpage(url, 'video_id')
        # 此类视频，为m3u8格式
        video_id = self._search_regex(r'load_player\(\'([^\']+)?', webpage, 'video_id', fatal=False)
        # 需走m3u8解析
        if video_id:
            title = self._search_regex(r',\s+name:\s+"([^"]*)', webpage, 'title', fatal=False)
            if not title:
                title = self._og_search_title(webpage)
            title = title.replace('Watch The ', '')
            src_url = 'https://123movies.vg/ajax/v2_get_sources?id=%s' % video_id
            media_data = self._download_json(src_url, 'media_data')
            if media_data:
                play_url = media_data.get('value', '')
                if play_url:
                    if play_url.index('//') == 0:
                        play_url = 'https:' + play_url
                    if not media_data.get('embed', False) and not media_data.get('ads', False):
                        headers = {
                            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36',
                            'Referer': url
                        }
                        webpage = self._download_webpage(play_url, 'playlist', headers=headers)
                        if webpage:
                            webpage = webpage.replace('\\/', '/')
                            video_url = self._search_regex(r'(https://[^"]*)', webpage, 'video_url')
                            if video_url and 'm3u8' in video_url:
                                formats = [{
                                    'format_id': '-'.join(filter(None, [None, 'meta'])),
                                    'url': video_url,
                                    'ext': 'mp4',
                                    'protocol': 'm3u8',
                                }]

                                return {
                                    'id': video_id,
                                    'title': title,
                                    'formats': formats
                                }
                    elif media_data.get('embed', False):
                        return self.url_result(play_url)

        return super(Movies123IE, self)._real_extract(url)


    def _extract_net(self, url):
        webpage = self._download_webpage(url, 'video_id')
        video_id = 'none'
        title = self._og_search_title(webpage)
        description = self._og_search_description(webpage)
        thumbnail = self._og_search_thumbnail(webpage)

        import base64
        base64_str = self._search_regex(r'Base64.decode\("([^"]+)"\)', webpage, 'base64_str', fatal=False)
        frame_str = base64.decodestring(base64_str.encode('utf-8')).decode('utf-8')
        frame_url = self._search_regex(r'<iframe[^>]+src="([^"]+)"', frame_str, 'frame_url', fatal=False)
        if not frame_url:
            return super(Movies123IE, self)._real_extract(url)

        webpage = self._download_webpage(frame_url, 'video_id')
        video_url = self._search_regex(r'<source[^>]+src="([^"]+)"', webpage, 'base64_str', fatal=False)
        if not video_url:
            return super(Movies123IE, self)._real_extract(url)

        return {
            'id': video_id,
            'title': title,
            'thumbnail': thumbnail,
            'description': description,
            'url': video_url,
            'ext': 'mp4',
            'http_headers': {
                # 验证发现，下载需如此设其头，清除User-Agent，加入Referer
                'User-Agent': '',
                'Referer': frame_url,
            },
        }


    def _extract_sc(self, url):
        # 抠取所需参数
        webpage = self._download_webpage(url, 'video_id')
        # 求可用视频组合
        pattern = r"ip_build_player\(([^,]+),'([^\']*)','([^\']*)',([^\)]*)"
        m = re.search(pattern, webpage)
        if not m:
          return super(Movies123IE, self)._real_extract(url)

        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36',
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        }

        def _get_video_result(video_url):
            video_id = 'none'
            title = self._og_search_title(webpage)
            description = self._og_search_description(webpage)
            thumbnail = self._og_search_thumbnail(webpage)

            return {
                'id': video_id,
                'title': title,
                'thumbnail': thumbnail,
                'description': description,
                'ext': determine_ext(video_url),
                'url': video_url,
                'http_headers': headers,
            }

        def get_video_url(fix_code):
            # 此请求网址，可得一s值，并以其为请求key，再求得内嵌网址
            post_url = 'http://123movies.sc/ip.file/swf/plugins/ipplugins.php'
            post_data = {
                'ipplugins': 1,
                'ip_film': m.group(1),
                'ip_server': m.group(2),
                'ip_name': m.group(3),
                'fix': fix_code
            }
            play_data = self._download_json(post_url, 'video_id', headers=headers, query=post_data)
            if not play_data or not 's' in play_data or 'error' in play_data['p']:
                return None

            # 取出其s值，以求所引用之视频网址，验证其引用openload.co视频内网，但直转至openload解析失败，故此再拿其信息
            key_s = play_data['s']
            post_url = 'http://123movies.sc/ip.file/swf/ipplayer/ipplayer.php?u=%s&s=%s&n=%s' % (key_s, m.group(2), fix_code)
            media_info = self._download_json(post_url, 'media_info')
            if not media_info or not 'data' in media_info:
                return None

            video_url = media_info['data']
            if not video_url:
                return None

            if not 'https:' in video_url and '//' in video_url:
                video_url = 'https:' + video_url
            if 'openload' in video_url:
                # 检测链接是否可用
                hash_value = media_info['hash']
                if hash_value:
                    check_url = 'https://123movies.sc/ip.file/swf/ipplayer/api.php?hash=%s' % hash_value
                    status = self._download_json(check_url, 'status_info')
                    if status and status.get('status', False):
                        return video_url
                    return None

                return video_url
            else:
                return video_url

        # 求openload网址，# 做3次匹配
        for fix in range(3):
            video_url = get_video_url(fix)
            if video_url:
                if 'openload' in video_url:
                    return self.url_result(video_url)
                # 返回可以下载的，它或者可能是m3u8
                return _get_video_result(video_url)

        return super(Movies123IE, self)._real_extract(url)

    def _extract_cc(self, url):
        if not url.endswith('/'):
            url = url + '/'
        video_id = self._search_regex(r'movies/(.+)/', url, 'video id', default=None)
        if not video_id:
            return super(Movies123IE, self)._real_extract(url)

        webpage = self._download_webpage(url, 'video_id')
        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36',
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'Referer': 'https://www1.123movie.cc/movies/%s/' % video_id
        }

        # 求rapidvideo分支
        if 'rapidvideo' in webpage:
            url = 'https://www1.123movie.cc/meego/grabber.php?ep=%s&server_name=rapidvideo&type=movies' % video_id
            webpage = self._download_webpage(url, 'video_id', headers=headers)
            video_url = self._html_search_regex(r'<iframe[^>]+src="([^"]+)', webpage, 'video url', default=None)
            # 求跳转地址
            if video_url:
                wb = self._request_webpage(video_url, 'video_id', headers=headers)
                if wb and wb.code == 200 and wb.url != url:
                    return self.url_result(wb.url)
        # openload 一支
        elif 'openload' in webpage:
            url = 'https://www1.123movie.cc/meego/grabber.php?ep=%s&server_name=openload&type=movies' % video_id
            webpage = self._download_webpage(url, 'video_id', headers=headers)
            video_url = self._html_search_regex(r'<iframe[^>]+src="([^"]+)', webpage, 'video url', default=None)
            # 求跳转地址
            if video_url:
                wb = self._request_webpage(video_url, 'video_id', headers=headers)
                if wb and wb.code == 200 and wb.url != url:
                    return self.url_result(wb.url)

        return super(Movies123IE, self)._real_extract(url)

    def _extract_solar(self, url):
        webpage = self._download_webpage(url, 'video_id')
        # 找openload 网址
        if 'openload' in webpage.lower():
            video_url = self._search_regex(r'(?isx)openload.*?data-link="(?P<url>[^"]+)', webpage, 'video url', default=None)
            if video_url:
                return self.url_result(video_url)

        return super(Movies123IE, self)._real_extract(url)