# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor

class PowtoonIE(InfoExtractor):
    # https://www.powtoon.com/online-presentation/fz4lxkkm3Xk/?mode=movie
    # https://www.powtoon.com/c/frsu2KT0bMm/1/m
    # https://www.powtoon.com/html5-studio/#/edit/fzfvYtDUaHC
    _VALID_URL = r'https?://(?:www\.)?powtoon\.com/.+/(?P<id>\w{11})'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        try:
            api_url = r'https://www.powtoon.com/api/v2/powtoons/%s?include_content=true' % video_id
            headers = {'Accept': 'application/json'}
            video_data = self._download_json(api_url, video_id, headers=headers)
            video_url = video_data['external_url']
            raise
            if video_url:
                return self.url_result(video_url)

            # https://www.powtoon.com/online-presentation/fI9nmoEkOrZ/wedding-invitation-main/?mode=movie
            # 这一种，直接在canvas上画的，下不下来
            return super(PowtoonIE, self)._real_extract(url)
        except:
            webpage = self._download_webpage(url, url)
            title = self._search_regex(r'presentoon_name\s*=\s*\'([^\']+)', webpage, '')
            iframe_src = self._search_regex(r'iframeSrc\s*=\s*\'([^\']+)', webpage, '')
            #url = 'https://www.powtoon.com/player/html-player/release/97.0.1/14442355c-1590483629/index.html?powtoon=bMyNxZrIiZ9&version=2020-05-20-1589949656&hostname=https%3A%2F%2Fwww.powtoon.com&watermark=regular&core_player_version=hotfix/96.1.12/4e2ac36-1589982333&core_player_url=https://apps.powtoon.co/player/core-player/hotfix/96.1.12/4e2ac36-1589982333/index.js&show_scene_watermark=true&use_canvas_player=true'
            return {
                'id': video_id,
                'title': title,
                'formats' :[{
                    'url': iframe_src,              
                    'SpecialDownloader': 'powtoonDownloader',
                    'ext': 'mp4'
                }]
            }