# coding: utf-8
# 2019-04-11, liujw
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re

from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
    float_or_none,
)


class QQIE(InfoExtractor):
    # https://v.qq.com/x/cover/rxqx32noqzdvziw/s0854s1zdp6.html
    # https://v.qq.com/x/cover/x6aayd03yfxv3bv.html
    _VALID_URL = r'https?://(?:.*\.)?qq\.com/.*/(?P<id>\w+).html?'


    def _real_extract(self, url):
        vid = self._match_id(url)
        if len(vid) != 11:
            webpage = self._download_webpage(url, url)
            vid = self._search_regex(r'vid=(\w{11})&', webpage, 'video_id')
            if not vid or len(vid) != 11:
                return super(QQIE, self)._real_extrace(url);

        def get_json(jsonp):
            return self._search_regex(r'({.*})', jsonp, None)

        video_data = self._download_json(
            'http://h5vv.video.qq.com/getinfo', vid, transform_source=get_json, query={
                'vid': vid,
                'platform': 10201,
                'otype': 'json',
                # 'defn': 'mp4', # default value is mp4, possible values: sd, hd, shd, fhd
            })
        video_info = video_data['vl']['vi'][0]
        title = video_info['ti']
        filename = video_info['fn']
        vkey = video_info['fvkey']
        width = int_or_none(video_info.get('vw'))
        height = int_or_none(video_info.get('vh'))
        server_info = video_info['ul']['ui'][0]
        base_url = server_info['url']
        vt = server_info['vt']
        info = {}
        current_format = next(fi for fi in video_data['fl']['fi'] if fi['sl'] == 1)
        parts = video_info.get('cl', {}).get('ci', [])
        if parts:
            entries = []
            for index, p in enumerate(parts, 1):
                part_filename = re.sub(r'(.*)\.(\w)', r'\1.%d.\2' % index, filename)
                vkey = self._download_json('http://h5vv.video.qq.com/getkey', vid, transform_source=get_json, query={
                    'vid': vid,
                    'platform': 10201,
                    'otype': 'json',
                    'format': current_format['id'],
                    'filename': part_filename,
                    'vt': vt,
                })['key']
                entries.append({
                    'id': '%s_part%d' % (vid, index),
                    'format_id': current_format.get('name'),
                    'title': title,
                    'url': base_url + part_filename + '?vkey=' + vkey,
                    'duration': float_or_none(p.get('cd')),
                    'width': width,
                    'height': height,
                })
            info.update({
                '_type': 'multi_video',
                'entries': entries,
            })
        else:
            info = {
                'format_id': current_format.get('name'),
                'url': base_url + filename + '?vkey=' + vkey,
                'duration': float_or_none(video_info.get('td')),
                'width': width,
                'height': height,
            }
        info.update({
            'id': vid,
            'title': title,
        })
        return info