#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
)
from ..utilsEX import (
    url_result
)

class rijutvIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?rijutv\.com/player/(?P<id>\d+)'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, '')
        title = self._html_search_regex(r'<title>(.+)</title>', webpage, '')
        iframe_src = 'https:' + self._search_regex(r'<iframe\s+id="playPath".+src=\"([^\"]+)', webpage, '123123', fatal=False)
        webpage = self._download_webpage(iframe_src, '')
        m3u8_url = self._search_regex(r'url\:\s*\'(.+/(?:index|playlist)\.m3u8)\'', webpage, '123123', fatal=False)
        formats = []
        formats.extend(self._extract_m3u8_formats(
            m3u8_url, video_id, 'mp4', m3u8_id='m3u8', fatal=False))        
        
        return {
            'id': video_id,
            'formats': formats,
            'title': title,
        }            
        
class rijutvEpisodeIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?rijutv\.com/(?:riju|dongman)/(?P<id>\d+)\.html'

    def _real_extract(self, url):
        playlist_id = self._match_id(url)
        webpage = self._download_webpage(url, '')
        title = self._html_search_regex(r'<title>(.+)</title>', webpage, '')
        ids = re.findall(r'target="_blank" href="/player/(\d+)\.html', webpage)

        entries = [url_result('https://www.rijutv.com/player/{0}.html'.format(id), 'rijutv', video_id=id, video_title=id, video_duration='02:00') for id in ids]

        return {
            '_type': 'playlist',
            'id': playlist_id,
            'title': title,         
            'entries': entries,
        }        