#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys 
import threading
import json
import urllib.request

try:
    import Queue
except:
    
    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url,
    ExtractorError,
    xpath_text,
    url_or_none,
    int_or_none,
    determine_ext
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs,
    compat_xpath
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, downloadWebPage_BYHeadlessBrowser_localFile

class RtvsloIE(InfoExtractor):    
    _VALID_URL = r'https?://4d\.rtvslo\.si'

    def _real_extract(self, url):
        print('rtvslo.si begin')

        alist = re.findall(r'/(\d+)$', url)

        if len(alist) == 0:
            return {}
        videoId = alist[0]

        print('api1 start...')
        apiUrl = r'https://api.rtvslo.si/ava/getRecordingDrm/{}?callback=ava_521&client_id=82013fb3a531d5414f478747c1aca622&session_id='.format(videoId)
        apiRespone = self._download_webpage(apiUrl, 'embVideo_url')  #urllib.request.urlopen(apiUrl).read().decode()
        print('api1 end...')


        apiRespone = apiRespone.strip()
        head = re.findall(r'(^.+\d+\()', apiRespone)
        if len(head) > 0:
            apiRespone = apiRespone.replace(head[0], '')
        tail = re.findall(r'\);$', apiRespone)
        if len(tail) > 0:
            apiRespone = apiRespone.replace(tail[0], '')
        
        apiJson = json.loads(apiRespone)
        
        jwt =  apiJson['response']['jwt']
        idstr = head[0].replace('(', '')

        print('api2 start...')
        api2Url = r'https://api.rtvslo.si/ava/getMedia/{}?callback={}&client_id=82013fb3a531d5414f478747c1aca622&session_id=&jwt={}'.format(videoId, idstr, jwt)
        api2Respone = self._download_webpage(api2Url, 'embVideo_url').strip()
        print('api2 end...')
        
        head2 = re.findall(r'(^.+\d+\()', api2Respone)
        if len(head2) > 0:
            api2Respone = api2Respone.replace(head2[0], '')
        tail2 = re.findall(r'\);$', api2Respone)
        if len(tail2) > 0:
            api2Respone = api2Respone.replace(tail2[0], '')
        apiJson = json.loads(api2Respone)
                
        types = 'mp4'
        try:
            types = str(apiJson['response']['mediaFiles'][0]['mediaType']).lower()
            print('mediaType: ' + types)
            if types == 'mp3':
                downloadUrl =  apiJson['response']['mediaFiles'][0]['streams']['https']
            if types == 'mp4':
                downloadUrl =  apiJson['response']['mediaFiles'][0]['streams']['http']
            print(downloadUrl)

            webpage = self._download_webpage(url, 'embVideo_url')
            title = self._search_regex(r'<title>(.+)</title>', webpage, '', fatal=False) or 'title'

            formats =  [{'url': downloadUrl,
                        'ext': types
                        }]
                        
            return {
                'id': 'id',
                'formats': formats,
                'title': title
            }
        except Exception as e:
            print(e)