#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************

from __future__ import unicode_literals
import re
import json

from ..extractor.kaltura import KalturaIE as Old
from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    js_to_json
)

class Soap2dayIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?soap2day\.com/.+_(?P<id>.+)\.html'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, '')
        title = self._html_search_regex(r'<h4>(.+)?</h4>', webpage, video_id, default='Scaop2day', fatal=False)
        response = self._download_json('https://www.soap2day.com/home/index/GetMInfoAjax', video_id=video_id, headers={'referer': url}, data=urlencode_postdata({'pass': video_id}), transform_source=js_to_json)
        if response['val'].find('http') == -1:
            response = self._download_json('https://www.soap2day.com/home/index/GetEInfoAjax', video_id=video_id, headers={'referer': url}, data=urlencode_postdata({'pass': video_id}), transform_source=js_to_json)
        if response['val'].find('http') == -1:
            response = self._download_json('https://www.soap2day.com/home/index/getsurl', video_id=video_id, headers={'referer': url}, data=urlencode_postdata({'pass': video_id}), transform_source=js_to_json)
        
        return {
            'id': 'video_id',
            'formats': [{
                'url': response['val'],
                'ext': 'mp4'
            }],
            'title': title,
        }
