#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys 
import threading

try:
    import Queue
except:
    
    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, downloadWebPage_BYHeadlessBrowser_localFile

class SockShareIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?sockshare\.net/'

    def _real_extract(self, url):
        print('SockShare begin')
        
        url = self._search_regex(r'(.+\.html)', url, 'url')
        js = '''var vp = document.getElementsByClassName('player')[0].getElementsByTagName('iframe')[0]; if (vp && vp.src) { window.external.output('<video id="kv_player" src="' + vp.src + '" alt="' + document.title + '" />'); } else { window.external.output('nothing...'); }'''
        if sys.platform != 'win32':
            js = '''var vp = document.getElementsByClassName('player')[0].getElementsByTagName('iframe')[0];
                    if (window.WebViewJavascriptBridge && vp && vp.src) { 
                        window.WebViewJavascriptBridge.callHandler('JSSendToOC','<video id="kv_player" src="' + vp.src + '" alt="' + document.title + '" />'); 
            }'''
        print('SockShare normal')
        webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)
        if 'kv_player' in webpage:
            embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')
            title = self._search_regex(r'alt="([^"]+)"', webpage, 'video_url')
            return {
                '_type': 'url_transparent',
                'url': embVideo_url,
                'title': title
            }
            # webpage = self._download_webpage(embVideo_url, 'embVideo_url') 
            # v_id = self._search_regex(r'gaobook.review/v/(.+)', embVideo_url, 'v_id', fatal = False)
            # if v_id:
            #     jsondata = self._download_json("https://www.gaobook.review/api/source/%s" % v_id, v_id, data=urlencode_postdata({'d': 'www.gaobook.review'}))
                            
            #     formats = [{
            #         'format_id': item['label'].strip(),
            #         'url': item['file'],
            #         'width': item['label'].strip(),
            #         'ext': item['type']
            #     } for item in jsondata['data']]   
            #     print('kissasian end')         
            #     return {
            #         'id': v_id,
            #         'title': title,
            #         'formats': formats,                
            #     }            
        else: 
            return self._hx_extract(url, js)
