#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************

from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..extractor.vimeo import VimeoIE

from ..utils import (
    int_or_none,
    merge_dicts,
    urlencode_postdata
)
from ..utilsEX import (
    url_result
)

class stockfeelIE(InfoExtractor):    
    #https://www.stockfeel.com.tw/video_page/?watch=bnI1cnN3Q2ZKc1prUjVLWUNoVStzbTJCc2dDVTZFTXlPSFA0b2xZazh0OD0=
    _VALID_URL = r'https?://(?:.+\.)?stockfeel\.com\.tw/video_page/.*'

    def _real_extract(self, url):
        video_id = '123'
        webpage = self._download_webpage(url, video_id)

        hash_id = self._search_regex(r'hash_id\s*=\s*\'([^\']+)', webpage, 'hash_id', default=None)
        result = self._download_json('https://stockfeelapi.com/video/getVideoId', video_id, data=urlencode_postdata({'hash_id': hash_id, 'cookie_id': None}))        
        #"referrer":url

        #{"status":"success","result":{"id":"34"}}
        vid = result['result']['id']
        result = self._download_json('https://stockfeelapi.com/video/getVideoByid', video_id, data=urlencode_postdata({'id': vid, 'cookie_id': None}))['result']                      
        vimeo_id = result['vimeo_id']
        # 'https://player.vimeo.com/video/%s?controls=0&api=1&playsinline=1' % vimeo_id
        info = {
            '_type': 'url_transparent',
            'title': result['title'],
            'thumbnail': result['vimeo_thumbnail']
        }

        return merge_dicts(info, self.url_result(
            VimeoIE._smuggle_referrer(
                'https://player.vimeo.com/video/%s' % vimeo_id, url),
            ie=VimeoIE.ie_key(), video_id=vimeo_id))