# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

from ..extractor.streamango import StreamangoIE as StreamangoBase, determine_ext
# 这个函数，解不了此页面上的packer加密，格式不对
from ..utils import decode_packed_codes
from ..utilsEX import execjs_execute, downloadWebPage_BYHeadlessBrowser
import re

class StreamangoIE(StreamangoBase):
    # 解密视频地址，反替换回去
    def _download_webpage(self, url_or_request, video_id, note=None, errnote=None, fatal=True, tries=1, timeout=5,
                          encoding=None, data=None, headers={}, query={}):
        webpage = super(StreamangoIE, self)._download_webpage(url_or_request, video_id, note, errnote, fatal, tries, timeout,
                                                              encoding, data, headers, query)
        try:
            # 解出加密代码
            pattern = r'eval\((.+)\)'
            packed_js = self._search_regex(pattern, webpage, 'js_code')

            import execjs
            js = execjs.eval(packed_js)
            js = js.replace('window.d=function', 'function f')
            # src:d('guDNKZ3bNKLfQ6jRg6zRQODKgqwRN6HPNqHTJ57SNp7PO53RPpIPaN8Lat4QZ9wNM98LZeIOad4SZeIQM63KLanIOMvngt0Ma=AA',174)
            m = re.search(r"src:d\('([^']+)',(\d+)\)", webpage)
            arg1 = m.group(1)
            arg2 = m.group(2)
            video_src = execjs_execute(js, 'f', arg1, arg2)
            webpage = re.sub(r"d\('[^']+',\d+\)", '"%s"' % video_src, webpage)
        except:
            pass
        return webpage

    def _real_extract(self, url):
        try:
            result= super(StreamangoIE, self)._real_extract(url)
            return result
        except:
            pass

        video_id = self._match_id(url)
        webpage = self._download_webpage(url, video_id)
        title = self._og_search_title(webpage, default='x')

        formats = []
        for format_ in re.findall(r'({[^}]*\bsrc\s*:\s*[^}]*})', webpage):
            mobj = re.search(r'src\s*:\s*"([^"]+)', format_)
            if mobj is None:
                continue

            src = self._proto_relative_url(mobj.group(1))


            ext = determine_ext(src, default_ext=None)
            if ext == 'mpd':
                formats.extend(self._extract_mpd_formats(
                    src, video_id, mpd_id='dash', fatal=False))
            else:
                formats.append({
                    'url': src,
                    'ext': ext or 'mp4',
                })


        self._sort_formats(formats)

        return {
            'id': video_id,
            'url': url,
            'title': title,
            'formats': formats,
        }