# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys
import threading
import json

try:
    import Queue
except:

    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url,
    ExtractorError,
    xpath_text,
    url_or_none,
    int_or_none,
    determine_ext
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs,
    compat_xpath
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, \
    downloadWebPage_BYHeadlessBrowser_localFile

class StudyIE(InfoExtractor):
    _VALID_URL = r'https?://(?:.+\.)?study\.com/'

    def _real_extract(self, url):
        print('SockShare begin')

        webpage = self._download_webpage(url, 'embVideo_url')
        jsonIds = re.findall(r'data-wistiaid="(.*?)"', webpage)
        if jsonIds:
            jsonId = jsonIds[0]
        jsonurl = "https://fast.wistia.com/embed/medias/" + jsonId + ".json?callback=wistiajson1"
        thumb_url = ""
        title = re.findall(r'<title>(.*?)</title>',webpage)
        if title and len(title):
            title = title[0]
        headers = {"Referer":url}
        jsonInfo = self._download_webpage(jsonurl, video_id = jsonId, headers=headers)
        jsonresult = jsonInfo.replace('/**/wistiajson1(', '')[0:-1]
        jsonobj = json.loads(jsonresult)

        markitem= None
        markitems= jsonobj.get('media',None).get('assets',None)
        for item in markitems:
            if item.get('type')=='iphone_video':
                markitem = item
        if markitem:
            m3u8url = markitem.get('url')
        m3u8url = m3u8url[0:-3] +"m3u8?origin_v2=1"
        m3u8url = m3u8url.replace("embed-ssl.wistia.com","embedwistia-a.akamaihd.net")
        formats = self._extract_m3u8_formats(
            m3u8url, jsonId, 'mp4', entry_protocol='m3u8_native',
            m3u8_id='hls')

        return {
            'id': 'id',
            'formats': formats,
            'title': title,
            'thumbnail': thumb_url
        }
        pass
