# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import tempfile
import os
import io
import sys
from ..extractor.common import InfoExtractor
from ..utilsEX import downloadWebPage_BYHeadlessBrowser_withJS

class thisVid_IE(InfoExtractor):
    _VALID_URL = r'https?://(?:www\.)?thisvid\.com'

    def _real_extract(self, url):
        webpage = self._download_webpage(url, url)
        video_id = 'test'
        title = self._og_search_title(webpage, default=None) #or self._html_search_regex(r'<title[^>]*>([^<]+)</title>', webpage, 'title')
        js = '''function output(txt){
                                if (window.external){
                                    window.external.output(txt);
                                }
                                if (window.WebViewJavascriptBridge){
                                    window.WebViewJavascriptBridge.callHandler('JSSendToOC', txt);
                                }
                }
                var vf = document.getElementsByTagName('video')[0];
                var v_url = vf.getAttribute("src");
                output('<video id="kv_player" src="' + v_url + '"/>');
            '''
        webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)
        video_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')

        formats = [{
            'url': video_url,
            'ext': 'mp4'
        }]

        return {
            'id': video_id,
            'title': title,
            'formats': formats
        }